/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ConfigEntity;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ConfigUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3")
@Controller(value="mdiyConfig")
@RequestMapping(value={"/${ms.manager.path}/mdiy/config"})
public class ConfigAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IConfigBiz configBiz;

    @Hidden
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/config/index";
    }

    @Operation(summary="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelName", description="\u6a21\u578b\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="modelTableName", description="\u6a21\u578b\u8868\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="appId", description="\u5e94\u7528\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="modelJson", description="json", required=false, in=ParameterIn.QUERY), @Parameter(name="createBy", description="\u521b\u5efa\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="createDate", description="\u521b\u5efa\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="updateBy", description="\u4fee\u6539\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="updateDate", description="\u4fee\u6539\u65f6\u95f4", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"mdiy:config:view"})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        modelEntity.setModelCustomType(ModelCustomTypeEnum.CONFIG.getLabel());
        List<ModelEntity> modelList = this.modelBiz.query(modelEntity);
        return ResultData.build().success((Object)new EUListBean(modelList, (int)BasicUtil.endPage(modelList).getTotal()));
    }

    @Operation(summary="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelName", description="\u6a21\u578b\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="modelTableName", description="\u6a21\u578b\u8868\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="appId", description="\u5e94\u7528\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="modelJson", description="json", required=false, in=ParameterIn.QUERY), @Parameter(name="createBy", description="\u521b\u5efa\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="createDate", description="\u521b\u5efa\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="updateBy", description="\u4fee\u6539\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="updateDate", description="\u4fee\u6539\u65f6\u95f4", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getId()) && StringUtils.isBlank((CharSequence)modelEntity.getModelName())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
        }
        modelEntity.setModelCustomType(ModelCustomTypeEnum.CONFIG.getLabel());
        ModelEntity model = this.modelBiz.getByEntity(modelEntity);
        if (model == null) {
            return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("model.name")}));
        }
        if (!this.hasPermissions("mdiy:config:view", "mdiy:configData:" + model.getId() + ":view")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        return ResultData.build().success((Object)model);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:config:del"})
    public ResultData delete(@RequestBody List<ModelEntity> models, HttpServletResponse response, HttpServletRequest request) {
        List<String> ids = models.stream().map(ModelEntity::getId).collect(Collectors.toList());
        if (this.configBiz.delete(ids)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
    }

    @Operation(summary="\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @Parameters(value={@Parameter(name="modelJson", description="json", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u5bfc\u5165", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/importJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:config:importJson"})
    public ResultData importJson(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.configBiz.importConfig(ModelCustomTypeEnum.CONFIG.getLabel(), modelJsonBean)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(ModelEntity::getModelName, (Object)modelJsonBean.getTitle())).eq(ModelEntity::getModelCustomType, (Object)ModelCustomTypeEnum.CONFIG.getLabel());
            modelEntity = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)queryWrapper));
            ConfigEntity configEntity = ConfigUtil.getEntity(modelJsonBean.getTitle());
            return ResultData.build().success(this.configBiz.getOne((Wrapper)new LambdaQueryWrapper().eq(ConfigEntity::getModelId, (Object)modelEntity.getId())));
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("config.name")}));
    }

    @Operation(summary="\u66f4\u65b0\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @Parameters(value={@Parameter(name="modelJson", description="json", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u5bfc\u5165", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/updateJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:config:update"})
    public ResultData updateJson(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        if (StringUtils.isBlank((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.configBiz.updateConfig(modelEntity.getId(), modelJsonBean)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("config.name")}));
    }

    @Operation(summary="\u5237\u65b0\u914d\u7f6e\u7f13\u5b58\u63a5\u53e3")
    @PostMapping(value={"/updateCache"})
    @RequiresPermissions(value={"mdiy:config:update"})
    @ResponseBody
    public ResultData updateCache(HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        this.configBiz.updateCache();
        return ResultData.build().success();
    }
}

