/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.json.JSONUtil;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.strategy.IModelStrategy;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ConfigEntity;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ConfigUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/config/data"})
public class ConfigDataAction
extends BaseAction {
    @Autowired
    private IConfigBiz configBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IModelStrategy modelStrategy;

    @Hidden
    @GetMapping(value={"/form"})
    public String form(HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        return "/mdiy/config/data/form";
    }

    @Operation(summary="\u914d\u7f6e\u6570\u636e\u83b7\u53d6\u63a5\u53e3")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(HttpServletResponse response, HttpServletRequest request) {
        String modelId = BasicUtil.getString((String)"modelId");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        ModelEntity modelEntity = this.modelBiz.getById((Serializable)((Object)modelId));
        if (modelEntity == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
        }
        if (!this.hasPermissions("mdiy:configData:view", "mdiy:configData:" + modelEntity.getId() + ":view")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        ConfigEntity configEntity = ConfigUtil.getEntity(modelEntity.getModelName());
        if (configEntity == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("config.name")}));
        }
        return ResultData.build().success(configEntity.getConfigData() == null ? null : JSONUtil.parseObj((String)configEntity.getConfigData()));
    }

    @Operation(summary="\u66f4\u65b0\u81ea\u5b9a\u4e49\u914d\u7f6e")
    @LogAnn(title="\u66f4\u65b0\u81ea\u5b9a\u4e49\u914d\u7f6e", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    public ResultData update(HttpServletResponse response, HttpServletRequest request) {
        Map map = BasicUtil.assemblyRequestMap();
        String modelId = map.get("modelId").toString();
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        ModelEntity modelEntity = this.modelBiz.getById((Serializable)((Object)modelId));
        if (modelEntity == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
        }
        if (!this.hasPermissions("mdiy:configData:update", "mdiy:configData:" + modelEntity.getId() + ":update")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        ConfigEntity configEntity = ConfigUtil.getEntity(modelEntity.getModelName());
        if (configEntity == null) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("config.name")}));
        }
        List modelFields = JSONUtil.toList((String)modelEntity.getModelField(), Map.class);
        modelFields.forEach(field -> {
            if (map.get(field.get("model")) != null) {
                if (field.get("javaType").toString().equalsIgnoreCase("Integer")) {
                    map.put(field.get("model").toString(), Integer.parseInt(map.get(field.get("model")).toString()));
                }
                if (field.get("javaType").toString().equalsIgnoreCase("Boolean")) {
                    map.put(field.get("model").toString(), Boolean.parseBoolean(map.get(field.get("model")).toString()));
                }
            }
        });
        configEntity.setConfigData(JSONUtil.toJsonStr((Object)map));
        this.configBiz.updateById((Object)configEntity);
        this.configBiz.updateCache();
        return ResultData.build().success((Object)configEntity);
    }

    @Operation(summary="\u83b7\u53d6\u81ea\u5b9a\u4e49\u914d\u7f6e\u4e2d\u7684key\u6307\u5b9avalue\u503c\u63a5\u53e3")
    @Parameters(value={@Parameter(name="configName", description="\u914d\u7f6e\u540d\u79f0", required=true, in=ParameterIn.QUERY), @Parameter(name="key", description="\u914d\u7f6e\u7684key\u503c", required=true, in=ParameterIn.QUERY)})
    @GetMapping(value={"/getMap"})
    @ResponseBody
    public ResultData getMap(String configName, String key, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return ResultData.build().success((Object)ConfigUtil.getMap((String)configName));
        }
        return ResultData.build().success((Object)ConfigUtil.getString((String)configName, (String)key));
    }
}

