/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IDictBiz;
import net.mingsoft.mdiy.entity.DictEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/dict/data"})
public class DictDataAction
extends BaseAction {
    @Autowired
    private IDictBiz dictBiz;

    @Hidden
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/dict/data/index";
    }

    @Hidden
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute DictEntity dict, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        return "/mdiy/dict/data/form";
    }

    @Operation(summary="\u67e5\u8be2\u5b57\u5178\u8868\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="dictType", description="\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="dictLabel", description="\u6807\u7b7e\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="dictValue", description="\u6570\u636e\u503c", required=false, in=ParameterIn.QUERY), @Parameter(name="isChild", description="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, in=ParameterIn.QUERY)})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) DictEntity dict, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        if (StringUtils.isBlank((CharSequence)dict.getDictType())) {
            return ResultData.build().error("\u5b57\u5178\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.hasPermissions("mdiy:dict:view", "mdiy:dictData:" + dict.getDictType() + ":settings")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        BasicUtil.startPage();
        List dictList = this.dictBiz.query(dict);
        return ResultData.build().success((Object)new EUListBean(dictList, (int)BasicUtil.endPage((List)dictList).getTotal()));
    }

    @Operation(summary="\u83b7\u53d6\u5b57\u5178\u8be6\u60c5\u63a5\u53e3")
    @Parameter(name="id", description="\u5b57\u5178\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @Parameter(hidden=true) DictEntity dict, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        if (StringUtils.isBlank((CharSequence)dict.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("dict.id")}));
        }
        DictEntity _dict = (DictEntity)((Object)this.dictBiz.getById((Serializable)((Object)dict.getId())));
        if (StringUtils.isBlank((CharSequence)_dict.getDictType())) {
            return ResultData.build().error("\u5b57\u5178\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.hasPermissions("mdiy:dict:view", "mdiy:dictData:" + _dict.getDictType() + ":settings")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        return ResultData.build().success((Object)_dict);
    }

    @Operation(summary="\u4fdd\u5b58\u5b57\u5178\u63a5\u53e3")
    @Parameters(value={@Parameter(name="dictLabel", description="\u6807\u7b7e\u540d", required=true, in=ParameterIn.QUERY), @Parameter(name="dictType", description="\u7c7b\u578b", required=true, in=ParameterIn.QUERY), @Parameter(name="dictValue", description="\u6570\u636e\u503c", required=false, in=ParameterIn.QUERY), @Parameter(name="dictDescription", description="\u63cf\u8ff0", required=false, in=ParameterIn.QUERY), @Parameter(name="dictSort", description="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, in=ParameterIn.QUERY), @Parameter(name="isChild", description="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, in=ParameterIn.QUERY), @Parameter(name="dictRemarks", description="\u5907\u6ce8\u4fe1\u606f", required=false, in=ParameterIn.QUERY)})
    @LogAnn(title="\u4fdd\u5b58\u5b57\u5178\u63a5\u53e3", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    public ResultData save(@ModelAttribute @Parameter(hidden=true) DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        if (!this.hasPermissions("mdiy:dict:save", "mdiy:dictData:" + dict.getDictType() + ":settings")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictType())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.type")}));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictLabel())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.label")}));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictValue())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.value")}));
        }
        if (this.dictBiz.getByTypeAndLabelAndValue(dict.getDictType(), dict.getDictLabel(), null) != null) {
            return ResultData.build().error(this.getResString("diy.dict.type.and.label.repeat"));
        }
        if (this.dictBiz.getByTypeAndLabelAndValue(dict.getDictType(), null, dict.getDictValue()) != null) {
            return ResultData.build().error(this.getResString("diy.dict.type.and.value.repeat"));
        }
        this.dictBiz.save((Object)dict);
        this.dictBiz.updateCache();
        return ResultData.build().success();
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u5b57\u5178")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u5b57\u5178", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    public ResultData delete(@RequestBody List<DictEntity> dicts, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[dicts.size()];
        for (int i = 0; i < dicts.size(); ++i) {
            ids[i] = Integer.parseInt(dicts.get(i).getId());
        }
        if (!this.hasPermissions("mdiy:dict:del", "mdiy:dictData:" + dicts.get(0).getDictType() + ":settings")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        this.dictBiz.delete(ids);
        return ResultData.build().success();
    }

    @Operation(summary="\u66f4\u65b0\u5b57\u5178\u4fe1\u606f\u63a5\u53e3")
    @Parameters(value={@Parameter(name="id", description="\u5b57\u5178\u7f16\u53f7", required=true, in=ParameterIn.QUERY), @Parameter(name="dictLabel", description="\u6807\u7b7e\u540d", required=true, in=ParameterIn.QUERY), @Parameter(name="dictType", description="\u7c7b\u578b", required=true, in=ParameterIn.QUERY), @Parameter(name="dictValue", description="\u6570\u636e\u503c", required=false, in=ParameterIn.QUERY), @Parameter(name="dictDescription", description="\u63cf\u8ff0", required=false, in=ParameterIn.QUERY), @Parameter(name="dictSort", description="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, in=ParameterIn.QUERY), @Parameter(name="isChild", description="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, in=ParameterIn.QUERY), @Parameter(name="dictRemarks", description="\u5907\u6ce8\u4fe1\u606f", required=false, in=ParameterIn.QUERY)})
    @LogAnn(title="\u66f4\u65b0\u5b57\u5178\u4fe1\u606f\u63a5\u53e3", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    public ResultData update(@ModelAttribute @Parameter(hidden=true) DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        if (!this.hasPermissions("mdiy:dict:update", "mdiy:dictData:" + dict.getDictType() + ":settings")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictType())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.type")}));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictLabel())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.label")}));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictValue())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("dict.value")}));
        }
        DictEntity dictEntity = this.dictBiz.getByTypeAndLabelAndValue(dict.getDictType(), dict.getDictLabel(), null);
        if (dictEntity != null && !dictEntity.getId().equals(dict.getId())) {
            return ResultData.build().error(this.getResString("diy.dict.type.and.label.repeat"));
        }
        dictEntity = this.dictBiz.getByTypeAndLabelAndValue(dict.getDictType(), null, dict.getDictValue());
        if (dictEntity != null && !dictEntity.getId().equals(dict.getId())) {
            return ResultData.build().error(this.getResString("diy.dict.type.and.value.repeat"));
        }
        if (StringUtils.isBlank((CharSequence)dict.getDictValue())) {
            dict.setDictValue(null);
        }
        this.dictBiz.updateById((Object)dict);
        this.dictBiz.updateCache();
        return ResultData.build().success();
    }
}

