/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/form"})
public class FormAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;

    @Hidden
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/form/index";
    }

    @Operation(summary="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelName", description="\u6a21\u578b\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="modelTableName", description="\u6a21\u578b\u8868\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="appId", description="\u5e94\u7528\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="modelJson", description="json", required=false, in=ParameterIn.QUERY), @Parameter(name="createBy", description="\u521b\u5efa\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="createDate", description="\u521b\u5efa\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="updateBy", description="\u4fee\u6539\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="updateDate", description="\u4fee\u6539\u65f6\u95f4", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"mdiy:form:view"})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        modelEntity.setModelCustomType(ModelCustomTypeEnum.FORM.getLabel());
        BasicUtil.startPage();
        List modelList = this.modelBiz.list((Wrapper)new LambdaQueryWrapper((Object)modelEntity).orderByDesc(ModelEntity::getId));
        return ResultData.build().success((Object)new EUListBean(modelList, (int)BasicUtil.endPage((List)modelList).getTotal()));
    }

    @Operation(summary="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelName", description="\u6a21\u578b\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="modelTableName", description="\u6a21\u578b\u8868\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="appId", description="\u5e94\u7528\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="modelJson", description="json", required=false, in=ParameterIn.QUERY), @Parameter(name="createBy", description="\u521b\u5efa\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="createDate", description="\u521b\u5efa\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="updateBy", description="\u4fee\u6539\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="updateDate", description="\u4fee\u6539\u65f6\u95f4", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelName()) && StringUtils.isBlank((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.name") + " or " + this.getResString("model.id")}));
        }
        modelEntity.setModelCustomType(ModelCustomTypeEnum.FORM.getLabel());
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)new QueryWrapper((Object)modelEntity)));
        if (model == null) {
            return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("model.name") + " or " + this.getResString("model.id")}));
        }
        if (!this.hasPermissions("mdiy:form:view", "mdiy:formData:" + model.getId() + ":view")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        return ResultData.build().success((Object)model);
    }

    @Operation(summary="\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @Parameters(value={@Parameter(name="modelJson", description="json", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u5bfc\u5165", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/importJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:form:importJson"})
    public ResultData importJson(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.modelBiz.importConfig(ModelCustomTypeEnum.FORM.getLabel(), modelJsonBean)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @Operation(summary="\u66f4\u65b0\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @Parameters(value={@Parameter(name="modelJson", description="json", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u5bfc\u5165", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/updateJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:form:update"})
    public ResultData updateJson(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        if (StringUtils.isBlank((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.modelBiz.updateConfig(modelEntity.getId(), modelJsonBean)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:form:del"})
    public ResultData delete(@RequestBody List<ModelEntity> models, HttpServletResponse response, HttpServletRequest request) {
        List<String> ids = models.stream().map(p -> p.getId()).collect(Collectors.toList());
        if (this.modelBiz.delete(ids)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
    }
}

