/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.ITagBiz;
import net.mingsoft.mdiy.constant.e.ConfigTypeEnum;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ConfigEntity;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.entity.TagEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u81ea\u5b9a\u4e49\u5168\u5c40\u6807\u7b7e\u6570\u636e\u6a21\u5757\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/tag/globalTag"})
public class GlobalTagAction
extends BaseAction {
    @Autowired
    private IConfigBiz configBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private ITagBiz tagBiz;

    @Hidden
    @GetMapping(value={"/config"})
    @RequiresPermissions(value={"mdiy:tag:config"})
    public String config(HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        return "/mdiy/tag/global-tag/config";
    }

    @Operation(summary="\u914d\u7f6e\u6570\u636e\u83b7\u53d6\u63a5\u53e3")
    @GetMapping(value={"/get"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:tag:view"})
    public ResultData get(HttpServletResponse response, HttpServletRequest request) {
        String modelId = BasicUtil.getString((String)"modelId");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        ModelEntity modelEntity = this.modelBiz.getById((Serializable)((Object)modelId));
        if (modelEntity == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
        }
        ConfigEntity configEntity = (ConfigEntity)((Object)this.configBiz.getOne((Wrapper)new LambdaQueryWrapper().eq(ConfigEntity::getModelId, (Object)modelEntity.getId()), true));
        if (configEntity == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("config.name")}));
        }
        return ResultData.build().success((Object)JSONUtil.parseObj((String)configEntity.getConfigData()));
    }

    @Operation(summary="\u66f4\u65b0\u81ea\u5b9a\u4e49\u5168\u5c40\u914d\u7f6e\u6570\u636e")
    @LogAnn(title="\u66f4\u65b0\u81ea\u5b9a\u4e49\u5168\u5c40\u914d\u7f6e\u6570\u636e", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:tag:update"})
    public ResultData update(HttpServletResponse response, HttpServletRequest request) {
        Map map = BasicUtil.assemblyRequestMap();
        String modelId = map.get("modelId").toString();
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        ModelEntity modelEntity = this.modelBiz.getById((Serializable)((Object)modelId));
        if (modelEntity == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
        }
        ConfigEntity configEntity = (ConfigEntity)((Object)this.configBiz.getOne((Wrapper)new LambdaQueryWrapper().eq(ConfigEntity::getModelId, (Object)modelEntity.getId()), true));
        if (configEntity == null) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("config.name")}));
        }
        List modelFields = JSONUtil.toList((String)modelEntity.getModelField(), Map.class);
        modelFields.forEach(field -> {
            if (map.get(field.get("model")) != null) {
                if (field.get("javaType").toString().equalsIgnoreCase("Integer")) {
                    map.put(field.get("model").toString(), Integer.parseInt(map.get(field.get("model")).toString()));
                }
                if (field.get("javaType").toString().equalsIgnoreCase("Boolean")) {
                    map.put(field.get("model").toString(), Boolean.parseBoolean(map.get(field.get("model")).toString()));
                }
            }
        });
        configEntity.setConfigData(JSONUtil.toJsonStr((Object)map));
        this.configBiz.updateById((Object)configEntity);
        this.configBiz.updateCache();
        return ResultData.build().success((Object)configEntity);
    }

    @Operation(summary="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelName", description="\u6a21\u578b\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="modelTableName", description="\u6a21\u578b\u8868\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="appId", description="\u5e94\u7528\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="modelJson", description="json", required=false, in=ParameterIn.QUERY), @Parameter(name="createBy", description="\u521b\u5efa\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="createDate", description="\u521b\u5efa\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="updateBy", description="\u4fee\u6539\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="updateDate", description="\u4fee\u6539\u65f6\u95f4", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/getModel"})
    @ResponseBody
    public ResultData getModel(@Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)modelEntity.getModelName()) && StringUtils.isEmpty((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.name")}));
        }
        modelEntity.setModelCustomType(ModelCustomTypeEnum.TAG.getLabel());
        ModelEntity model = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)new QueryWrapper((Object)modelEntity)));
        return ResultData.build().success((Object)model);
    }

    @Operation(summary="\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @Parameters(value={@Parameter(name="modelJson", description="json", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u5bfc\u5165", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/importJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:tag:save"})
    public ResultData importJson(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        String tagId = BasicUtil.getString((String)"tagId");
        if (StringUtils.isBlank((CharSequence)tagId)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        TagEntity tagEntity = (TagEntity)((Object)this.tagBiz.getById((Serializable)((Object)tagId)));
        if (tagEntity == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
        }
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.configBiz.importConfig(ConfigTypeEnum.TAG.getType(), modelJsonBean)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(ModelEntity::getModelName, (Object)modelJsonBean.getTitle())).eq(ModelEntity::getModelCustomType, (Object)ModelCustomTypeEnum.TAG.getLabel());
            modelEntity = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)queryWrapper));
            tagEntity.setModelId(modelEntity.getId());
            this.tagBiz.updateById((Object)tagEntity);
            this.tagBiz.updateCache();
            return ResultData.build().success(this.configBiz.getOne((Wrapper)new LambdaQueryWrapper().eq(ConfigEntity::getModelId, (Object)modelEntity.getId())));
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @Operation(summary="\u66f4\u65b0\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @Parameters(value={@Parameter(name="modelJson", description="json", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u5bfc\u5165", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/updateJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:tag:update"})
    public ResultData updateJson(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        if (StringUtils.isBlank((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.configBiz.updateConfig(modelEntity.getId(), modelJsonBean)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(ConfigEntity::getConfigName, (Object)modelJsonBean.getTitle())).eq(ConfigEntity::getConfigType, (Object)ModelCustomTypeEnum.CONFIG.getLabel());
            return ResultData.build().success(this.configBiz.getOne((Wrapper)queryWrapper));
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }
}

