/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.sql.Clob;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.IModelDataBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3")
@Controller(value="coMdiyModelAction")
@RequestMapping(value={"/${ms.manager.path}/mdiy/model"})
public class ModelAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IModelDataBiz modelDataBiz;
    private Pattern filePattern = Pattern.compile("(src|href)=\"(upload/.*?(png|jpg|gif))");

    @Hidden
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/model/index";
    }

    @Hidden
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        if (modelEntity.getId() != null) {
            ModelEntity _modelEntity = this.modelBiz.getById((Serializable)((Object)modelEntity.getId()));
            modelMap.addAttribute("modelEntity", (Object)_modelEntity);
        }
        return "/mdiy/model/form";
    }

    @Operation(summary="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelName", description="\u6a21\u578b\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="modelTableName", description="\u6a21\u578b\u8868\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="appId", description="\u5e94\u7528\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="modelJson", description="json", required=false, in=ParameterIn.QUERY), @Parameter(name="createBy", description="\u521b\u5efa\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="createDate", description="\u521b\u5efa\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="updateBy", description="\u4fee\u6539\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="updateDate", description="\u4fee\u6539\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="del", description="\u5220\u9664\u6807\u8bb0", required=false, in=ParameterIn.QUERY), @Parameter(name="id", description="\u7f16\u53f7", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model, BindingResult result) {
        modelEntity.setModelCustomType(ModelCustomTypeEnum.MODEL.getLabel());
        List<ModelEntity> modelList = this.modelBiz.query(modelEntity);
        return ResultData.build().success((Object)new EUListBean(modelList, (int)BasicUtil.endPage(modelList).getTotal()));
    }

    @Operation(summary="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u6570\u636e\u63a5\u53e3")
    @GetMapping(value={"/data"})
    @ResponseBody
    public ResultData data(String modelId, String linkId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        List listMap;
        SqlInjectionUtil.filterContent((String[])new String[]{linkId});
        ModelEntity model = this.modelBiz.getById((Serializable)((Object)modelId));
        HashMap data = null;
        if (StringUtils.isBlank((CharSequence)linkId)) {
            linkId = "0";
        }
        if (ObjectUtil.isNotNull((Object)((Object)model)) && (listMap = this.modelBiz.queryForList(StrUtil.format((CharSequence)"select * from {} where link_id = ?", (Object[])new Object[]{model.getModelTableName()}), new Object[]{linkId})).size() > 0) {
            data = new HashMap();
            for (Object o : ((Map)listMap.get(0)).keySet()) {
                Object _o = ((Map)listMap.get(0)).get(o);
                if (_o instanceof Clob) {
                    _o = StringUtil.clobStr((Clob)((Clob)_o));
                }
                data.put(this.getCamelCaseString(o.toString(), false), _o);
            }
        }
        return ResultData.build().success(data);
    }

    private String getCamelCaseString(String inputString, boolean firstCharacterUppercase) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        block3: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '&': 
                case '-': 
                case '/': 
                case '@': 
                case '_': {
                    if (sb.length() <= 0) continue block3;
                    nextUpperCase = true;
                    continue block3;
                }
                default: {
                    if (nextUpperCase) {
                        sb.append(Character.toUpperCase(c));
                        nextUpperCase = false;
                        continue block3;
                    }
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    @Operation(summary="\u4fdd\u5b58\u6a21\u578b\u63a5\u53e3")
    @LogAnn(title="\u4fdd\u5b58\u6a21\u578b", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/data/save"})
    @ResponseBody
    public ResultData save(String linkId, String modelId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        SqlInjectionUtil.filterContent((String[])new String[]{linkId});
        ModelEntity model = this.modelBiz.getById((Serializable)((Object)modelId));
        if (ObjectUtil.isNotNull((Object)((Object)model)) && StringUtils.isNotBlank((CharSequence)linkId)) {
            SqlInjectionUtil.filterContent((String[])new String[]{model.getModelTableName()});
            List listMap = this.modelBiz.queryForList(StrUtil.format((CharSequence)"select * from {} where link_id = ?", (Object[])new Object[]{model.getModelTableName()}), new Object[]{linkId});
            if (CollUtil.isNotEmpty((Collection)listMap)) {
                return ResultData.build().error(linkId);
            }
            Map requestMap = BasicUtil.assemblyRequestMap();
            CaseInsensitiveMap map = new CaseInsensitiveMap(requestMap);
            this.modelDataBiz.spliceInsertSql(model, (Map<String, Object>)map);
            return ResultData.build().success((Object)linkId);
        }
        return ResultData.build().error(linkId);
    }

    @Operation(summary="\u66f4\u65b0\u6a21\u578b\u63a5\u53e3")
    @LogAnn(title="\u66f4\u65b0\u6a21\u578b", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/data/update"})
    @ResponseBody
    public ResultData update(String linkId, String modelId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        SqlInjectionUtil.filterContent((String[])new String[]{linkId});
        ModelEntity model = this.modelBiz.getById((Serializable)((Object)modelId));
        if (ObjectUtil.isNotNull((Object)((Object)model)) && StringUtils.isNotBlank((CharSequence)linkId)) {
            Map requestMap = BasicUtil.assemblyRequestMap();
            CaseInsensitiveMap map = new CaseInsensitiveMap(requestMap);
            SqlInjectionUtil.filterContent((String[])new String[]{model.getModelTableName()});
            List listMap = this.modelBiz.queryForList(StrUtil.format((CharSequence)"select * from {} where link_id = ?", (Object[])new Object[]{model.getModelTableName()}), new Object[]{linkId});
            if (CollUtil.isEmpty((Collection)listMap)) {
                this.modelDataBiz.spliceInsertSql(model, (Map<String, Object>)map);
            } else {
                this.modelDataBiz.spliceUpdateSql(model, (Map<String, Object>)map);
            }
            return ResultData.build().success((Object)linkId);
        }
        return ResultData.build().error(linkId);
    }

    @Operation(summary="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelName", description="\u6a21\u578b\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="modelTableName", description="\u6a21\u578b\u8868\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="appId", description="\u5e94\u7528\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="modelJson", description="json", required=false, in=ParameterIn.QUERY), @Parameter(name="createBy", description="\u521b\u5efa\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="createDate", description="\u521b\u5efa\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="updateBy", description="\u4fee\u6539\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="updateDate", description="\u4fee\u6539\u65f6\u95f4", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)modelEntity.getModelName()) && StringUtils.isEmpty((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.name")}));
        }
        modelEntity.setModelCustomType(ModelCustomTypeEnum.MODEL.getLabel());
        ModelEntity model = this.modelBiz.getByEntity(modelEntity);
        return ResultData.build().success((Object)model);
    }

    @Operation(summary="\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelJson", description="json", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/importJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:model:importJson"})
    public ResultData importJson(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        modelEntity.setModelCustomType(ModelCustomTypeEnum.MODEL.getLabel());
        ModelJsonBean modelJsonBean = new ModelJsonBean();
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.modelBiz.importModel(ModelCustomTypeEnum.MODEL.getLabel(), modelJsonBean, modelEntity.getModelType())) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @Operation(summary="\u66f4\u65b0\u5bfc\u5165\u81ea\u5b9a\u4e49\u6a21\u578b")
    @Parameters(value={@Parameter(name="modelJson", description="json", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u66f4\u65b0\u81ea\u5b9a\u4e49\u6a21\u578b", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/updateJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:model:update"})
    public ResultData updateJson(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        if (StringUtils.isBlank((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        ModelJsonBean modelJsonBean = null;
        try {
            modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelEntity.getModelJson(), ModelJsonBean.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        if (this.modelBiz.updateConfig(modelEntity.getId(), modelJsonBean, modelEntity.getModelType())) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:model:del"})
    public ResultData delete(@RequestBody List<ModelEntity> models, HttpServletResponse response, HttpServletRequest request) {
        List<String> ids = models.stream().map(ModelEntity::getId).collect(Collectors.toList());
        this.modelBiz.delete(ids);
        return ResultData.build().success();
    }
}

