/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action.web;

import cn.hutool.json.JSONUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ConfigEntity;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ConfigUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u524d\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3")
@Controller(value="webMdiyConfig")
@RequestMapping(value={"/mdiy/config"})
public class ConfigAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;

    @Operation(summary="\u83b7\u53d6\u914d\u7f6e\u4e2d\u7684key\u6307\u5b9avalue\u503c")
    @Parameters(value={@Parameter(name="configName", description="\u914d\u7f6e\u540d\u79f0", required=true, in=ParameterIn.QUERY), @Parameter(name="key", description="\u914d\u7f6ekey", required=true, in=ParameterIn.QUERY)})
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(String configName, String key, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)configName) || StringUtils.isEmpty((CharSequence)key)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("config.name")}));
        }
        ConfigEntity configEntity = ConfigUtil.getEntity(configName);
        if (configEntity == null) {
            return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("config.name")}));
        }
        ModelEntity modelEntity = this.modelBiz.getEntityById(configEntity.getModelId());
        if (modelEntity != null) {
            if (Boolean.parseBoolean(((Map)JSONUtil.toBean((String)modelEntity.getModelJson(), Map.class)).get("isWebSubmit").toString())) {
                return ResultData.build().success((Object)ConfigUtil.getString((String)configName, (String)key));
            }
            return ResultData.build().error("\u6b64\u914d\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5916\u90e8\u83b7\u53d6");
        }
        return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("config.name")}));
    }
}

