/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.biz.IDictBiz;
import net.mingsoft.mdiy.entity.DictEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u524d\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3")
@Controller(value="webDictAction")
@RequestMapping(value={"/mdiy/dict"})
public class DictAction
extends BaseAction {
    @Autowired
    private IDictBiz dictBiz;

    @Operation(summary="\u67e5\u8be2\u5b57\u5178\u8868\u5217\u8868")
    @Parameters(value={@Parameter(name="dictType", description="\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="dictValue", description="\u6570\u636e\u503c", required=false, in=ParameterIn.QUERY), @Parameter(name="dictLabel", description="\u6807\u7b7e\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="dictSort", description="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, in=ParameterIn.QUERY), @Parameter(name="isChild", description="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        SqlInjectionUtil.filterContent((String[])new String[]{dict.getOrderBy()});
        dict.setSqlWhere("");
        if (dict == null || StringUtils.isEmpty((CharSequence)dict.getDictType())) {
            return ResultData.build().error(this.getResString("dict.type"));
        }
        BasicUtil.startPage((int)1, (int)100, (boolean)true);
        dict.setDictEnable(true);
        List dictList = this.dictBiz.query(dict);
        return ResultData.build().success((Object)new EUListBean(dictList, (int)BasicUtil.endPage((List)dictList).getTotal()));
    }

    @Operation(summary="\u67e5\u8be2\u5b57\u5178\u8868\u5217\u8868,\u6392\u9664\u7ad9\u70b9\u7f16\u53f7")
    @Parameters(value={@Parameter(name="dictValue", description="\u6570\u636e\u503c", required=false, in=ParameterIn.QUERY), @Parameter(name="dictLabel", description="\u6807\u7b7e\u540d", required=false, in=ParameterIn.QUERY), @Parameter(name="dictType", description="\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="dictDescription", description="\u63cf\u8ff0", required=false, in=ParameterIn.QUERY), @Parameter(name="dictSort", description="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, in=ParameterIn.QUERY), @Parameter(name="isChild", description="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/listExcludeApp"})
    @ResponseBody
    public ResultData listExcludeApp(@ModelAttribute @Parameter(hidden=true) DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        SqlInjectionUtil.filterContent((String[])new String[]{dict.getOrderBy()});
        dict.setSqlWhere("");
        dict.setDictEnable(true);
        List<DictEntity> dictList = this.dictBiz.queryExcludeApp(dict);
        return ResultData.build().success(dictList);
    }
}

