/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action.web;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IPageBiz;
import net.mingsoft.mdiy.entity.PageEntity;
import net.mingsoft.mdiy.util.ConfigUtil;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Tag(name="\u524d\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3")
@Controller(value="webDiyPath")
@RequestMapping(value={"/mdiyPage"})
public class PageAction
extends BaseAction {
    @Autowired
    private IPageBiz pageBiz;

    @Operation(summary="\u81ea\u5b9a\u4e49\u9875\u9762")
    @Parameters(value={@Parameter(name="diy", description="\u8bf7\u6c42\u5730\u5740", required=true, in=ParameterIn.PATH)})
    @GetMapping(value={"/{diy}"})
    public void diy(@PathVariable(value="diy") String diy, HttpServletRequest req, HttpServletResponse resp) {
        String htmlDir = MSProperties.diy.htmlDir;
        Map map = BasicUtil.assemblyRequestMap();
        map.forEach((k, v) -> {
            if (k != null && v != null) {
                map.put(k, v.toString().replaceAll("('|\"|\\\\)", "\\\\$1"));
            }
        });
        Boolean shortSwitch = ConfigUtil.getBoolean((String)"\u77ed\u94fe\u914d\u7f6e", (String)"shortLinkSwitch");
        if (BasicUtil.getWebsiteApp() != null) {
            map.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
            map.put("url", BasicUtil.getWebsiteApp().getAppHostUrl());
            map.put("appId", BasicUtil.getWebsiteApp().getAppId());
        } else if (shortSwitch.booleanValue()) {
            map.put("url", BasicUtil.getUrl());
            map.put("appDir", "");
        } else {
            map.put("url", BasicUtil.getUrl());
            map.put("appDir", BasicUtil.getApp().getAppDir());
        }
        String contextPath = BasicUtil.getContextPath();
        if (StringUtils.isNotBlank((CharSequence)contextPath) && "/".equalsIgnoreCase(contextPath)) {
            contextPath = "";
        }
        map.putIfAbsent("contextPath", contextPath);
        map.put("isDo", false);
        map.put("html", htmlDir);
        PageEntity page = new PageEntity();
        page.setPageKey(diy);
        PageEntity _page = (PageEntity)((Object)this.pageBiz.getOne((Wrapper)new QueryWrapper((Object)page), false));
        try {
            String content = ParserUtil.rendering(_page.getPagePath().replace(" ", ""), map);
            BasicUtil.outString((HttpServletResponse)resp, (String)content);
        }
        catch (TemplateNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (MalformedTemplateNameException e1) {
            e1.printStackTrace();
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

