/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.aop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ModelDataAop
extends BaseAop {
    @Autowired
    private IModelBiz modelBiz;

    @Pointcut(value="execution(* net.mingsoft.mdiy.action.ModelAction.save(..)) || execution(* net.mingsoft.mdiy.action.ModelAction.update(..))")
    public void modelDataCheck() {
    }

    @Pointcut(value="execution(* net.mingsoft.mdiy.biz.impl.ModelDataImpl.saveDiyFormData(..)) || execution(* net.mingsoft.mdiy.biz.impl.ModelDataImpl.updateDiyFormData(..))")
    public void formDataCheck() {
    }

    @Before(value="formDataCheck()")
    public void formDataCheck(JoinPoint jp) {
        this.LOG.debug("modelDataAop");
        ModelEntity model = (ModelEntity)((Object)this.getType(jp, ModelEntity.class));
        if (model == null) {
            String modelId = BasicUtil.getString((String)"modelId", (String)"");
            model = this.modelBiz.getById((Serializable)((Object)modelId));
        }
        Map params = (Map)this.getType(jp, CaseInsensitiveMap.class);
        if (model != null && !this.checkDataRepeat(model, params)) {
            throw new BusinessException("\u5b58\u5728\u4e0d\u53ef\u91cd\u590d\u7684\u5b57\u6bb5\u503c\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u6570\u636e\u662f\u5426\u6709\u91cd\u590d\u3002");
        }
    }

    @Around(value="modelDataCheck()")
    public ResultData modelDataCheck(ProceedingJoinPoint pjp) throws Throwable {
        Map params;
        this.LOG.debug("\u5f00\u59cb\u68c0\u6d4b\u81ea\u5b9a\u4e49\u6a21\u578b\u662f\u5426\u91cd\u590d");
        String modelId = BasicUtil.getString((String)"modelId", (String)"");
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return ResultData.build().error();
        }
        ModelEntity model = this.modelBiz.getById((Serializable)((Object)modelId));
        if (model != null && !this.checkDataRepeat(model, params = BasicUtil.assemblyRequestMap())) {
            return ResultData.build().error("\u5b58\u5728\u4e0d\u53ef\u91cd\u590d\u7684\u5b57\u6bb5\u503c\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u6570\u636e\u662f\u5426\u6709\u91cd\u590d\u3002");
        }
        Object result = pjp.proceed(pjp.getArgs());
        return (ResultData)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)result), ResultData.class);
    }

    private boolean checkDataRepeat(ModelEntity model, Map<String, Object> params) {
        JdbcTemplate jdbcTemplate = (JdbcTemplate)SpringUtil.getBean(JdbcTemplate.class);
        Object id = params.get("id");
        CaseInsensitiveMap repeatMap = new CaseInsensitiveMap(model.getRepeatMap());
        CaseInsensitiveMap fieldMap = new CaseInsensitiveMap(model.getFieldMap());
        StringBuilder where = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String paramKey : params.keySet()) {
            boolean repeat;
            if (!fieldMap.containsKey(paramKey) || !(repeat = MapUtil.getBool((Map)repeatMap, (Object)paramKey, (Boolean)false).booleanValue())) continue;
            if (StringUtils.isNotBlank((CharSequence)where)) {
                where.append(" OR ");
            }
            where.append(fieldMap.get(paramKey).toString()).append(" = ? ");
            values.add(params.get(paramKey));
        }
        if (CollectionUtil.isNotEmpty(values)) {
            Object select = "select * from {} where ({})";
            if (ObjectUtil.isNotEmpty((Object)id)) {
                select = (String)select + " AND id != ? ";
                values.add(id);
            }
            String _select = StrUtil.format((CharSequence)select, (Object[])new Object[]{model.getModelTableName(), where});
            this.LOG.debug("\u9884\u6267\u884cSQL:{},params:{}", (Object)_select, (Object)Arrays.toString(values.toArray()));
            List results = jdbcTemplate.queryForList(_select, values.toArray());
            if (CollectionUtil.isNotEmpty((Collection)results)) {
                return false;
            }
        }
        return true;
    }
}

