<!DOCTYPE html>
<html>
<head>
    <title>自定义表单</title>
    <#include "../../include/head-file.ftl">
    <script src="${base}/static/mdiy/index.js"></script>
    <script src="${base}/static/plugins/moment/2.24.0/moment.min.js"></script>
</head>
<body>
<div id="form" v-cloak>
    <el-header class="ms-header ms-tr" height="50px">
        <el-button type="primary" class="iconfont icon-baocun" size="default" @click="save()" :loading="saveDisabled">保存</el-button>
        <el-button size="default"  class="iconfont icon-fanhui" plain @click="back()">返回</el-button>
    </el-header>
    <el-main class="ms-container" v-loading="loading">
        <ms-mdiy-form ref="modelForm" type="form" :model-name="modelName"  :model-id="modelId" :id="id"></ms-mdiy-form>
    </el-main>
</div>
</body>
</html>
<script>
    var form = new _Vue({
        el: '#form',
        data(){
            return {
                loading:false,
                saveDisabled: false,
                modelName:'',
                modelId:'',
                id:''
            }
        },
        methods: {
            back: function (){
                ms.util.openSystemUrl("/mdiy/form/data/index.do?modelName="+this.modelName+"&modelId="+this.modelId,true)
            },
            save: function () {
                var that = this;
                that.saveDisabled = true;
                this.$refs.modelForm.getForm().save(function (res) {
                    if(res.result){
                        that.$notify({
                            title: '成功',
                            type: 'success',
                            message: '保存成功!'
                        });
                        ms.util.openSystemUrl("/mdiy/form/data/index.do?modelName="+that.modelName+"&modelId="+that.modelId,false)
                    }else if (res.code == 'PARAMERR'){  // FormDataAction.PARAM_ERR
                        that.$notify({
                            title: '失败',
                            message: res.msg,
                            type: 'warning'
                        });
                    }
                    that.saveDisabled = false;
                });
            },
        },
        created:function() {
			this.modelId = ms.util.getParameter("modelId");
            this.id = ms.util.getParameter("id");
            this.modelName = ms.util.getParameter("modelName");
        }
    });
</script>
