/*
 * Decompiled with CFR 0.152.
 */
package com.lkx.util;

import com.lkx.util.StringUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelUtil
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static Map<String, String> getMap(String keyValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (keyValue != null) {
            String[] str;
            for (String element : str = keyValue.split(",")) {
                String[] str2 = element.split(":");
                map.put(str2[0], str2[1]);
            }
        }
        return map;
    }

    public static <T> List<T> readXlsPart(String filePath, Map map, String classPath, int ... rowNumIndex) throws Exception {
        Set keySet = map.keySet();
        Class<?> demo = null;
        Object obj = null;
        ArrayList<Object> list = new ArrayList<Object>();
        demo = Class.forName(classPath);
        String fileType = filePath.substring(filePath.lastIndexOf(".") + 1, filePath.length());
        FileInputStream is = new FileInputStream(filePath);
        HSSFWorkbook wb = null;
        if (fileType.equals("xls")) {
            wb = new HSSFWorkbook((InputStream)is);
        } else if (fileType.equals("xlsx")) {
            wb = new XSSFWorkbook((InputStream)is);
        } else {
            throw new Exception("\u60a8\u8f93\u5165\u7684excel\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        for (int sheetNum = 0; sheetNum < 1; ++sheetNum) {
            int rowNum_x = -1;
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            ArrayList<String> headlist = new ArrayList<String>();
            Sheet hssfSheet = wb.getSheetAt(sheetNum);
            if (hssfSheet != null && hssfSheet.getLastRowNum() > 20000) {
                throw new Exception("Excel \u6570\u636e\u8d85\u8fc720000\u884c,\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u7a7a\u884c,\u6216\u5206\u6279\u5bfc\u5165");
            }
            for (int rowNum = 0; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                Row hssfRow;
                if (rowNumIndex != null && rowNumIndex.length > 0 && rowNum_x == -1) {
                    hssfRow = hssfSheet.getRow(rowNumIndex[0]);
                    if (hssfRow == null) {
                        throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    rowNum = rowNumIndex[0] - 1;
                }
                if ((hssfRow = hssfSheet.getRow(rowNum)) == null) continue;
                boolean flag = false;
                for (int i = 0; i < hssfRow.getLastCellNum(); ++i) {
                    if (hssfRow.getCell(i) == null || "".equals(hssfRow.getCell(i).toString().trim())) continue;
                    flag = true;
                }
                if (!flag) continue;
                if (rowNum_x == -1) {
                    for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); ++cellNum) {
                        Cell hssfCell = hssfRow.getCell(cellNum);
                        if (hssfCell == null) continue;
                        String tempCellValue = hssfSheet.getRow(rowNum).getCell(cellNum).getStringCellValue();
                        tempCellValue = StringUtils.remove((String)tempCellValue, (char)'\u00a0');
                        tempCellValue = tempCellValue.trim();
                        headlist.add(tempCellValue);
                        for (Object key : keySet) {
                            if (!StringUtils.isNotBlank((CharSequence)tempCellValue) || !StringUtils.equals((CharSequence)tempCellValue, (CharSequence)key.toString())) continue;
                            rowNum_x = rowNum;
                            cellmap.put(map.get(key).toString(), cellNum);
                        }
                        if (rowNum_x != -1) continue;
                        throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5\u6216\u8005\u5bf9\u5e94\u5b57\u6bb5\u884c\u4e0a\u9762\u542b\u6709\u4e0d\u4e3a\u7a7a\u767d\u7684\u884c\u5b57\u6bb5");
                    }
                    continue;
                }
                obj = demo.newInstance();
                for (Object key : keySet) {
                    Integer cellNum_x = (Integer)cellmap.get(map.get(key).toString());
                    if (cellNum_x == null || hssfRow.getCell(cellNum_x.intValue()) == null) continue;
                    String attr = map.get(key).toString();
                    Class attrType = BeanUtils.findPropertyType((String)attr, (Class[])new Class[]{obj.getClass()});
                    Cell cell = hssfRow.getCell(cellNum_x.intValue());
                    ExcelUtil.getValue(cell, obj, attr, attrType, rowNum, cellNum_x, key);
                }
                list.add(obj);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public static <T> List<T> readXls(String filePath, Map map, String classPath, int ... rowNumIndex) throws Exception {
        Set keySet = map.keySet();
        Class<?> demo = null;
        Object obj = null;
        ArrayList<Object> list = new ArrayList<Object>();
        demo = Class.forName(classPath);
        String fileType = filePath.substring(filePath.lastIndexOf(".") + 1, filePath.length());
        FileInputStream is = new FileInputStream(filePath);
        HSSFWorkbook wb = null;
        if (fileType.equals("xls")) {
            wb = new HSSFWorkbook((InputStream)is);
        } else if (fileType.equals("xlsx")) {
            wb = new XSSFWorkbook((InputStream)is);
        } else {
            throw new Exception("\u60a8\u8f93\u5165\u7684excel\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        for (int sheetNum = 0; sheetNum < wb.getNumberOfSheets(); ++sheetNum) {
            int rowNum_x = -1;
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            ArrayList<String> headlist = new ArrayList<String>();
            Sheet hssfSheet = wb.getSheetAt(sheetNum);
            for (int rowNum = 0; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                int i;
                Row hssfRow;
                if (rowNumIndex != null && rowNumIndex.length > 0 && rowNum_x == -1) {
                    hssfRow = hssfSheet.getRow(rowNumIndex[0]);
                    if (hssfRow == null) {
                        throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    rowNum = rowNumIndex[0] - 1;
                }
                if ((hssfRow = hssfSheet.getRow(rowNum)) == null) continue;
                boolean flag = false;
                for (i = 0; i < hssfRow.getLastCellNum(); ++i) {
                    if (hssfRow.getCell(i) == null || "".equals(hssfRow.getCell(i).toString().trim())) continue;
                    flag = true;
                }
                if (!flag) continue;
                if (rowNum_x == -1) {
                    for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); ++cellNum) {
                        Cell hssfCell = hssfRow.getCell(cellNum);
                        if (hssfCell == null) continue;
                        String tempCellValue = hssfSheet.getRow(rowNum).getCell(cellNum).getStringCellValue();
                        tempCellValue = StringUtils.remove((String)tempCellValue, (char)'\u00a0');
                        tempCellValue = tempCellValue.trim();
                        headlist.add(tempCellValue);
                        for (Object key : keySet) {
                            if (!StringUtils.isNotBlank((CharSequence)tempCellValue) || !StringUtils.equals((CharSequence)tempCellValue, (CharSequence)key.toString())) continue;
                            rowNum_x = rowNum;
                            cellmap.put(map.get(key).toString(), cellNum);
                        }
                        if (rowNum_x != -1) continue;
                        throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5\u6216\u8005\u5bf9\u5e94\u5b57\u6bb5\u884c\u4e0a\u9762\u542b\u6709\u4e0d\u4e3a\u7a7a\u767d\u7684\u884c\u5b57\u6bb5");
                    }
                    for (i = 0; i < headlist.size(); ++i) {
                        boolean boo = false;
                        Iterator itor = keySet.iterator();
                        while (itor.hasNext()) {
                            String tempname = itor.next().toString();
                            if (!tempname.equals(headlist.get(i))) continue;
                            boo = true;
                        }
                        if (boo) continue;
                        throw new Exception("\u8868\u5934\u5b57\u6bb5\u548c\u5b9a\u4e49\u7684\u5c5e\u6027\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
                    }
                    Iterator itor = keySet.iterator();
                    while (itor.hasNext()) {
                        boolean boo = false;
                        String tempname = itor.next().toString();
                        for (int i2 = 0; i2 < headlist.size(); ++i2) {
                            if (!tempname.equals(headlist.get(i2))) continue;
                            boo = true;
                        }
                        if (boo) continue;
                        throw new Exception("\u8868\u5934\u5b57\u6bb5\u548c\u5b9a\u4e49\u7684\u5c5e\u6027\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
                    }
                    continue;
                }
                obj = demo.newInstance();
                for (Object key : keySet) {
                    Integer cellNum_x = (Integer)cellmap.get(map.get(key).toString());
                    if (cellNum_x == null || hssfRow.getCell(cellNum_x.intValue()) == null) continue;
                    String attr = map.get(key).toString();
                    Class attrType = BeanUtils.findPropertyType((String)attr, (Class[])new Class[]{obj.getClass()});
                    Cell cell = hssfRow.getCell(cellNum_x.intValue());
                    ExcelUtil.getValue(cell, obj, attr, attrType, rowNum, cellNum_x, key);
                }
                list.add(obj);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public static void setter(Object obj, String att, Object value, Class<?> type, int row, int col, Object key) throws Exception {
        try {
            Method method = obj.getClass().getMethod("set" + StringUtil.toUpperCaseFirstOne(att), type);
            method.invoke(obj, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u7b2c" + (row + 1) + " \u884c  " + (col + 1) + "\u5217   \u5c5e\u6027\uff1a" + key + " \u8d4b\u503c\u5f02\u5e38  ");
        }
    }

    public static void getValue(Cell cell, Object obj, String attr, Class attrType, int row, int col, Object key) throws Exception {
        Object val = null;
        if (cell.getCellType() == 4) {
            val = cell.getBooleanCellValue();
        } else if (cell.getCellType() == 0) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    if (attrType == String.class) {
                        val = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                    }
                    val = ExcelUtil.dateConvertFormat(sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())));
                }
                catch (ParseException e) {
                    throw new Exception("\u7b2c" + (row + 1) + " \u884c  " + (col + 1) + "\u5217   \u5c5e\u6027\uff1a" + key + " \u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef  ");
                }
            } else if (attrType == String.class) {
                cell.setCellType(1);
                val = cell.getStringCellValue();
            } else {
                val = attrType == BigDecimal.class ? new BigDecimal(cell.getNumericCellValue()) : (attrType == Long.TYPE ? (Number)((long)cell.getNumericCellValue()) : (Number)(attrType == Double.class ? (Number)cell.getNumericCellValue() : (Number)(attrType == Float.class ? (Number)Float.valueOf((float)cell.getNumericCellValue()) : (Number)(attrType == Integer.TYPE || attrType == Integer.class ? (Number)((int)cell.getNumericCellValue()) : (Number)(attrType == Short.class ? (Number)((short)cell.getNumericCellValue()) : (Number)cell.getNumericCellValue())))));
            }
        } else if (cell.getCellType() == 1) {
            val = cell.getStringCellValue();
        }
        ExcelUtil.setter(obj, attr, val, attrType, row, col, key);
    }

    public static Date dateConvertFormat(String dateStr) throws ParseException {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        date = format.parse(dateStr);
        return date;
    }
}

