/*
 * Decompiled with CFR 0.152.
 */
package com.lkx.util;

import com.lkx.util.ExcelParam;
import com.lkx.util.ExcelTypeEnum;
import com.lkx.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelUtil
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static Map<String, String> getMap(String keyValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (keyValue != null) {
            String[] str;
            for (String element : str = keyValue.split(",")) {
                String[] str2 = element.split(":");
                map.put(str2[0], str2[1]);
            }
        }
        return map;
    }

    public static List<String> getList(String keyValue) {
        ArrayList<String> list = new ArrayList<String>();
        if (keyValue != null) {
            String[] str;
            for (String element : str = keyValue.split(",")) {
                String[] str2 = element.split(":");
                list.add(str2[0]);
            }
        }
        return list;
    }

    public static <T> List<T> readXlsPart(String filePath, Map map, String classPath, int ... rowNumIndex) throws Exception {
        Set keySet = map.keySet();
        Class<?> demo = null;
        Object obj = null;
        ArrayList<Object> list = new ArrayList<Object>();
        demo = Class.forName(classPath);
        String fileType = filePath.substring(filePath.lastIndexOf(".") + 1, filePath.length());
        FileInputStream is = new FileInputStream(filePath);
        HSSFWorkbook wb = null;
        if (fileType.equals("xls")) {
            wb = new HSSFWorkbook((InputStream)is);
        } else if (fileType.equals("xlsx")) {
            wb = new XSSFWorkbook((InputStream)is);
        } else {
            throw new Exception("\u60a8\u8f93\u5165\u7684excel\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        for (int sheetNum = 0; sheetNum < 1; ++sheetNum) {
            int rowNum_x = -1;
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            ArrayList<String> headlist = new ArrayList<String>();
            Sheet hssfSheet = wb.getSheetAt(sheetNum);
            if (hssfSheet != null && hssfSheet.getLastRowNum() > 60000) {
                throw new Exception("Excel \u6570\u636e\u8d85\u8fc760000\u884c,\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u7a7a\u884c,\u6216\u5206\u6279\u5bfc\u5165");
            }
            for (int rowNum = 0; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                Row hssfRow;
                if (rowNumIndex != null && rowNumIndex.length > 0 && rowNum_x == -1) {
                    hssfRow = hssfSheet.getRow(rowNumIndex[0]);
                    if (hssfRow == null) {
                        throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    rowNum = rowNumIndex[0] - 1;
                }
                if ((hssfRow = hssfSheet.getRow(rowNum)) == null) continue;
                boolean flag = false;
                for (int i = 0; i < hssfRow.getLastCellNum(); ++i) {
                    if (hssfRow.getCell(i) == null || "".equals(hssfRow.getCell(i).toString().trim())) continue;
                    flag = true;
                }
                if (!flag) continue;
                if (rowNum_x == -1) {
                    for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); ++cellNum) {
                        Cell hssfCell = hssfRow.getCell(cellNum);
                        if (hssfCell == null) continue;
                        String tempCellValue = hssfSheet.getRow(rowNum).getCell(cellNum).getStringCellValue();
                        tempCellValue = StringUtils.remove((String)tempCellValue, (char)'\u00a0');
                        tempCellValue = tempCellValue.trim();
                        headlist.add(tempCellValue);
                        for (Object key : keySet) {
                            if (!StringUtils.isNotBlank((CharSequence)tempCellValue) || !StringUtils.equals((CharSequence)tempCellValue, (CharSequence)key.toString())) continue;
                            rowNum_x = rowNum;
                            cellmap.put(map.get(key).toString(), cellNum);
                        }
                        if (rowNum_x != -1) continue;
                        throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5\u6216\u8005\u5bf9\u5e94\u5b57\u6bb5\u884c\u4e0a\u9762\u542b\u6709\u4e0d\u4e3a\u7a7a\u767d\u7684\u884c\u5b57\u6bb5");
                    }
                    continue;
                }
                obj = demo.newInstance();
                for (Object key : keySet) {
                    Integer cellNum_x = (Integer)cellmap.get(map.get(key).toString());
                    if (cellNum_x == null || hssfRow.getCell(cellNum_x.intValue()) == null) continue;
                    String attr = map.get(key).toString();
                    Class attrType = BeanUtils.findPropertyType((String)attr, (Class[])new Class[]{obj.getClass()});
                    Cell cell = hssfRow.getCell(cellNum_x.intValue());
                    ExcelUtil.getValue(cell, obj, attr, attrType, rowNum, cellNum_x, key);
                }
                list.add(obj);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public static <T> List<T> readXls(String filePath, Map map, String classPath, int ... rowNumIndex) throws Exception {
        Set keySet = map.keySet();
        Class<?> demo = null;
        Object obj = null;
        ArrayList<Object> list = new ArrayList<Object>();
        demo = Class.forName(classPath);
        String fileType = filePath.substring(filePath.lastIndexOf(".") + 1, filePath.length());
        FileInputStream is = new FileInputStream(filePath);
        HSSFWorkbook wb = null;
        if (fileType.equals("xls")) {
            wb = new HSSFWorkbook((InputStream)is);
        } else if (fileType.equals("xlsx")) {
            wb = new XSSFWorkbook((InputStream)is);
        } else {
            throw new Exception("\u60a8\u8f93\u5165\u7684excel\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        for (int sheetNum = 0; sheetNum < wb.getNumberOfSheets(); ++sheetNum) {
            int rowNum_x = -1;
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            ArrayList<String> headlist = new ArrayList<String>();
            Sheet hssfSheet = wb.getSheetAt(sheetNum);
            for (int rowNum = 0; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                int i;
                Row hssfRow;
                if (rowNumIndex != null && rowNumIndex.length > 0 && rowNum_x == -1) {
                    hssfRow = hssfSheet.getRow(rowNumIndex[0]);
                    if (hssfRow == null) {
                        throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    rowNum = rowNumIndex[0] - 1;
                }
                if ((hssfRow = hssfSheet.getRow(rowNum)) == null) continue;
                boolean flag = false;
                for (i = 0; i < hssfRow.getLastCellNum(); ++i) {
                    if (hssfRow.getCell(i) == null || "".equals(hssfRow.getCell(i).toString().trim())) continue;
                    flag = true;
                }
                if (!flag) continue;
                if (rowNum_x == -1) {
                    for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); ++cellNum) {
                        Cell hssfCell = hssfRow.getCell(cellNum);
                        if (hssfCell == null) continue;
                        String tempCellValue = hssfSheet.getRow(rowNum).getCell(cellNum).getStringCellValue();
                        tempCellValue = StringUtils.remove((String)tempCellValue, (char)'\u00a0');
                        tempCellValue = tempCellValue.trim();
                        headlist.add(tempCellValue);
                        for (Object key : keySet) {
                            if (!StringUtils.isNotBlank((CharSequence)tempCellValue) || !StringUtils.equals((CharSequence)tempCellValue, (CharSequence)key.toString())) continue;
                            rowNum_x = rowNum;
                            cellmap.put(map.get(key).toString(), cellNum);
                        }
                        if (rowNum_x != -1) continue;
                        throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5\u6216\u8005\u5bf9\u5e94\u5b57\u6bb5\u884c\u4e0a\u9762\u542b\u6709\u4e0d\u4e3a\u7a7a\u767d\u7684\u884c\u5b57\u6bb5");
                    }
                    for (i = 0; i < headlist.size(); ++i) {
                        boolean boo = false;
                        Iterator itor = keySet.iterator();
                        while (itor.hasNext()) {
                            String tempname = itor.next().toString();
                            if (!tempname.equals(headlist.get(i))) continue;
                            boo = true;
                        }
                        if (boo) continue;
                        throw new Exception("\u8868\u5934\u5b57\u6bb5\u548c\u5b9a\u4e49\u7684\u5c5e\u6027\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
                    }
                    Iterator itor = keySet.iterator();
                    while (itor.hasNext()) {
                        boolean boo = false;
                        String tempname = itor.next().toString();
                        for (int i2 = 0; i2 < headlist.size(); ++i2) {
                            if (!tempname.equals(headlist.get(i2))) continue;
                            boo = true;
                        }
                        if (boo) continue;
                        throw new Exception("\u8868\u5934\u5b57\u6bb5\u548c\u5b9a\u4e49\u7684\u5c5e\u6027\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
                    }
                    continue;
                }
                obj = demo.newInstance();
                for (Object key : keySet) {
                    Integer cellNum_x = (Integer)cellmap.get(map.get(key).toString());
                    if (cellNum_x == null || hssfRow.getCell(cellNum_x.intValue()) == null) continue;
                    String attr = map.get(key).toString();
                    Class attrType = BeanUtils.findPropertyType((String)attr, (Class[])new Class[]{obj.getClass()});
                    Cell cell = hssfRow.getCell(cellNum_x.intValue());
                    ExcelUtil.getValue(cell, obj, attr, attrType, rowNum, cellNum_x, key);
                }
                list.add(obj);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public static <T> List<T> readXlsPart(ExcelParam param) throws Exception {
        Set keySet = param.getMap().keySet();
        Class<?> demo = null;
        Object obj = null;
        ArrayList<Object> list = new ArrayList<Object>();
        demo = Class.forName(param.getClassPath());
        String fileType = param.getFilePath().substring(param.getFilePath().lastIndexOf(".") + 1, param.getFilePath().length());
        FileInputStream is = new FileInputStream(param.getFilePath());
        HSSFWorkbook wb = null;
        if (ExcelTypeEnum.EXCEL_THREE.getText().equals(fileType)) {
            wb = new HSSFWorkbook((InputStream)is);
        } else if (ExcelTypeEnum.EXCEL_SEVEN.getText().equals(fileType)) {
            wb = new XSSFWorkbook((InputStream)is);
        } else {
            throw new Exception("\u60a8\u8f93\u5165\u7684excel\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        int startSheetNum = 0;
        int endSheetNum = 1;
        if (null != param.getSheetIndex()) {
            startSheetNum = param.getSheetIndex() - 1;
            endSheetNum = param.getSheetIndex();
        }
        for (int sheetNum = startSheetNum; sheetNum < endSheetNum; ++sheetNum) {
            int rowNum_x = -1;
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            ArrayList<String> headlist = new ArrayList<String>();
            Sheet hssfSheet = wb.getSheetAt(sheetNum);
            if (hssfSheet != null && hssfSheet.getLastRowNum() > 60000) {
                throw new Exception("Excel \u6570\u636e\u8d85\u8fc760000\u884c,\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u7a7a\u884c,\u6216\u5206\u6279\u5bfc\u5165");
            }
            for (int rowNum = 0; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                Row hssfRow;
                if (param.getRowNumIndex() != null && rowNum_x == -1) {
                    hssfRow = hssfSheet.getRow(param.getRowNumIndex().intValue());
                    if (hssfRow == null) {
                        throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    rowNum = param.getRowNumIndex() - 1;
                }
                if ((hssfRow = hssfSheet.getRow(rowNum)) == null) continue;
                boolean flag = false;
                for (int i = 0; i < hssfRow.getLastCellNum(); ++i) {
                    if (hssfRow.getCell(i) == null || "".equals(hssfRow.getCell(i).toString().trim())) continue;
                    flag = true;
                }
                if (!flag) continue;
                if (rowNum_x == -1) {
                    for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); ++cellNum) {
                        Cell hssfCell = hssfRow.getCell(cellNum);
                        if (hssfCell == null) continue;
                        String tempCellValue = hssfSheet.getRow(rowNum).getCell(cellNum).getStringCellValue();
                        tempCellValue = StringUtils.remove((String)tempCellValue, (char)'\u00a0');
                        tempCellValue = tempCellValue.trim();
                        headlist.add(tempCellValue);
                        for (Object key : keySet) {
                            if (!StringUtils.isNotBlank((CharSequence)tempCellValue) || !StringUtils.equals((CharSequence)tempCellValue, (CharSequence)key.toString())) continue;
                            rowNum_x = rowNum;
                            cellmap.put(param.getMap().get(key).toString(), cellNum);
                        }
                        if (rowNum_x != -1) continue;
                        throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5\u6216\u8005\u5bf9\u5e94\u5b57\u6bb5\u884c\u4e0a\u9762\u542b\u6709\u4e0d\u4e3a\u7a7a\u767d\u7684\u884c\u5b57\u6bb5");
                    }
                    continue;
                }
                obj = demo.newInstance();
                for (Object key : keySet) {
                    Integer cellNum_x = (Integer)cellmap.get(param.getMap().get(key).toString());
                    if (cellNum_x == null || hssfRow.getCell(cellNum_x.intValue()) == null) continue;
                    String attr = param.getMap().get(key).toString();
                    Class attrType = BeanUtils.findPropertyType((String)attr, (Class[])new Class[]{obj.getClass()});
                    Cell cell = hssfRow.getCell(cellNum_x.intValue());
                    ExcelUtil.getValue(cell, obj, attr, attrType, rowNum, cellNum_x, key);
                }
                list.add(obj);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public static void setter(Object obj, String att, Object value, Class<?> type, int row, int col, Object key) throws Exception {
        try {
            Method method = obj.getClass().getMethod("set" + StringUtil.toUpperCaseFirstOne(att), type);
            method.invoke(obj, value);
        }
        catch (Exception e) {
            throw new Exception("\u7b2c" + (row + 1) + " \u884c  " + (col + 1) + "\u5217   \u5c5e\u6027\uff1a" + key + " \u8d4b\u503c\u5f02\u5e38  " + e);
        }
    }

    public static Object getAttrVal(Object obj, String att, Class<?> type) throws Exception {
        try {
            Method method = obj.getClass().getMethod("get" + StringUtil.toUpperCaseFirstOne(att), new Class[0]);
            Object value = new Object();
            value = method.invoke(obj, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void getValue(Cell cell, Object obj, String attr, Class attrType, int row, int col, Object key) throws Exception {
        Object val = null;
        if (cell.getCellType() == 4) {
            val = cell.getBooleanCellValue();
        } else if (cell.getCellType() == 0) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    if (attrType == String.class) {
                        val = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                    }
                    val = ExcelUtil.dateConvertFormat(sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())));
                }
                catch (ParseException e) {
                    throw new Exception("\u7b2c" + (row + 1) + " \u884c  " + (col + 1) + "\u5217   \u5c5e\u6027\uff1a" + key + " \u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef  ");
                }
            } else if (attrType == String.class) {
                cell.setCellType(1);
                val = cell.getStringCellValue();
            } else {
                val = attrType == BigDecimal.class ? new BigDecimal(cell.getNumericCellValue()) : (attrType == Long.TYPE ? (Number)((long)cell.getNumericCellValue()) : (Number)(attrType == Double.class ? (Number)cell.getNumericCellValue() : (Number)(attrType == Float.class ? (Number)Float.valueOf((float)cell.getNumericCellValue()) : (Number)(attrType == Integer.TYPE || attrType == Integer.class ? (Number)((int)cell.getNumericCellValue()) : (Number)(attrType == Short.class ? (Number)((short)cell.getNumericCellValue()) : (Number)cell.getNumericCellValue())))));
            }
        } else if (cell.getCellType() == 1) {
            val = cell.getStringCellValue();
        }
        ExcelUtil.setter(obj, attr, val, attrType, row, col, key);
    }

    public static void exportExcel(String outFilePath, String keyValue, List<?> list, String classPath) throws Exception {
        Map<String, String> map = ExcelUtil.getMap(keyValue);
        List<String> keyList = ExcelUtil.getList(keyValue);
        Class<?> demo = null;
        demo = Class.forName(classPath);
        Object obj = demo.newInstance();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFRow rowHeader = sheet.createRow(0);
        HashMap<String, String> attMap = new HashMap<String, String>();
        int index = 0;
        for (String key : keyList) {
            rowHeader.createCell(index).setCellValue(key);
            attMap.put(Integer.toString(index), map.get(key).toString());
            ++index;
        }
        for (int i = 0; i < list.size(); ++i) {
            HSSFRow row = sheet.createRow(i + 1);
            for (int j = 0; j < map.size(); ++j) {
                Class attrType = BeanUtils.findPropertyType((String)((String)attMap.get(Integer.toString(j))), (Class[])new Class[]{obj.getClass()});
                Object value = ExcelUtil.getAttrVal(list.get(i), (String)attMap.get(Integer.toString(j)), attrType);
                if (null == value) {
                    value = "";
                }
                row.createCell(j).setCellValue(value.toString());
                style.setAlignment((short)2);
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(outFilePath);
            wb.write((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("\u5bfc\u51fa\u5931\u8d25\uff01" + e);
        }
        catch (IOException e) {
            throw new IOException("\u5bfc\u51fa\u5931\u8d25\uff01" + e);
        }
    }

    public static void exportExcelOutputStream(HttpServletResponse response, String keyValue, List<?> list, String classPath, String ... fileName) throws Exception {
        Map<String, String> map = ExcelUtil.getMap(keyValue);
        List<String> keyList = ExcelUtil.getList(keyValue);
        Class<?> demo = null;
        demo = Class.forName(classPath);
        Object obj = demo.newInstance();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFRow rowHeader = sheet.createRow(0);
        HashMap<String, String> attMap = new HashMap<String, String>();
        int index = 0;
        for (String key : keyList) {
            rowHeader.createCell(index).setCellValue(key);
            attMap.put(Integer.toString(index), map.get(key).toString());
            ++index;
        }
        for (int i = 0; i < list.size(); ++i) {
            HSSFRow row = sheet.createRow(i + 1);
            for (int j = 0; j < map.size(); ++j) {
                Class attrType = BeanUtils.findPropertyType((String)((String)attMap.get(Integer.toString(j))), (Class[])new Class[]{obj.getClass()});
                Object value = ExcelUtil.getAttrVal(list.get(i), (String)attMap.get(Integer.toString(j)), attrType);
                if (null == value) {
                    value = "";
                }
                row.createCell(j).setCellValue(value.toString());
                style.setAlignment((short)2);
            }
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            String newFileName = fileName[0];
            if (StringUtils.isEmpty((CharSequence)fileName[0])) {
                newFileName = df.format(new Date());
            }
            ServletOutputStream outstream = response.getOutputStream();
            response.reset();
            response.setHeader("Content-disposition", "attachment; filename=" + new String(newFileName.getBytes(), "iso-8859-1") + ".xls");
            response.setContentType("application/x-download");
            wb.write((OutputStream)outstream);
            outstream.close();
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("\u5bfc\u51fa\u5931\u8d25\uff01" + e);
        }
        catch (IOException e) {
            throw new IOException("\u5bfc\u51fa\u5931\u8d25\uff01" + e);
        }
    }

    public static <T> List<T> readXls(byte[] buf, Map map, String classPath, int ... rowNumIndex) throws Exception {
        Set keySet = map.keySet();
        Class<?> demo = null;
        Object obj = null;
        ArrayList<Object> list = new ArrayList<Object>();
        demo = Class.forName(classPath);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        HSSFWorkbook wb = null;
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)is)) {
            wb = new HSSFWorkbook((InputStream)is);
        }
        if (POIXMLDocument.hasOOXMLHeader((InputStream)is)) {
            wb = new XSSFWorkbook(OPCPackage.open((InputStream)is));
        }
        for (int sheetNum = 0; sheetNum < wb.getNumberOfSheets(); ++sheetNum) {
            int rowNum_x = -1;
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            ArrayList<String> headlist = new ArrayList<String>();
            Sheet hssfSheet = wb.getSheetAt(sheetNum);
            for (int rowNum = 0; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                int i;
                Row hssfRow;
                if (rowNumIndex != null && rowNumIndex.length > 0 && rowNum_x == -1) {
                    hssfRow = hssfSheet.getRow(rowNumIndex[0]);
                    if (hssfRow == null) {
                        throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    rowNum = rowNumIndex[0] - 1;
                }
                if ((hssfRow = hssfSheet.getRow(rowNum)) == null) continue;
                boolean flag = false;
                for (i = 0; i < hssfRow.getLastCellNum(); ++i) {
                    if (hssfRow.getCell(i) == null || "".equals(hssfRow.getCell(i).toString().trim())) continue;
                    flag = true;
                }
                if (!flag) continue;
                if (rowNum_x == -1) {
                    for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); ++cellNum) {
                        Cell hssfCell = hssfRow.getCell(cellNum);
                        if (hssfCell == null) continue;
                        String tempCellValue = hssfSheet.getRow(rowNum).getCell(cellNum).getStringCellValue();
                        tempCellValue = StringUtils.remove((String)tempCellValue, (char)'\u00a0');
                        tempCellValue = tempCellValue.trim();
                        headlist.add(tempCellValue);
                        for (Object key : keySet) {
                            if (!StringUtils.isNotBlank((CharSequence)tempCellValue) || !StringUtils.equals((CharSequence)tempCellValue, (CharSequence)key.toString())) continue;
                            rowNum_x = rowNum;
                            cellmap.put(map.get(key).toString(), cellNum);
                        }
                        if (rowNum_x != -1) continue;
                        throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5\u6216\u8005\u5bf9\u5e94\u5b57\u6bb5\u884c\u4e0a\u9762\u542b\u6709\u4e0d\u4e3a\u7a7a\u767d\u7684\u884c\u5b57\u6bb5");
                    }
                    for (i = 0; i < headlist.size(); ++i) {
                        boolean boo = false;
                        Iterator itor = keySet.iterator();
                        while (itor.hasNext()) {
                            String tempname = itor.next().toString();
                            if (!tempname.equals(headlist.get(i))) continue;
                            boo = true;
                        }
                        if (boo) continue;
                        throw new Exception("\u8868\u5934\u5b57\u6bb5\u548c\u5b9a\u4e49\u7684\u5c5e\u6027\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
                    }
                    Iterator itor = keySet.iterator();
                    while (itor.hasNext()) {
                        boolean boo = false;
                        String tempname = itor.next().toString();
                        for (int i2 = 0; i2 < headlist.size(); ++i2) {
                            if (!tempname.equals(headlist.get(i2))) continue;
                            boo = true;
                        }
                        if (boo) continue;
                        throw new Exception("\u8868\u5934\u5b57\u6bb5\u548c\u5b9a\u4e49\u7684\u5c5e\u6027\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
                    }
                    continue;
                }
                obj = demo.newInstance();
                for (Object key : keySet) {
                    Integer cellNum_x = (Integer)cellmap.get(map.get(key).toString());
                    if (cellNum_x == null || hssfRow.getCell(cellNum_x.intValue()) == null) continue;
                    String attr = map.get(key).toString();
                    Class attrType = BeanUtils.findPropertyType((String)attr, (Class[])new Class[]{obj.getClass()});
                    Cell cell = hssfRow.getCell(cellNum_x.intValue());
                    ExcelUtil.getValue(cell, obj, attr, attrType, rowNum, cellNum_x, key);
                }
                list.add(obj);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public static Date dateConvertFormat(String dateStr) throws ParseException {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        date = format.parse(dateStr);
        return date;
    }
}

