/*
 * Decompiled with CFR 0.152.
 */
package com.lkx.util;

import com.lkx.util.Excel;
import com.lkx.util.ExcelParam;
import com.lkx.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelUtilBase {
    public static Map<String, String> getMap(String keyValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (keyValue != null) {
            String[] str;
            for (String element : str = keyValue.split(",")) {
                String[] str2 = element.split(":");
                map.put(str2[0], str2[1]);
            }
        }
        return map;
    }

    public static Map<String, String> getMap(Class<T> clazz) throws NoSuchFieldException {
        int i;
        HashMap<String, String> map = new HashMap<String, String>();
        Field[] fields = clazz.getDeclaredFields();
        for (i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
        }
        for (i = 0; i < fields.length; ++i) {
            Field field = clazz.getDeclaredField(fields[i].getName());
            Excel column = field.getAnnotation(Excel.class);
            if (column == null) continue;
            map.put(column.title(), field.getName());
        }
        return map;
    }

    public static List<String> getList(String keyValue) {
        ArrayList<String> list = new ArrayList<String>();
        if (keyValue != null) {
            String[] str;
            for (String element : str = keyValue.split(",")) {
                String[] str2 = element.split(":");
                list.add(str2[0]);
            }
        }
        return list;
    }

    public static List<String> getList(Class<T> clazz) throws NoSuchFieldException {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        Field[] fields = clazz.getDeclaredFields();
        for (i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
        }
        for (i = 0; i < fields.length; ++i) {
            Field field = clazz.getDeclaredField(fields[i].getName());
            Excel column = field.getAnnotation(Excel.class);
            if (column == null) continue;
            list.add(column.title());
        }
        return list;
    }

    public static List getResult(ExcelParam excelParam) throws Exception {
        Set keySet = null;
        if (excelParam.getMap() == null || excelParam.getMap().size() == 0) {
            excelParam.setMap(ExcelUtilBase.getMap(excelParam.getClazz()));
            keySet = excelParam.getMap().keySet();
        } else {
            keySet = excelParam.getMap().keySet();
        }
        ArrayList list = new ArrayList();
        String fileType = "";
        InputStream is = null;
        Workbook wb = null;
        if (excelParam.getStream().booleanValue()) {
            is = new ByteArrayInputStream(excelParam.getBuf());
            wb = WorkbookFactory.create((InputStream)is);
        } else {
            fileType = excelParam.getFilePath().substring(excelParam.getFilePath().lastIndexOf(".") + 1, excelParam.getFilePath().length());
            is = new FileInputStream(excelParam.getFilePath());
            if (fileType.equals("xls")) {
                wb = new HSSFWorkbook(is);
            } else if (fileType.equals("xlsx")) {
                wb = new XSSFWorkbook(is);
            } else {
                throw new Exception("\u60a8\u8f93\u5165\u7684excel\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        int startSheetNum = 0;
        int endSheetNum = 1;
        if (null != excelParam.getSheetIndex()) {
            startSheetNum = excelParam.getSheetIndex() - 1;
            endSheetNum = excelParam.getSheetIndex();
        }
        for (int sheetNum = startSheetNum; sheetNum < endSheetNum; ++sheetNum) {
            int rowNum_x = -1;
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            ArrayList<String> headlist = new ArrayList<String>();
            Sheet hssfSheet = wb.getSheetAt(sheetNum);
            if (hssfSheet != null && hssfSheet.getLastRowNum() > 500000) {
                throw new Exception("Excel \u6570\u636e\u8d85\u8fc750w\u884c,\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u7a7a\u884c,\u6216\u5206\u6279\u5bfc\u5165");
            }
            for (int rowNum = 0; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                int i;
                Row hssfRow;
                if (excelParam.getRowNumIndex() != null && rowNum_x == -1) {
                    hssfRow = hssfSheet.getRow(excelParam.getRowNumIndex().intValue());
                    if (hssfRow == null) {
                        throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    rowNum = excelParam.getRowNumIndex() - 1;
                }
                if ((hssfRow = hssfSheet.getRow(rowNum)) == null) continue;
                boolean flag = false;
                for (i = 0; i < hssfRow.getLastCellNum(); ++i) {
                    if (hssfRow.getCell(i) == null || "".equals(hssfRow.getCell(i).toString().trim())) continue;
                    flag = true;
                }
                if (!flag) continue;
                if (rowNum_x == -1) {
                    for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); ++cellNum) {
                        Cell hssfCell = hssfRow.getCell(cellNum);
                        if (hssfCell == null) continue;
                        String tempCellValue = hssfSheet.getRow(rowNum).getCell(cellNum).getStringCellValue();
                        tempCellValue = StringUtils.remove((String)tempCellValue, (char)'\u00a0');
                        tempCellValue = tempCellValue.trim();
                        headlist.add(tempCellValue);
                        for (Object key : keySet) {
                            if (!StringUtils.isNotBlank((CharSequence)tempCellValue) || !StringUtils.equals((CharSequence)tempCellValue, (CharSequence)key.toString())) continue;
                            rowNum_x = rowNum;
                            cellmap.put(excelParam.getMap().get(key).toString(), cellNum);
                        }
                        if (rowNum_x != -1) continue;
                        throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5\u6216\u8005\u5bf9\u5e94\u5b57\u6bb5\u884c\u4e0a\u9762\u542b\u6709\u4e0d\u4e3a\u7a7a\u767d\u7684\u884c\u5b57\u6bb5");
                    }
                    if (!excelParam.getSameHeader().booleanValue()) continue;
                    for (i = 0; i < headlist.size(); ++i) {
                        boolean boo = false;
                        Iterator itor = keySet.iterator();
                        while (itor.hasNext()) {
                            String tempname = itor.next().toString();
                            if (!tempname.equals(headlist.get(i))) continue;
                            boo = true;
                        }
                        if (boo) continue;
                        throw new Exception("\u8868\u5934\u5b57\u6bb5\u548c\u5b9a\u4e49\u7684\u5c5e\u6027\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
                    }
                    Iterator itor = keySet.iterator();
                    while (itor.hasNext()) {
                        boolean boo = false;
                        String tempname = itor.next().toString();
                        for (int i2 = 0; i2 < headlist.size(); ++i2) {
                            if (!tempname.equals(headlist.get(i2))) continue;
                            boo = true;
                        }
                        if (boo) continue;
                        throw new Exception("\u8868\u5934\u5b57\u6bb5\u548c\u5b9a\u4e49\u7684\u5c5e\u6027\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
                    }
                    continue;
                }
                Object obj = excelParam.getClazz().newInstance();
                for (Object key : keySet) {
                    Integer cellNum_x = (Integer)cellmap.get(excelParam.getMap().get(key).toString());
                    if (cellNum_x == null || hssfRow.getCell(cellNum_x.intValue()) == null) continue;
                    String attr = excelParam.getMap().get(key).toString();
                    Class attrType = BeanUtils.findPropertyType((String)attr, (Class[])new Class[]{obj.getClass()});
                    Cell cell = hssfRow.getCell(cellNum_x.intValue());
                    ExcelUtilBase.getValue(cell, obj, attr, attrType, rowNum, cellNum_x, key);
                }
                list.add(obj);
            }
        }
        is.close();
        return list;
    }

    public static void commonExportExcel(ExcelParam excelParam) throws Exception {
        Map<String, String> map = ExcelUtilBase.getMap(excelParam.getClazz());
        List<String> keyList = null;
        keyList = StringUtils.isEmpty((CharSequence)excelParam.getKeyValue()) ? ExcelUtilBase.getList(excelParam.getClazz()) : ExcelUtilBase.getList(excelParam.getKeyValue());
        Object obj = excelParam.getClazz().newInstance();
        XSSFWorkbook wb = new XSSFWorkbook();
        Sheet sheet = wb.createSheet("sheet1");
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        Row rowHeader = sheet.createRow(0);
        HashMap<String, String> attMap = new HashMap<String, String>();
        int index = 0;
        for (String key : keyList) {
            rowHeader.createCell(index).setCellValue(key);
            attMap.put(Integer.toString(index), map.get(key).toString());
            ++index;
        }
        for (int i = 0; i < excelParam.getList().size(); ++i) {
            Row row = sheet.createRow(i + 1);
            for (int j = 0; j < map.size(); ++j) {
                Class attrType = BeanUtils.findPropertyType((String)((String)attMap.get(Integer.toString(j))), (Class[])new Class[]{obj.getClass()});
                Object value = ExcelUtilBase.getAttrVal(excelParam.getList().get(i), (String)attMap.get(Integer.toString(j)), attrType);
                if (null == value) {
                    value = "";
                }
                row.createCell(j).setCellValue(value.toString());
                style.setAlignment(HorizontalAlignment.CENTER);
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String newFileName = excelParam.getFileName();
        if (StringUtils.isEmpty((CharSequence)newFileName)) {
            newFileName = df.format(new Date());
        }
        try {
            if (excelParam.getResponse() != null) {
                ServletOutputStream outstream = excelParam.getResponse().getOutputStream();
                excelParam.getResponse().reset();
                excelParam.getResponse().setHeader("Content-disposition", "attachment; filename=" + new String(newFileName.getBytes(), "iso-8859-1") + ".xlsx");
                excelParam.getResponse().setContentType("application/x-download");
                wb.write((OutputStream)outstream);
                outstream.close();
            } else {
                FileOutputStream out = new FileOutputStream(excelParam.getOutFilePath());
                wb.write((OutputStream)out);
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("\u5bfc\u51fa\u5931\u8d25\uff01" + e);
        }
        catch (IOException e) {
            throw new IOException("\u5bfc\u51fa\u5931\u8d25\uff01" + e);
        }
    }

    public static void setter(Object obj, String att, Object value, Class<?> type, int row, int col, Object key) throws Exception {
        try {
            Method method = obj.getClass().getMethod("set" + StringUtil.toUpperCaseFirstOne(att), type);
            method.invoke(obj, value);
        }
        catch (Exception e) {
            throw new Exception("\u7b2c" + (row + 1) + " \u884c  " + (col + 1) + "\u5217   \u5c5e\u6027\uff1a" + key + " \u8d4b\u503c\u5f02\u5e38  " + e);
        }
    }

    public static Object getAttrVal(Object obj, String att, Class<?> type) throws Exception {
        try {
            Method method = obj.getClass().getMethod("get" + StringUtil.toUpperCaseFirstOne(att), new Class[0]);
            Object value = method.invoke(obj, new Object[0]);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void getValue(Cell cell, Object obj, String attr, Class attrType, int row, int col, Object key) throws Exception {
        Object val = null;
        if (cell.getCellType() == CellType.BOOLEAN) {
            val = cell.getBooleanCellValue();
        } else if (cell.getCellType() == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    if (attrType == String.class) {
                        val = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                    }
                    val = ExcelUtilBase.dateConvertFormat(sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())));
                }
                catch (ParseException e) {
                    throw new Exception("\u7b2c" + (row + 1) + " \u884c  " + (col + 1) + "\u5217   \u5c5e\u6027\uff1a" + key + " \u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef  ");
                }
            } else if (attrType == String.class) {
                cell.setCellType(CellType.STRING);
                val = cell.getStringCellValue();
            } else {
                val = attrType == BigDecimal.class ? new BigDecimal(cell.getNumericCellValue()) : (attrType == Long.TYPE ? (Number)((long)cell.getNumericCellValue()) : (Number)(attrType == Double.class ? (Number)cell.getNumericCellValue() : (Number)(attrType == Float.class ? (Number)Float.valueOf((float)cell.getNumericCellValue()) : (Number)(attrType == Integer.TYPE || attrType == Integer.class ? (Number)((int)cell.getNumericCellValue()) : (Number)(attrType == Short.class ? (Number)((short)cell.getNumericCellValue()) : (Number)cell.getNumericCellValue())))));
            }
        } else if (cell.getCellType() == CellType.STRING) {
            val = attrType.equals(Double.TYPE) || attrType.equals(Double.class) ? Double.valueOf(Double.parseDouble(cell.getStringCellValue())) : cell.getStringCellValue();
        }
        ExcelUtilBase.setter(obj, attr, val, attrType, row, col, key);
    }

    public static Date dateConvertFormat(String dateStr) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = format.parse(dateStr);
        return date;
    }
}

