/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.parser.Expression;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.Tag;
import net.sf.jxls.tag.TagContext;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.xml.sax.SAXException;

public class CellParser {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Cell cell;
    private Configuration configuration;

    public CellParser(HSSFCell hssfCell, Row row, Configuration configuration) {
        this.cell = new Cell(hssfCell, row);
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    public CellParser(Cell cell) {
        this.cell = cell;
    }

    public Cell getCell() {
        return this.cell;
    }

    public Cell parseCell(Map beans) {
        if (this.cell.getHssfCell() != null) {
            try {
                if (this.cell.getHssfCell().getCellType() == 1) {
                    this.cell.setHssfCellValue(this.cell.getHssfCell().getRichStringCellValue().getString());
                    this.parseCellValue(beans);
                }
            }
            catch (ParsePropertyException e) {
                this.log.error((Object)("Can't get value for property=" + this.cell.getCollectionProperty().getProperty()), (Throwable)e);
                throw new RuntimeException(e);
            }
            this.updateMergedRegions();
        }
        return this.cell;
    }

    public Formula parseCellFormula() {
        if (this.cell.getHssfCell() != null && this.cell.getHssfCell().getCellType() == 1) {
            this.cell.setHssfCellValue(this.cell.getHssfCell().getRichStringCellValue().getString());
            if (this.cell.getHssfCellValue().startsWith(this.configuration.getStartFormulaToken()) && this.cell.getHssfCellValue().lastIndexOf(this.configuration.getEndFormulaToken()) > 0) {
                this.parseFormula();
            }
        }
        return this.cell.getFormula();
    }

    private void parseFormula() {
        int i = this.cell.getHssfCellValue().lastIndexOf(this.configuration.getEndFormulaToken());
        String expr = this.cell.getHssfCellValue().substring(2, i);
        this.cell.setFormula(new Formula(expr));
        this.cell.getFormula().setRowNum(new Integer(this.cell.getRow().getHssfRow().getRowNum()));
        this.cell.getFormula().setCellNum(new Integer(this.cell.getHssfCell().getColumnIndex()));
        if (i + 1 < this.cell.getHssfCellValue().length()) {
            String tail = this.cell.getHssfCellValue().substring(i + 1);
            int j = tail.indexOf(this.configuration.getMetaInfoToken());
            if (j >= 0) {
                this.cell.setMetaInfo(tail.substring(j));
                if (j > 0) {
                    this.cell.setLabel(tail.substring(0, j));
                }
                this.cell.setCollectionName(tail.substring(j + 2));
            } else {
                this.cell.setLabel(tail);
            }
        }
        this.cell.setStringCellValue(this.cell.getHssfCellValue().substring(0, i + 1));
    }

    private void parseCellExpression(Map beans) {
        int k;
        this.cell.setCollectionProperty(null);
        String curValue = this.cell.getHssfCellValue();
        int depRowNum = 0;
        int j = curValue.lastIndexOf(this.configuration.getMetaInfoToken());
        if (j >= 0) {
            this.cell.setStringCellValue(this.cell.getHssfCellValue().substring(0, j));
            this.cell.setMetaInfo(this.cell.getHssfCellValue().substring(j + 2));
            String tail = curValue.substring(j + 2);
            k = tail.indexOf(":");
            if (k >= 0) {
                try {
                    depRowNum = Integer.parseInt(tail.substring(k + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.cell.setCollectionName(tail.substring(0, k));
            } else {
                this.cell.setCollectionName(tail);
            }
            curValue = curValue.substring(0, j);
        } else {
            this.cell.setStringCellValue(this.cell.getHssfCellValue());
        }
        try {
            while (curValue.length() > 0) {
                int i = curValue.indexOf(this.configuration.getStartExpressionToken());
                if (i >= 0) {
                    k = curValue.indexOf(this.configuration.getEndExpressionToken(), i + 2);
                    if (k >= 0) {
                        Expression expression;
                        String expr = curValue.substring(i + 2, k);
                        if (i > 0) {
                            String before = curValue.substring(0, i);
                            this.cell.getExpressions().add(new Expression(before, this.configuration));
                        }
                        if ((expression = new Expression(expr, beans, this.configuration)).getCollectionProperty() != null) {
                            if (this.cell.getCollectionProperty() == null) {
                                this.cell.setCollectionName(expression.getCollectionProperty().getFullCollectionName());
                                this.cell.setCollectionProperty(expression.getCollectionProperty());
                                this.cell.setDependentRowNumber(depRowNum);
                            } else if (this.log.isInfoEnabled()) {
                                this.log.info((Object)"Only the same collection property in a cell is allowed.");
                            }
                        }
                        this.cell.getExpressions().add(expression);
                        curValue = curValue.substring(k + 1, curValue.length());
                        continue;
                    }
                    this.cell.getExpressions().add(new Expression(curValue, this.configuration));
                    curValue = "";
                    continue;
                }
                if (curValue.length() != this.cell.getHssfCellValue().length()) {
                    this.cell.getExpressions().add(new Expression(curValue, this.configuration));
                }
                curValue = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)"Can't parse expression", (Throwable)e);
        }
    }

    private void parseCellValue(Map beans) throws ParsePropertyException {
        if (this.cell.getHssfCellValue() != null) {
            if (this.cell.getHssfCellValue().startsWith(this.configuration.getStartFormulaToken()) && this.cell.getHssfCellValue().lastIndexOf(this.configuration.getEndFormulaToken()) > 0) {
                this.parseFormula();
            } else if (this.cell.getHssfCellValue().startsWith("<" + this.configuration.getTagPrefix())) {
                String tagName = this.getTagName(this.cell.getHssfCellValue());
                if (tagName != null) {
                    if (this.cell.getHssfCellValue().endsWith("/>")) {
                        Block tagBody = new Block(this.cell.getRow().getHssfRow().getRowNum(), this.cell.getHssfCell().getColumnIndex(), this.cell.getRow().getHssfRow().getRowNum(), this.cell.getHssfCell().getColumnIndex());
                        this.parseTag(tagName, tagBody, beans, false);
                    } else {
                        HSSFCell hssfCell = this.findMatchingPairInRow(this.cell.getRow().getHssfRow(), tagName);
                        if (hssfCell != null) {
                            Block tagBody = new Block(this.cell.getRow().getHssfRow().getRowNum(), this.cell.getHssfCell().getColumnIndex(), this.cell.getRow().getHssfRow().getRowNum(), hssfCell.getColumnIndex());
                            this.parseTag(tagName, tagBody, beans, true);
                        } else {
                            HSSFRow hssfRow = this.findMatchingPair(tagName);
                            if (hssfRow != null) {
                                int lastTagBodyRowNum = hssfRow.getRowNum();
                                Block tagBody = new Block(null, this.cell.getRow().getHssfRow().getRowNum(), lastTagBodyRowNum);
                                this.parseTag(tagName, tagBody, beans, true);
                            } else {
                                this.log.error((Object)("Can't find matching tag pair for " + this.cell.getHssfCellValue()));
                            }
                        }
                    }
                }
            } else {
                this.parseCellExpression(beans);
            }
        }
    }

    private HSSFCell findMatchingPairInRow(HSSFRow hssfRow, String tagName) {
        int count = 0;
        if (hssfRow != null) {
            for (int j = this.cell.getHssfCell().getColumnIndex() + 1; j <= hssfRow.getLastCellNum(); ++j) {
                HSSFCell hssfCell = hssfRow.getCell(j);
                if (hssfCell == null || hssfCell.getCellType() != 1) continue;
                String cellValue = hssfCell.getRichStringCellValue().getString();
                if (cellValue.matches("<" + this.configuration.getTagPrefix() + tagName + "\\b.*")) {
                    ++count;
                    continue;
                }
                if (!cellValue.matches("</" + this.configuration.getTagPrefix() + tagName + ">")) continue;
                if (count == 0) {
                    return hssfCell;
                }
                --count;
            }
        }
        return null;
    }

    private String getTagName(String xmlTag) {
        int i;
        int j;
        for (j = i = this.configuration.getTagPrefix().length() + 1; j < xmlTag.length() && Character.isLetterOrDigit(xmlTag.charAt(j)); ++j) {
        }
        if (j == xmlTag.length()) {
            this.log.warn((Object)"can't determine tag name");
            return null;
        }
        return xmlTag.substring(i, j);
    }

    private HSSFRow findMatchingPair(String tagName) {
        HSSFSheet hssfSheet = this.cell.getRow().getSheet().getHssfSheet();
        int count = 0;
        for (int i = this.cell.getRow().getHssfRow().getRowNum() + 1; i <= hssfSheet.getLastRowNum(); ++i) {
            HSSFRow hssfRow = hssfSheet.getRow(i);
            if (hssfRow == null) continue;
            for (short j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); j = (short)(j + 1)) {
                HSSFCell hssfCell = hssfRow.getCell((int)j);
                if (hssfCell == null || hssfCell.getCellType() != 1) continue;
                String cellValue = hssfCell.getRichStringCellValue().getString();
                if (cellValue.matches("<" + this.configuration.getTagPrefix() + tagName + "\\b.*")) {
                    ++count;
                    continue;
                }
                if (!cellValue.matches("</" + this.configuration.getTagPrefix() + tagName + ">")) continue;
                if (count == 0) {
                    return hssfRow;
                }
                --count;
            }
        }
        return null;
    }

    private void parseTag(String tagName, Block tagBody, Map beans, boolean appendCloseTag) {
        String xml = null;
        try {
            Tag tag;
            xml = appendCloseTag ? this.configuration.getJXLSRoot() + this.cell.getHssfCellValue() + "</" + this.configuration.getTagPrefix() + tagName + ">" + this.configuration.getJXLSRootEnd() : this.configuration.getJXLSRoot() + this.cell.getHssfCellValue() + this.configuration.getJXLSRootEnd();
            if (this.configuration.getEncodeXMLAttributes()) {
                xml = Util.escapeAttributes(xml);
            }
            if ((tag = (Tag)this.configuration.getDigester().parse((Reader)new StringReader(xml))) == null) {
                throw new RuntimeException("Invalid tag: " + tagName);
            }
            this.cell.setTag(tag);
            TagContext tagContext = new TagContext(this.cell.getRow().getSheet(), tagBody, beans);
            tag.init(tagContext);
        }
        catch (IOException e) {
            this.log.warn((Object)("Can't parse cell tag " + this.cell.getHssfCellValue() + ": fullXML: " + xml), (Throwable)e);
            throw new RuntimeException("Can't parse cell tag " + this.cell.getHssfCellValue() + ": fullXML: " + xml, e);
        }
        catch (SAXException e) {
            this.log.warn((Object)("Can't parse cell tag " + this.cell.getHssfCellValue() + ": fullXML: " + xml), (Throwable)e);
            throw new RuntimeException("Can't parse cell tag " + this.cell.getHssfCellValue() + ": fullXML: " + xml, e);
        }
    }

    private void updateMergedRegions() {
        this.cell.setMergedRegion(Util.getMergedRegion(this.cell.getRow().getSheet().getHssfSheet(), this.cell.getRow().getHssfRow().getRowNum(), this.cell.getHssfCell().getColumnIndex()));
    }
}

