/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoClosure<T extends Item>
extends Closure<T> {
    private T[] reservoir = null;
    private int used;
    protected int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    @Override
    public synchronized SequenceIterator<T> iterate() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                this.inputIterator = this.expression.iterate(this.savedXPathContext);
                if (this.inputIterator instanceof EmptyIterator) {
                    this.state = 5;
                    return this.inputIterator;
                }
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                switch (this.used) {
                    case 0: {
                        this.state = 5;
                        return EmptyIterator.emptyIterator();
                    }
                    case 1: {
                        assert (this.reservoir != null);
                        return SingletonIterator.makeIterator(this.reservoir[0]);
                    }
                }
                return new ArrayIterator(this.reservoir, 0, this.used);
            }
            case 4: {
                XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
                de.setErrorCode("XTDE0640");
                throw de;
            }
            case 5: {
                return EmptyIterator.emptyIterator();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    @Override
    public synchronized void process(XPathContext context) throws XPathException {
        if (this.state == 5) {
            return;
        }
        if (this.state == 4) {
            XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
            de.setErrorCode("XTDE0640");
            de.setXPathContext(context);
            throw de;
        }
        if (this.reservoir != null) {
            T it;
            SequenceIterator<T> iter = this.iterate();
            SequenceReceiver out = context.getReceiver();
            while ((it = iter.next()) != null) {
                out.append((Item)it, 0, 2);
            }
        } else {
            this.state = 4;
            Controller controller = context.getController();
            XPathContextMajor c2 = this.savedXPathContext.newContext();
            SequenceOutputter seq = controller.allocateSequenceOutputter(20);
            seq.open();
            TeeOutputter tee = new TeeOutputter(context.getReceiver(), seq);
            tee.setPipelineConfiguration(controller.makePipelineConfiguration());
            c2.setReceiver(tee);
            c2.setTemporaryOutputState(true);
            this.expression.process(c2);
            seq.close();
            List<Item> list = seq.getList();
            if (list.isEmpty()) {
                this.state = 5;
            } else {
                this.reservoir = new Item[list.size()];
                this.reservoir = (Item[])list.toArray(this.reservoir);
                this.used = list.size();
                this.state = 3;
            }
            this.savedXPathContext = null;
            seq.reset();
        }
    }

    private void append(T item) {
        assert (this.reservoir != null);
        if (this.used >= this.reservoir.length) {
            Item[] r2 = new Item[this.used * 2];
            System.arraycopy(this.reservoir, 0, r2, 0, this.used);
            this.reservoir = r2;
        }
        this.reservoir[this.used++] = item;
    }

    private void condense() {
        if (this.reservoir != null && this.reservoir.length - this.used > 30) {
            Item[] r2 = new Item[this.used];
            System.arraycopy(this.reservoir, 0, r2, 0, this.used);
            this.reservoir = r2;
        }
        this.savedXPathContext = null;
    }

    public boolean isFullyRead() {
        return this.state == 5 || this.state == 3;
    }

    public GroundedValue materialize() throws XPathException {
        if (this.state == 3) {
            return new SequenceExtent(this.reservoir, 0, this.used);
        }
        if (this.state == 5) {
            return EmptySequence.getInstance();
        }
        return new SequenceExtent<T>(this.iterate());
    }

    static /* synthetic */ Item[] access$102(MemoClosure x0, Item[] x1) {
        x0.reservoir = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ProgressiveIterator
    implements SequenceIterator<T>,
    LastPositionFinder<T>,
    GroundedIterator<T> {
        int position = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() throws XPathException {
            MemoClosure memoClosure = MemoClosure.this;
            synchronized (memoClosure) {
                if (this.position == -2) {
                    return null;
                }
                if (++this.position < MemoClosure.this.used) {
                    assert (MemoClosure.this.reservoir != null);
                    return MemoClosure.this.reservoir[this.position];
                }
                if (MemoClosure.this.state == 3) {
                    this.position = -2;
                    return null;
                }
                assert (MemoClosure.this.inputIterator != null);
                Object i = MemoClosure.this.inputIterator.next();
                if (i == null) {
                    MemoClosure.this.state = 3;
                    MemoClosure.this.condense();
                    this.position = -2;
                    return null;
                }
                this.position = MemoClosure.this.used;
                MemoClosure.this.append(i);
                MemoClosure.this.state = 1;
                return i;
            }
        }

        @Override
        public T current() {
            if (this.position < 0) {
                return null;
            }
            assert (MemoClosure.this.reservoir != null);
            return MemoClosure.this.reservoir[this.position];
        }

        @Override
        public int position() {
            return this.position + 1;
        }

        @Override
        public void close() {
        }

        public ProgressiveIterator getAnother() {
            return new ProgressiveIterator();
        }

        @Override
        public int getLength() throws XPathException {
            Object item;
            if (MemoClosure.this.state == 3) {
                return MemoClosure.this.used;
            }
            if (MemoClosure.this.state == 5) {
                return 0;
            }
            int savePos = this.position;
            while ((item = this.next()) != null) {
            }
            this.position = savePos;
            return MemoClosure.this.used;
        }

        @Override
        public GroundedValue materialize() throws XPathException {
            if (MemoClosure.this.state == 3) {
                assert (MemoClosure.this.reservoir != null);
                return new SequenceExtent(MemoClosure.this.reservoir, 0, MemoClosure.this.used);
            }
            if (MemoClosure.this.state == 5) {
                return EmptySequence.getInstance();
            }
            return new SequenceExtent(MemoClosure.this.iterate());
        }

        @Override
        public int getProperties() {
            return 3;
        }

        public synchronized T itemAt(int n) throws XPathException {
            if (n < 0) {
                return null;
            }
            if (MemoClosure.this.reservoir != null && n < MemoClosure.this.used) {
                return MemoClosure.this.reservoir[n];
            }
            if (MemoClosure.this.state == 3 || MemoClosure.this.state == 5) {
                return null;
            }
            if (MemoClosure.this.state == 0) {
                Object item = MemoClosure.this.inputIterator.next();
                MemoClosure.this.state = 1;
                if (item == null) {
                    MemoClosure.this.state = 5;
                    return null;
                }
                MemoClosure.this.state = 1;
                MemoClosure.access$102(MemoClosure.this, new Item[50]);
                MemoClosure.this.used = 0;
                MemoClosure.this.append(item);
                if (n == 0) {
                    return item;
                }
            }
            int diff = n - MemoClosure.this.used + 1;
            while (diff-- > 0) {
                Object i = MemoClosure.this.inputIterator.next();
                if (i == null) {
                    MemoClosure.this.state = 3;
                    MemoClosure.this.condense();
                    return null;
                }
                MemoClosure.this.append(i);
                MemoClosure.this.state = 1;
            }
            return MemoClosure.this.reservoir[n];
        }
    }
}

