/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statscm;

import java.io.File;
import java.io.IOException;
import net.sf.statscm.ConsoleErrorStream;
import net.sf.statscm.ConsoleFileStream;
import net.sf.statscm.StatConf;
import org.apache.maven.plugin.logging.Log;

public class SrcManager {
    private static final int MILLISECONDS_BETEEW_THREAD_POLL = 200;

    public boolean log(File baseDir, Log log, StatConf statConf) {
        String[] commad;
        if (statConf.isStatSVN()) {
            commad = new String[]{"svn", "log", baseDir.getAbsolutePath(), "-v", "--xml"};
        } else if (statConf.isStatCVS()) {
            commad = new String[]{"cvs", "log"};
        } else {
            log.warn((CharSequence)"Can not get log file for SCM Repository Type.");
            return false;
        }
        File file = new File(StatConf.getLogFileName());
        try {
            log.info((CharSequence)("scm log > " + file.getAbsolutePath()));
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(commad);
            ConsoleErrorStream errorGobbler = new ConsoleErrorStream(proc.getErrorStream(), log);
            ConsoleFileStream logStream = new ConsoleFileStream(proc.getInputStream(), file, log);
            errorGobbler.start();
            logStream.start();
            while (errorGobbler.isAlive() || logStream.isAlive()) {
                Thread.sleep(200L);
            }
            log.info((CharSequence)("scm log ...; exitValue: " + proc.waitFor()));
        }
        catch (IOException e) {
            log.error((CharSequence)"Error Getting SCM log.", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((CharSequence)"Error Getting SCM log.", (Throwable)e);
        }
        catch (Exception e) {
            log.error((CharSequence)"Error Getting SCM log.", (Throwable)e);
        }
        return true;
    }
}

