/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statscm;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.ConfigurationOptions;
import org.apache.maven.model.Build;
import org.apache.maven.model.Developer;
import org.apache.maven.project.MavenProject;

public class StatConf
extends ConfigurationOptions {
    protected static final String STATSCM_DIR_NAME = "statscm";
    protected static final String CONNECTION_TYPE_SVN = "svn";
    protected static final String CONNECTION_TYPE_CVS = "cvs";
    protected String FILE_SEPARATOR = System.getProperty("file.separator");
    private String connectionType;
    private Locale locale = Locale.US;
    private File baseDirectory = new File(".");

    StatConf() {
    }

    public void configure(MavenProject project, Locale locale) throws ConfigurationException {
        this.locale = locale;
        if (project.getBasedir() != null) {
            this.baseDirectory = project.getBasedir();
        }
        if (project.getScm() == null) {
            throw new ConfigurationException("There must be scm section in your pom.xml file.");
        }
        StatConf.setOutputFormat((String)"xdoc");
        String buildBaseDirectory = null;
        Build build = project.getBuild();
        if (build != null) {
            buildBaseDirectory = build.getDirectory();
        }
        if (buildBaseDirectory == null) {
            buildBaseDirectory = this.baseDirectory.getAbsolutePath() + this.FILE_SEPARATOR + "target";
        }
        StatConf.setOutputDir((String)(buildBaseDirectory + this.FILE_SEPARATOR + "generated-site" + this.FILE_SEPARATOR + "xdoc" + this.FILE_SEPARATOR + STATSCM_DIR_NAME));
        this.connectionType = null;
        if (project.getScm().getConnection() != null) {
            this.connectionType = StatConf.extractConnectionType(project.getScm().getConnection());
        }
        if (this.connectionType == null) {
            this.connectionType = StatConf.extractConnectionType(project.getScm().getDeveloperConnection());
        }
        if (this.connectionType == null) {
            throw new ConfigurationException("There must be scm connection url section in your pom.xml file for a supported SCM type.");
        }
        if (project.getScm().getUrl() != null) {
            if (project.getScm().getUrl().toLowerCase(Locale.getDefault()).indexOf("viewvc") > -1) {
                StatConf.setViewVcURL((String)project.getScm().getUrl());
            } else if (project.getScm().getUrl().toLowerCase(Locale.getDefault()).indexOf("viewcvs") > -1) {
                StatConf.setViewCvsURL((String)"");
            } else if (project.getScm().getUrl().toLowerCase(Locale.getDefault()).indexOf("jcvs") > -1) {
                StatConf.setJCVSWebURL((String)"");
            } else if (project.getScm().getUrl().toLowerCase(Locale.getDefault()).indexOf("chora") > -1) {
                StatConf.setChoraURL((String)"");
            }
        }
        if (project.getIssueManagement() != null && project.getIssueManagement().getSystem() != null) {
            String bugSystem = project.getIssueManagement().getSystem().toLowerCase(Locale.getDefault());
            if ("bugzilla".equals(bugSystem)) {
                StatConf.setBugzillaUrl((String)project.getIssueManagement().getUrl());
            } else if ("mantis".equals(bugSystem)) {
                StatConf.setMantisUrl((String)project.getIssueManagement().getUrl());
            } else if ("trac".equals(bugSystem)) {
                // empty if block
            }
        }
        if (project.getName() != null) {
            StatConf.setProjectName((String)project.getName());
        }
        if (project.getDevelopers() != null) {
            List developers = project.getDevelopers();
            Iterator i = developers.iterator();
            while (i.hasNext()) {
                Developer developer = (Developer)i.next();
                if (developer.getName() != null) {
                    System.setProperty("user." + developer.getId() + ".realName", developer.getName());
                }
                if (developer.getUrl() != null) {
                    System.setProperty("user." + developer.getId() + ".url", developer.getUrl());
                }
                if (developer.getEmail() == null) continue;
                System.setProperty("user." + developer.getId() + ".email", developer.getEmail());
            }
        }
    }

    protected String getConnectionType() {
        return this.connectionType;
    }

    public boolean isStatSVN() {
        return CONNECTION_TYPE_SVN.equals(this.getConnectionType());
    }

    public boolean isStatCVS() {
        return CONNECTION_TYPE_CVS.equals(this.getConnectionType());
    }

    protected static String extractConnectionType(String connectionUrl) {
        if (connectionUrl == null) {
            return null;
        }
        String con = connectionUrl.toLowerCase(Locale.getDefault());
        String[] scmTypes = new String[]{CONNECTION_TYPE_SVN, CONNECTION_TYPE_CVS};
        for (int i = 0; i < scmTypes.length; ++i) {
            if (con.indexOf(scmTypes[i] + ":") <= -1) continue;
            return scmTypes[i];
        }
        return null;
    }

    public static String getLogFileName() {
        return StatConf.getOutputDir() + "scm.log";
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

