/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.xml.converter;

import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLStreamReaderUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XMLStreamReaderUtil.class);

    public static String moveDown(XMLStreamReader xtr) {
        try {
            while (xtr.hasNext()) {
                int event = xtr.next();
                switch (event) {
                    case 8: {
                        return null;
                    }
                    case 1: {
                        return xtr.getLocalName();
                    }
                    case 2: {
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while moving down in XML document", (Throwable)e);
        }
        return null;
    }

    public static boolean moveToEndOfElement(XMLStreamReader xtr, String elementName) {
        try {
            while (xtr.hasNext()) {
                int event = xtr.next();
                switch (event) {
                    case 8: {
                        return false;
                    }
                    case 2: {
                        if (!xtr.getLocalName().equals(elementName)) break;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while moving to end of element {}", (Object)elementName, (Object)e);
        }
        return false;
    }
}

