/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.AbstractVariableQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.QueryVariableValue;
import org.activiti.engine.impl.TaskQueryProperty;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.variable.VariableTypes;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;

public class TaskQueryImpl
extends AbstractVariableQueryImpl<TaskQuery, Task>
implements TaskQuery {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected List<String> nameList;
    protected List<String> nameListIgnoreCase;
    protected String description;
    protected String descriptionLike;
    protected String descriptionLikeIgnoreCase;
    protected Integer priority;
    protected Integer minPriority;
    protected Integer maxPriority;
    protected String assignee;
    protected String assigneeLike;
    protected String assigneeLikeIgnoreCase;
    protected String involvedUser;
    protected String owner;
    protected String ownerLike;
    protected String ownerLikeIgnoreCase;
    protected boolean unassigned = false;
    protected boolean noDelegationState = false;
    protected DelegationState delegationState;
    protected String candidateUser;
    protected String candidateGroup;
    protected List<String> candidateGroups;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String processInstanceId;
    protected String executionId;
    protected Date createTime;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected String category;
    protected String key;
    protected String keyLike;
    protected String processDefinitionKey;
    protected String processDefinitionKeyLike;
    protected String processDefinitionKeyLikeIgnoreCase;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected List<String> processCategoryInList;
    protected List<String> processCategoryNotInList;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected String processInstanceBusinessKey;
    protected String processInstanceBusinessKeyLike;
    protected String processInstanceBusinessKeyLikeIgnoreCase;
    protected Date dueDate;
    protected Date dueBefore;
    protected Date dueAfter;
    protected boolean withoutDueDate = false;
    protected SuspensionState suspensionState;
    protected boolean excludeSubtasks = false;
    protected boolean includeTaskLocalVariables = false;
    protected boolean includeProcessVariables = false;
    protected String userIdForCandidateAndAssignee;
    protected boolean bothCandidateAndAssigned = false;
    protected boolean orActive;
    protected TaskQueryImpl orQueryObject;

    public TaskQueryImpl() {
    }

    public TaskQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public TaskQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public TaskQueryImpl(CommandExecutor commandExecutor, String databaseType) {
        super(commandExecutor);
        this.databaseType = databaseType;
    }

    @Override
    public TaskQueryImpl taskId(String taskId) {
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("Task id is null");
        }
        if (this.orActive) {
            this.orQueryObject.taskId = taskId;
        } else {
            this.taskId = taskId;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskName(String name) {
        if (name == null) {
            throw new ActivitiIllegalArgumentException("Task name is null");
        }
        if (this.orActive) {
            this.orQueryObject.name = name;
        } else {
            this.name = name;
        }
        return this;
    }

    @Override
    public TaskQuery taskNameIn(List<String> nameList) {
        if (nameList == null) {
            throw new ActivitiIllegalArgumentException("Task name list is null");
        }
        if (nameList.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Task name list is empty");
        }
        for (String name : nameList) {
            if (name != null) continue;
            throw new ActivitiIllegalArgumentException("None of the given task names can be null");
        }
        if (this.name != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and name");
        }
        if (this.nameLike != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and nameLike");
        }
        if (this.nameLikeIgnoreCase != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and nameLikeIgnoreCase");
        }
        if (this.orActive) {
            this.orQueryObject.nameList = nameList;
        } else {
            this.nameList = nameList;
        }
        return this;
    }

    @Override
    public TaskQuery taskNameInIgnoreCase(List<String> nameList) {
        if (nameList == null) {
            throw new ActivitiIllegalArgumentException("Task name list is null");
        }
        if (nameList.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Task name list is empty");
        }
        for (String name : nameList) {
            if (name != null) continue;
            throw new ActivitiIllegalArgumentException("None of the given task names can be null");
        }
        if (this.name != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and name");
        }
        if (this.nameLike != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and nameLike");
        }
        if (this.nameLikeIgnoreCase != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and nameLikeIgnoreCase");
        }
        int nameListSize = nameList.size();
        ArrayList<String> caseIgnoredNameList = new ArrayList<String>(nameListSize);
        for (String name : nameList) {
            caseIgnoredNameList.add(name.toLowerCase());
        }
        if (this.orActive) {
            this.orQueryObject.nameListIgnoreCase = caseIgnoredNameList;
        } else {
            this.nameListIgnoreCase = caseIgnoredNameList;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiIllegalArgumentException("Task namelike is null");
        }
        if (this.orActive) {
            this.orQueryObject.nameLike = nameLike;
        } else {
            this.nameLike = nameLike;
        }
        return this;
    }

    @Override
    public TaskQuery taskNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        if (nameLikeIgnoreCase == null) {
            throw new ActivitiIllegalArgumentException("Task nameLikeIgnoreCase is null");
        }
        if (this.orActive) {
            this.orQueryObject.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        } else {
            this.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskDescription(String description) {
        if (description == null) {
            throw new ActivitiIllegalArgumentException("Description is null");
        }
        if (this.orActive) {
            this.orQueryObject.description = description;
        } else {
            this.description = description;
        }
        return this;
    }

    @Override
    public TaskQuery taskDescriptionLike(String descriptionLike) {
        if (descriptionLike == null) {
            throw new ActivitiIllegalArgumentException("Task descriptionlike is null");
        }
        if (this.orActive) {
            this.orQueryObject.descriptionLike = descriptionLike;
        } else {
            this.descriptionLike = descriptionLike;
        }
        return this;
    }

    @Override
    public TaskQuery taskDescriptionLikeIgnoreCase(String descriptionLikeIgnoreCase) {
        if (descriptionLikeIgnoreCase == null) {
            throw new ActivitiIllegalArgumentException("Task descriptionLikeIgnoreCase is null");
        }
        if (this.orActive) {
            this.orQueryObject.descriptionLikeIgnoreCase = descriptionLikeIgnoreCase.toLowerCase();
        } else {
            this.descriptionLikeIgnoreCase = descriptionLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public TaskQuery taskPriority(Integer priority) {
        if (priority == null) {
            throw new ActivitiIllegalArgumentException("Priority is null");
        }
        if (this.orActive) {
            this.orQueryObject.priority = priority;
        } else {
            this.priority = priority;
        }
        return this;
    }

    @Override
    public TaskQuery taskMinPriority(Integer minPriority) {
        if (minPriority == null) {
            throw new ActivitiIllegalArgumentException("Min Priority is null");
        }
        if (this.orActive) {
            this.orQueryObject.minPriority = minPriority;
        } else {
            this.minPriority = minPriority;
        }
        return this;
    }

    @Override
    public TaskQuery taskMaxPriority(Integer maxPriority) {
        if (maxPriority == null) {
            throw new ActivitiIllegalArgumentException("Max Priority is null");
        }
        if (this.orActive) {
            this.orQueryObject.maxPriority = maxPriority;
        } else {
            this.maxPriority = maxPriority;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskAssignee(String assignee) {
        if (assignee == null) {
            throw new ActivitiIllegalArgumentException("Assignee is null");
        }
        if (this.orActive) {
            this.orQueryObject.assignee = assignee;
        } else {
            this.assignee = assignee;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskAssigneeLike(String assigneeLike) {
        if (assigneeLike == null) {
            throw new ActivitiIllegalArgumentException("AssigneeLike is null");
        }
        if (this.orActive) {
            this.orQueryObject.assigneeLike = this.assignee;
        } else {
            this.assigneeLike = assigneeLike;
        }
        return this;
    }

    @Override
    public TaskQuery taskAssigneeLikeIgnoreCase(String assigneeLikeIgnoreCase) {
        if (assigneeLikeIgnoreCase == null) {
            throw new ActivitiIllegalArgumentException("assigneeLikeIgnoreCase is null");
        }
        if (this.orActive) {
            this.orQueryObject.assigneeLikeIgnoreCase = assigneeLikeIgnoreCase.toLowerCase();
        } else {
            this.assigneeLikeIgnoreCase = assigneeLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskOwner(String owner) {
        if (owner == null) {
            throw new ActivitiIllegalArgumentException("Owner is null");
        }
        if (this.orActive) {
            this.orQueryObject.owner = owner;
        } else {
            this.owner = owner;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskOwnerLike(String ownerLike) {
        if (ownerLike == null) {
            throw new ActivitiIllegalArgumentException("Owner is null");
        }
        if (this.orActive) {
            this.orQueryObject.ownerLike = ownerLike;
        } else {
            this.ownerLike = ownerLike;
        }
        return this;
    }

    @Override
    public TaskQuery taskOwnerLikeIgnoreCase(String ownerLikeIgnoreCase) {
        if (ownerLikeIgnoreCase == null) {
            throw new ActivitiIllegalArgumentException("OwnerLikeIgnoreCase");
        }
        if (this.orActive) {
            this.orQueryObject.ownerLikeIgnoreCase = ownerLikeIgnoreCase.toLowerCase();
        } else {
            this.ownerLikeIgnoreCase = ownerLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    @Deprecated
    public TaskQuery taskUnnassigned() {
        return this.taskUnassigned();
    }

    @Override
    public TaskQuery taskUnassigned() {
        if (this.orActive) {
            this.orQueryObject.unassigned = true;
        } else {
            this.unassigned = true;
        }
        return this;
    }

    @Override
    public TaskQuery taskDelegationState(DelegationState delegationState) {
        if (this.orActive) {
            if (delegationState == null) {
                this.orQueryObject.noDelegationState = true;
            } else {
                this.orQueryObject.delegationState = delegationState;
            }
        } else if (delegationState == null) {
            this.noDelegationState = true;
        } else {
            this.delegationState = delegationState;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateUser(String candidateUser) {
        if (candidateUser == null) {
            throw new ActivitiIllegalArgumentException("Candidate user is null");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateUser and candidateGroup");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateUser and candidateGroupIn");
        }
        if (this.orActive) {
            this.orQueryObject.candidateUser = candidateUser;
        } else {
            this.candidateUser = candidateUser;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskInvolvedUser(String involvedUser) {
        if (involvedUser == null) {
            throw new ActivitiIllegalArgumentException("Involved user is null");
        }
        if (this.orActive) {
            this.orQueryObject.involvedUser = involvedUser;
        } else {
            this.involvedUser = involvedUser;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateGroup(String candidateGroup) {
        if (candidateGroup == null) {
            throw new ActivitiIllegalArgumentException("Candidate group is null");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        if (this.orActive) {
            this.orQueryObject.candidateGroup = candidateGroup;
        } else {
            this.candidateGroup = candidateGroup;
        }
        return this;
    }

    @Override
    public TaskQuery taskCandidateOrAssigned(String userIdForCandidateAndAssignee) {
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set candidateGroup");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.orActive) {
            this.orQueryObject.bothCandidateAndAssigned = true;
            this.orQueryObject.userIdForCandidateAndAssignee = userIdForCandidateAndAssignee;
        } else {
            this.bothCandidateAndAssigned = true;
            this.userIdForCandidateAndAssignee = userIdForCandidateAndAssignee;
        }
        return this;
    }

    @Override
    public TaskQuery taskCandidateGroupIn(List<String> candidateGroups) {
        if (candidateGroups == null) {
            throw new ActivitiIllegalArgumentException("Candidate group list is null");
        }
        if (candidateGroups.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Candidate group list is empty");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateUser");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        if (this.orActive) {
            this.orQueryObject.candidateGroups = candidateGroups;
        } else {
            this.candidateGroups = candidateGroups;
        }
        return this;
    }

    @Override
    public TaskQuery taskTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("task tenant id is null");
        }
        if (this.orActive) {
            this.orQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    @Override
    public TaskQuery taskTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("task tenant id is null");
        }
        if (this.orActive) {
            this.orQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    @Override
    public TaskQuery taskWithoutTenantId() {
        if (this.orActive) {
            this.orQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceId(String processInstanceId) {
        if (this.orActive) {
            this.orQueryObject.processInstanceId = processInstanceId;
        } else {
            this.processInstanceId = processInstanceId;
        }
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        if (this.orActive) {
            this.orQueryObject.processInstanceBusinessKey = processInstanceBusinessKey;
        } else {
            this.processInstanceBusinessKey = processInstanceBusinessKey;
        }
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        if (this.orActive) {
            this.orQueryObject.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        } else {
            this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        }
        return this;
    }

    @Override
    public TaskQuery processInstanceBusinessKeyLikeIgnoreCase(String processInstanceBusinessKeyLikeIgnoreCase) {
        if (this.orActive) {
            this.orQueryObject.processInstanceBusinessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase.toLowerCase();
        } else {
            this.processInstanceBusinessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public TaskQueryImpl executionId(String executionId) {
        if (this.orActive) {
            this.orQueryObject.executionId = executionId;
        } else {
            this.executionId = executionId;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskCreatedOn(Date createTime) {
        if (this.orActive) {
            this.orQueryObject.createTime = createTime;
        } else {
            this.createTime = createTime;
        }
        return this;
    }

    @Override
    public TaskQuery taskCreatedBefore(Date before) {
        if (this.orActive) {
            this.orQueryObject.createTimeBefore = before;
        } else {
            this.createTimeBefore = before;
        }
        return this;
    }

    @Override
    public TaskQuery taskCreatedAfter(Date after) {
        if (this.orActive) {
            this.orQueryObject.createTimeAfter = after;
        } else {
            this.createTimeAfter = after;
        }
        return this;
    }

    @Override
    public TaskQuery taskCategory(String category) {
        if (this.orActive) {
            this.orQueryObject.category = category;
        } else {
            this.category = category;
        }
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKey(String key) {
        if (this.orActive) {
            this.orQueryObject.key = key;
        } else {
            this.key = key;
        }
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKeyLike(String keyLike) {
        if (this.orActive) {
            this.orQueryObject.keyLike = keyLike;
        } else {
            this.keyLike = keyLike;
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.orQueryObject.variableValueEquals(variableName, variableValue);
        } else {
            this.variableValueEquals(variableName, variableValue);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueEquals(Object variableValue) {
        if (this.orActive) {
            this.orQueryObject.variableValueEquals(variableValue);
        } else {
            this.variableValueEquals(variableValue);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.orQueryObject.variableValueEqualsIgnoreCase(name, value);
        } else {
            this.variableValueEqualsIgnoreCase(name, value);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.orQueryObject.variableValueNotEqualsIgnoreCase(name, value);
        } else {
            this.variableValueNotEqualsIgnoreCase(name, value);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.orQueryObject.variableValueNotEquals(variableName, variableValue);
        } else {
            this.variableValueNotEquals(variableName, variableValue);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueGreaterThan(String name, Object value) {
        if (this.orActive) {
            this.orQueryObject.variableValueGreaterThan(name, value);
        } else {
            this.variableValueGreaterThan(name, value);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.orQueryObject.variableValueGreaterThanOrEqual(name, value);
        } else {
            this.variableValueGreaterThanOrEqual(name, value);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLessThan(String name, Object value) {
        if (this.orActive) {
            this.orQueryObject.variableValueLessThan(name, value);
        } else {
            this.variableValueLessThan(name, value);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLessThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.orQueryObject.variableValueLessThanOrEqual(name, value);
        } else {
            this.variableValueLessThanOrEqual(name, value);
        }
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLike(String name, String value) {
        if (this.orActive) {
            this.orQueryObject.variableValueLike(name, value);
        } else {
            this.variableValueLike(name, value);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.orQueryObject.variableValueEquals(variableName, variableValue, false);
        } else {
            this.variableValueEquals(variableName, variableValue, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.orQueryObject.variableValueNotEquals(variableName, variableValue, false);
        } else {
            this.variableValueNotEquals(variableName, variableValue, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueEquals(Object variableValue) {
        if (this.orActive) {
            this.orQueryObject.variableValueEquals(variableValue, false);
        } else {
            this.variableValueEquals(variableValue, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.orQueryObject.variableValueEqualsIgnoreCase(name, value, false);
        } else {
            this.variableValueEqualsIgnoreCase(name, value, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.orQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
        } else {
            this.variableValueNotEqualsIgnoreCase(name, value, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueGreaterThan(String name, Object value) {
        if (this.orActive) {
            this.orQueryObject.variableValueGreaterThan(name, value, false);
        } else {
            this.variableValueGreaterThan(name, value, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.orQueryObject.variableValueGreaterThanOrEqual(name, value, false);
        } else {
            this.variableValueGreaterThanOrEqual(name, value, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueLessThan(String name, Object value) {
        if (this.orActive) {
            this.orQueryObject.variableValueLessThan(name, value, false);
        } else {
            this.variableValueLessThan(name, value, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueLessThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.orQueryObject.variableValueLessThanOrEqual(name, value, false);
        } else {
            this.variableValueLessThanOrEqual(name, value, false);
        }
        return this;
    }

    @Override
    public TaskQuery processVariableValueLike(String name, String value) {
        if (this.orActive) {
            this.orQueryObject.variableValueLike(name, value, false);
        } else {
            this.variableValueLike(name, value, false);
        }
        return this;
    }

    @Override
    public TaskQuery processDefinitionKey(String processDefinitionKey) {
        if (this.orActive) {
            this.orQueryObject.processDefinitionKey = processDefinitionKey;
        } else {
            this.processDefinitionKey = processDefinitionKey;
        }
        return this;
    }

    @Override
    public TaskQuery processDefinitionKeyLike(String processDefinitionKeyLike) {
        if (this.orActive) {
            this.orQueryObject.processDefinitionKeyLike = processDefinitionKeyLike;
        } else {
            this.processDefinitionKeyLike = processDefinitionKeyLike;
        }
        return this;
    }

    @Override
    public TaskQuery processDefinitionKeyLikeIgnoreCase(String processDefinitionKeyLikeIgnoreCase) {
        if (this.orActive) {
            this.orQueryObject.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase.toLowerCase();
        } else {
            this.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public TaskQuery processDefinitionId(String processDefinitionId) {
        if (this.orActive) {
            this.orQueryObject.processDefinitionId = processDefinitionId;
        } else {
            this.processDefinitionId = processDefinitionId;
        }
        return this;
    }

    @Override
    public TaskQuery processDefinitionName(String processDefinitionName) {
        if (this.orActive) {
            this.orQueryObject.processDefinitionName = processDefinitionName;
        } else {
            this.processDefinitionName = processDefinitionName;
        }
        return this;
    }

    @Override
    public TaskQuery processDefinitionNameLike(String processDefinitionNameLike) {
        if (this.orActive) {
            this.orQueryObject.processDefinitionNameLike = processDefinitionNameLike;
        } else {
            this.processDefinitionNameLike = processDefinitionNameLike;
        }
        return this;
    }

    @Override
    public TaskQuery processCategoryIn(List<String> processCategoryInList) {
        if (processCategoryInList == null) {
            throw new ActivitiIllegalArgumentException("Process category list is null");
        }
        if (processCategoryInList.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Process category list is empty");
        }
        for (String processCategory : processCategoryInList) {
            if (processCategory != null) continue;
            throw new ActivitiIllegalArgumentException("None of the given process categories can be null");
        }
        if (this.orActive) {
            this.orQueryObject.processCategoryInList = processCategoryInList;
        } else {
            this.processCategoryInList = processCategoryInList;
        }
        return this;
    }

    @Override
    public TaskQuery processCategoryNotIn(List<String> processCategoryNotInList) {
        if (processCategoryNotInList == null) {
            throw new ActivitiIllegalArgumentException("Process category list is null");
        }
        if (processCategoryNotInList.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Process category list is empty");
        }
        for (String processCategory : processCategoryNotInList) {
            if (processCategory != null) continue;
            throw new ActivitiIllegalArgumentException("None of the given process categories can be null");
        }
        if (this.orActive) {
            this.orQueryObject.processCategoryNotInList = processCategoryNotInList;
        } else {
            this.processCategoryNotInList = processCategoryNotInList;
        }
        return this;
    }

    @Override
    public TaskQuery deploymentId(String deploymentId) {
        if (this.orActive) {
            this.orQueryObject.deploymentId = deploymentId;
        } else {
            this.deploymentId = deploymentId;
        }
        return this;
    }

    @Override
    public TaskQuery deploymentIdIn(List<String> deploymentIds) {
        if (this.orActive) {
            this.orQueryObject.deploymentIds = deploymentIds;
        } else {
            this.deploymentIds = deploymentIds;
        }
        return this;
    }

    @Override
    public TaskQuery dueDate(Date dueDate) {
        if (this.orActive) {
            this.orQueryObject.dueDate = dueDate;
            this.orQueryObject.withoutDueDate = false;
        } else {
            this.dueDate = dueDate;
            this.withoutDueDate = false;
        }
        return this;
    }

    @Override
    public TaskQuery taskDueDate(Date dueDate) {
        return this.dueDate(dueDate);
    }

    @Override
    public TaskQuery dueBefore(Date dueBefore) {
        if (this.orActive) {
            this.orQueryObject.dueBefore = dueBefore;
            this.orQueryObject.withoutDueDate = false;
        } else {
            this.dueBefore = dueBefore;
            this.withoutDueDate = false;
        }
        return this;
    }

    @Override
    public TaskQuery taskDueBefore(Date dueDate) {
        return this.dueBefore(dueDate);
    }

    @Override
    public TaskQuery dueAfter(Date dueAfter) {
        if (this.orActive) {
            this.orQueryObject.dueAfter = dueAfter;
            this.orQueryObject.withoutDueDate = false;
        } else {
            this.dueAfter = dueAfter;
            this.withoutDueDate = false;
        }
        return this;
    }

    @Override
    public TaskQuery taskDueAfter(Date dueDate) {
        return this.dueAfter(dueDate);
    }

    @Override
    public TaskQuery withoutDueDate() {
        if (this.orActive) {
            this.orQueryObject.withoutDueDate = true;
        } else {
            this.withoutDueDate = true;
        }
        return this;
    }

    @Override
    public TaskQuery withoutTaskDueDate() {
        return this.withoutDueDate();
    }

    @Override
    public TaskQuery excludeSubtasks() {
        if (this.orActive) {
            this.orQueryObject.excludeSubtasks = true;
        } else {
            this.excludeSubtasks = true;
        }
        return this;
    }

    @Override
    public TaskQuery suspended() {
        if (this.orActive) {
            this.orQueryObject.suspensionState = SuspensionState.SUSPENDED;
        } else {
            this.suspensionState = SuspensionState.SUSPENDED;
        }
        return this;
    }

    @Override
    public TaskQuery active() {
        if (this.orActive) {
            this.orQueryObject.suspensionState = SuspensionState.ACTIVE;
        } else {
            this.suspensionState = SuspensionState.ACTIVE;
        }
        return this;
    }

    @Override
    public TaskQuery includeTaskLocalVariables() {
        this.includeTaskLocalVariables = true;
        return this;
    }

    @Override
    public TaskQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    public List<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            ArrayList<String> candidateGroupList = new ArrayList<String>(1);
            candidateGroupList.add(this.candidateGroup);
            return candidateGroupList;
        }
        if (this.candidateUser != null) {
            return this.getGroupsForCandidateUser(this.candidateUser);
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        return null;
    }

    protected List<String> getGroupsForCandidateUser(String candidateUser) {
        List<Group> groups = Context.getCommandContext().getGroupIdentityManager().findGroupsByUser(candidateUser);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    @Override
    protected void ensureVariablesInitialized() {
        VariableTypes types = Context.getProcessEngineConfiguration().getVariableTypes();
        for (QueryVariableValue var : this.queryVariableValues) {
            var.initialize(types);
        }
        if (this.orQueryObject != null) {
            this.orQueryObject.ensureVariablesInitialized();
        }
    }

    @Override
    public TaskQuery or() {
        if (this.orActive || this.orQueryObject != null) {
            throw new ActivitiException("or() can only be called once");
        }
        this.orActive = true;
        this.orQueryObject = new TaskQueryImpl();
        return this;
    }

    @Override
    public TaskQuery endOr() {
        if (!this.orActive || this.orQueryObject == null) {
            throw new ActivitiException("endOr() can only be called after calling or()");
        }
        this.orActive = false;
        return this;
    }

    @Override
    public TaskQuery orderByTaskId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TASK_ID);
    }

    @Override
    public TaskQuery orderByTaskName() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.NAME);
    }

    @Override
    public TaskQuery orderByTaskDescription() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DESCRIPTION);
    }

    @Override
    public TaskQuery orderByTaskPriority() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PRIORITY);
    }

    @Override
    public TaskQuery orderByProcessInstanceId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public TaskQuery orderByExecutionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.EXECUTION_ID);
    }

    @Override
    public TaskQuery orderByProcessDefinitionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public TaskQuery orderByTaskAssignee() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.ASSIGNEE);
    }

    @Override
    public TaskQuery orderByTaskOwner() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.OWNER);
    }

    @Override
    public TaskQuery orderByTaskCreateTime() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CREATE_TIME);
    }

    @Override
    public TaskQuery orderByDueDate() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE);
    }

    @Override
    public TaskQuery orderByTaskDueDate() {
        return this.orderByDueDate();
    }

    @Override
    public TaskQuery orderByTaskDefinitionKey() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TASK_DEFINITION_KEY);
    }

    @Override
    public TaskQuery orderByDueDateNullsFirst() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE, AbstractQuery.NullHandlingOnOrder.NULLS_FIRST);
    }

    @Override
    public TaskQuery orderByDueDateNullsLast() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE, AbstractQuery.NullHandlingOnOrder.NULLS_LAST);
    }

    @Override
    public TaskQuery orderByTenantId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TENANT_ID);
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderBy();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
        }
        return specialOrderBy;
    }

    @Override
    public List<Task> executeList(CommandContext commandContext, Page page) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        if (this.includeTaskLocalVariables || this.includeProcessVariables) {
            return commandContext.getTaskEntityManager().findTasksAndVariablesByQueryCriteria(this);
        }
        return commandContext.getTaskEntityManager().findTasksByQueryCriteria(this);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getTaskEntityManager().findTaskCountByQueryCriteria(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public List<String> getNameListIgnoreCase() {
        return this.nameListIgnoreCase;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public boolean getUnassigned() {
        return this.unassigned;
    }

    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    public boolean getNoDelegationState() {
        return this.noDelegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getCreateTimeBefore() {
        return this.createTimeBefore;
    }

    public Date getCreateTimeAfter() {
        return this.createTimeAfter;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public boolean getExcludeSubtasks() {
        return this.excludeSubtasks;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getUserIdForCandidateAndAssignee() {
        return this.userIdForCandidateAndAssignee;
    }

    public TaskQueryImpl getOrQueryObject() {
        return this.orQueryObject;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public Integer getMinPriority() {
        return this.minPriority;
    }

    public Integer getMaxPriority() {
        return this.maxPriority;
    }

    public String getAssigneeLike() {
        return this.assigneeLike;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerLike() {
        return this.ownerLike;
    }

    public String getCategory() {
        return this.category;
    }

    public String getProcessDefinitionKeyLike() {
        return this.processDefinitionKeyLike;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public List<String> getProcessCategoryInList() {
        return this.processCategoryInList;
    }

    public List<String> getProcessCategoryNotInList() {
        return this.processCategoryNotInList;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public List<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getDueBefore() {
        return this.dueBefore;
    }

    public Date getDueAfter() {
        return this.dueAfter;
    }

    public boolean isWithoutDueDate() {
        return this.withoutDueDate;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public boolean isIncludeTaskLocalVariables() {
        return this.includeTaskLocalVariables;
    }

    public boolean isIncludeProcessVariables() {
        return this.includeProcessVariables;
    }

    public boolean isBothCandidateAndAssigned() {
        return this.bothCandidateAndAssigned;
    }

    public String getNameLikeIgnoreCase() {
        return this.nameLikeIgnoreCase;
    }

    public String getDescriptionLikeIgnoreCase() {
        return this.descriptionLikeIgnoreCase;
    }

    public String getAssigneeLikeIgnoreCase() {
        return this.assigneeLikeIgnoreCase;
    }

    public String getOwnerLikeIgnoreCase() {
        return this.ownerLikeIgnoreCase;
    }

    public String getProcessInstanceBusinessKeyLikeIgnoreCase() {
        return this.processInstanceBusinessKeyLikeIgnoreCase;
    }

    public String getProcessDefinitionKeyLikeIgnoreCase() {
        return this.processDefinitionKeyLikeIgnoreCase;
    }

    public boolean isOrActive() {
        return this.orActive;
    }
}

