/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionListener;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.variable.EntityManagerSession;

public class EntityManagerSessionImpl
implements EntityManagerSession {
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private boolean handleTransactions;
    private boolean closeEntityManager;

    public EntityManagerSessionImpl(EntityManagerFactory entityManagerFactory, EntityManager entityManager, boolean handleTransactions, boolean closeEntityManager) {
        this(entityManagerFactory, handleTransactions, closeEntityManager);
        this.entityManager = entityManager;
    }

    public EntityManagerSessionImpl(EntityManagerFactory entityManagerFactory, boolean handleTransactions, boolean closeEntityManager) {
        this.entityManagerFactory = entityManagerFactory;
        this.handleTransactions = handleTransactions;
        this.closeEntityManager = closeEntityManager;
    }

    @Override
    public void flush() {
        if (this.entityManager != null && (!this.handleTransactions || this.isTransactionActive())) {
            try {
                this.entityManager.flush();
            }
            catch (IllegalStateException ise) {
                throw new ActivitiException("Error while flushing EntityManager, illegal state", ise);
            }
            catch (TransactionRequiredException tre) {
                throw new ActivitiException("Cannot flush EntityManager, an active transaction is required", tre);
            }
            catch (PersistenceException pe) {
                throw new ActivitiException("Error while flushing EntityManager: " + pe.getMessage(), pe);
            }
        }
    }

    protected boolean isTransactionActive() {
        if (this.handleTransactions && this.entityManager.getTransaction() != null) {
            return this.entityManager.getTransaction().isActive();
        }
        return false;
    }

    @Override
    public void close() {
        if (this.closeEntityManager && this.entityManager != null && !this.entityManager.isOpen()) {
            try {
                this.entityManager.close();
            }
            catch (IllegalStateException ise) {
                throw new ActivitiException("Error while closing EntityManager, may have already been closed or it is container-managed", ise);
            }
        }
    }

    @Override
    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = this.getEntityManagerFactory().createEntityManager();
            if (this.handleTransactions) {
                TransactionListener jpaTransactionCommitListener = new TransactionListener(){

                    @Override
                    public void execute(CommandContext commandContext) {
                        if (EntityManagerSessionImpl.this.isTransactionActive()) {
                            EntityManagerSessionImpl.this.entityManager.getTransaction().commit();
                        }
                    }
                };
                TransactionListener jpaTransactionRollbackListener = new TransactionListener(){

                    @Override
                    public void execute(CommandContext commandContext) {
                        if (EntityManagerSessionImpl.this.isTransactionActive()) {
                            EntityManagerSessionImpl.this.entityManager.getTransaction().rollback();
                        }
                    }
                };
                TransactionContext transactionContext = Context.getTransactionContext();
                transactionContext.addTransactionListener(TransactionState.COMMITTED, jpaTransactionCommitListener);
                transactionContext.addTransactionListener(TransactionState.ROLLED_BACK, jpaTransactionRollbackListener);
                if (!this.isTransactionActive()) {
                    this.entityManager.getTransaction().begin();
                }
            }
        }
        return this.entityManager;
    }

    private EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }
}

