/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.engine.variable;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.engine.variable.RestVariableConverter;

public class ShortRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "short";
    }

    @Override
    public Class<?> getVariableType() {
        return Short.class;
    }

    @Override
    public Object getVariableValue(RestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Number)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert shorts");
            }
            return ((Number)result.getValue()).shortValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, RestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Short)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert shorts");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

