/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversionFactory;
import org.activiti.workflow.simple.converter.json.SimpleWorkflowJsonConverter;
import org.activiti.workflow.simple.definition.WorkflowDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SimpleWorkflowResource {
    @Autowired
    protected RepositoryService repositoryService;

    @RequestMapping(value={"/simple-workflow"}, method={RequestMethod.POST}, produces={"application/json"})
    public SimpleWorkflowSuccessResponse createWorkflow(@RequestBody String json) {
        SimpleWorkflowJsonConverter jsonConverter = new SimpleWorkflowJsonConverter();
        WorkflowDefinition workflowDefinition = jsonConverter.readWorkflowDefinition(json.getBytes());
        WorkflowDefinitionConversionFactory conversionFactory = new WorkflowDefinitionConversionFactory();
        WorkflowDefinitionConversion conversion = conversionFactory.createWorkflowDefinitionConversion(workflowDefinition);
        conversion.convert();
        BpmnModel bpmnModel = conversion.getBpmnModel();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel(((Process)bpmnModel.getProcesses().get(0)).getName() + ".bpmn20.xml", bpmnModel).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return new SimpleWorkflowSuccessResponse(processDefinition.getId());
    }

    static class SimpleWorkflowSuccessResponse {
        protected String processDefinitionId;

        public SimpleWorkflowSuccessResponse(String processDefinitionid) {
            this.processDefinitionId = processDefinitionid;
        }

        public String getProcessDefinitionId() {
            return this.processDefinitionId;
        }

        public void setProcessDefinitionId(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }
    }
}

