/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineInfo;
import org.activiti.engine.ProcessEngines;
import org.activiti.rest.service.api.management.ProcessEngineInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Engine"}, description="Manage Engine", authorizations={@Authorization(value="basicAuth")})
public class ProcessEngineResource {
    @Autowired
    @Qualifier(value="processEngine")
    protected ProcessEngine engine;

    @ApiOperation(value="Get engine info", tags={"Engine"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the engine info is returned.")})
    @RequestMapping(value={"/management/engine"}, method={RequestMethod.GET}, produces={"application/json"})
    public ProcessEngineInfoResponse getEngineInfo() {
        ProcessEngineInfoResponse response = new ProcessEngineInfoResponse();
        try {
            ProcessEngineInfo engineInfo = ProcessEngines.getProcessEngineInfo((String)this.engine.getName());
            if (engineInfo != null) {
                response.setName(engineInfo.getName());
                response.setResourceUrl(engineInfo.getResourceUrl());
                response.setException(engineInfo.getException());
            } else {
                response.setName(this.engine.getName());
            }
        }
        catch (Exception e) {
            throw new ActivitiException("Error retrieving process info", (Throwable)e);
        }
        response.setVersion("6.0.0.4");
        return response;
    }
}

