/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import java.util.List;
import java.util.Map;
import org.activiti.engine.FormService;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.impl.form.EnumFormType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionPropertiesResource {
    @Autowired
    protected FormService formService;
    @Autowired
    protected ObjectMapper objectMapper;

    @RequestMapping(value={"/process-definition/{processDefinitionId}/properties"}, method={RequestMethod.GET}, produces={"application/json"})
    public ObjectNode getStartFormProperties(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId) {
        StartFormData startFormData = this.formService.getStartFormData(processDefinitionId);
        ObjectNode responseJSON = this.objectMapper.createObjectNode();
        ArrayNode propertiesJSON = this.objectMapper.createArrayNode();
        if (startFormData != null) {
            List properties = startFormData.getFormProperties();
            for (FormProperty property : properties) {
                ObjectNode propertyJSON = this.objectMapper.createObjectNode();
                propertyJSON.put("id", property.getId());
                propertyJSON.put("name", property.getName());
                if (property.getValue() != null) {
                    propertyJSON.put("value", property.getValue());
                } else {
                    propertyJSON.putNull("value");
                }
                if (property.getType() != null) {
                    Map valuesMap;
                    propertyJSON.put("type", property.getType().getName());
                    if (property.getType() instanceof EnumFormType && (valuesMap = (Map)property.getType().getInformation("values")) != null) {
                        ArrayNode valuesArray = this.objectMapper.createArrayNode();
                        propertyJSON.put("enumValues", (JsonNode)valuesArray);
                        for (String key : valuesMap.keySet()) {
                            ObjectNode valueJSON = this.objectMapper.createObjectNode();
                            valueJSON.put("id", key);
                            valueJSON.put("name", (String)valuesMap.get(key));
                            valuesArray.add((JsonNode)valueJSON);
                        }
                    }
                } else {
                    propertyJSON.put("type", "String");
                }
                propertyJSON.put("required", property.isRequired());
                propertyJSON.put("readable", property.isReadable());
                propertyJSON.put("writable", property.isWritable());
                propertiesJSON.add((JsonNode)propertyJSON);
            }
        }
        responseJSON.put("data", (JsonNode)propertiesJSON);
        return responseJSON;
    }
}

