/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class CountersManager
extends CountersReader {
    public static final int DEFAULT_TYPE_ID = 0;
    public static final Consumer<MutableDirectBuffer> DEFAULT_KEY_FUNC = ignore -> {};
    private int idHighWaterMark = -1;
    private final Deque<Integer> freeList = new LinkedList<Integer>();

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer) {
        super(metaDataBuffer, valuesBuffer);
        valuesBuffer.verifyAlignment();
        if (metaDataBuffer.capacity() < valuesBuffer.capacity() * 2) {
            throw new IllegalArgumentException("Meta data buffer not sufficiently large");
        }
    }

    public int allocate(String label) {
        return this.allocate(label, 0, DEFAULT_KEY_FUNC);
    }

    public int allocate(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        int counterId = this.nextCounterId();
        if (CountersManager.counterOffset(counterId) + 128 > this.valuesBuffer.capacity()) {
            throw new IllegalArgumentException("Unable to allocated counter, values buffer is full");
        }
        int recordOffset = CountersManager.metaDataOffset(counterId);
        if (recordOffset + 256 > this.metaDataBuffer.capacity()) {
            throw new IllegalArgumentException("Unable to allocate counter, labels buffer is full");
        }
        this.metaDataBuffer.putInt(recordOffset + 4, typeId);
        keyFunc.accept(new UnsafeBuffer(this.metaDataBuffer, recordOffset + 8, 120));
        this.metaDataBuffer.putStringUtf8(recordOffset + 128, label, 124);
        this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        return counterId;
    }

    public AtomicCounter newCounter(String label) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label), this);
    }

    public AtomicCounter newCounter(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label, typeId, keyFunc), this);
    }

    public void free(int counterId) {
        this.metaDataBuffer.putIntOrdered(CountersManager.metaDataOffset(counterId), -1);
        this.freeList.add(counterId);
    }

    public void setCounterValue(int counterId, long value) {
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(counterId), value);
    }

    private int nextCounterId() {
        if (this.freeList.isEmpty()) {
            return ++this.idHighWaterMark;
        }
        int counterId = this.freeList.remove();
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(counterId), 0L);
        return counterId;
    }
}

