/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessageListener;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.message.LargeBodyEncoder;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public final class LargeServerMessageImpl
extends CoreMessage
implements LargeServerMessage {
    private static final Logger logger = Logger.getLogger(LargeServerMessageImpl.class);
    private final JournalStorageManager storageManager;
    private long pendingRecordID = -1L;
    private boolean paged;
    private SequentialFile file;
    private long bodySize = -1L;
    private final AtomicInteger delayDeletionCount = new AtomicInteger(0);
    private volatile int memoryEstimate = -1;

    public static Message checkLargeMessage(Message message, StorageManager storageManager) throws Exception {
        if (message.isLargeMessage()) {
            return message;
        }
        if ((long)message.getEncodeSize() > storageManager.getMaxRecordSize()) {
            return LargeServerMessageImpl.asLargeMessage(message, storageManager);
        }
        return message;
    }

    private static Message asLargeMessage(Message message, StorageManager storageManager) throws Exception {
        ICoreMessage coreMessage = message.toCore();
        LargeServerMessage lsm = storageManager.createLargeMessage(storageManager.generateID(), (Message)coreMessage);
        ActiveMQBuffer buffer = coreMessage.getReadOnlyBodyBuffer();
        int readableBytes = buffer.readableBytes();
        lsm.addBytes(buffer);
        lsm.releaseResources();
        lsm.putLongProperty(Message.HDR_LARGE_BODY_SIZE, readableBytes);
        return lsm;
    }

    public LargeServerMessageImpl(JournalStorageManager storageManager) {
        this.storageManager = storageManager;
    }

    private LargeServerMessageImpl(LargeServerMessageImpl copy, TypedProperties properties, SequentialFile fileCopy, long newID) {
        super((CoreMessage)copy, properties);
        this.storageManager = copy.storageManager;
        this.file = fileCopy;
        this.bodySize = copy.bodySize;
        this.setMessageID(newID);
    }

    private static String toDate(long timestamp) {
        if (timestamp == 0L) {
            return "0";
        }
        return new Date(timestamp).toString();
    }

    public boolean isServerMessage() {
        return true;
    }

    @Override
    public long getPendingRecordID() {
        return this.pendingRecordID;
    }

    @Override
    public void setPendingRecordID(long pendingRecordID) {
        this.pendingRecordID = pendingRecordID;
    }

    @Override
    public void setPaged() {
        this.paged = true;
    }

    @Override
    public synchronized void addBytes(byte[] bytes) throws Exception {
        this.validateFile();
        if (!this.file.isOpen()) {
            this.file.open();
        }
        this.storageManager.addBytesToLargeMessage(this.file, this.getMessageID(), bytes);
        this.bodySize += (long)bytes.length;
    }

    @Override
    public synchronized void addBytes(ActiveMQBuffer bytes) throws Exception {
        this.validateFile();
        if (!this.file.isOpen()) {
            this.file.open();
        }
        int readableBytes = bytes.readableBytes();
        this.storageManager.addBytesToLargeMessage(this.file, this.getMessageID(), bytes);
        this.bodySize += (long)readableBytes;
    }

    public synchronized int getEncodeSize() {
        return this.getHeadersAndPropertiesEncodeSize();
    }

    public void encode(ActiveMQBuffer buffer1) {
        super.encodeHeadersAndProperties(buffer1.byteBuf());
    }

    public void decode(ActiveMQBuffer buffer1) {
        this.file = null;
        super.decodeHeadersAndProperties(buffer1.byteBuf());
    }

    @Override
    public synchronized void incrementDelayDeletionCount() {
        this.delayDeletionCount.incrementAndGet();
        try {
            if (this.paged) {
                RefCountMessageListener tmpContext = super.getContext();
                this.setContext(null);
                this.incrementRefCount();
                this.setContext(tmpContext);
            } else {
                this.incrementRefCount();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorIncrementDelayDeletionCount(e);
        }
    }

    @Override
    public synchronized void decrementDelayDeletionCount() throws Exception {
        int count = this.delayDeletionCount.decrementAndGet();
        this.decrementRefCount();
        if (count == 0) {
            this.checkDelete();
        }
    }

    public LargeBodyEncoder getBodyEncoder() throws ActiveMQException {
        this.validateFile();
        return new DecodingContext();
    }

    private void checkDelete() throws Exception {
        if (this.getRefCount() <= 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Deleting file " + this.file + " as the usage was complete"));
            }
            try {
                this.deleteFile();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    public synchronized int decrementRefCount() throws Exception {
        int currentRefCount;
        if (this.paged) {
            RefCountMessageListener tmpContext = super.getContext();
            this.setContext(null);
            currentRefCount = super.decrementRefCount();
            this.setContext(tmpContext);
        } else {
            currentRefCount = super.decrementRefCount();
        }
        if (this.delayDeletionCount.get() <= 0) {
            this.checkDelete();
        }
        return currentRefCount;
    }

    public ActiveMQBuffer getReadOnlyBodyBuffer() {
        try {
            this.validateFile();
            this.file.open();
            int fileSize = (int)this.file.size();
            ByteBuffer buffer = ByteBuffer.allocate(fileSize);
            this.file.read(buffer);
            ChannelBufferWrapper channelBufferWrapper = new ChannelBufferWrapper(Unpooled.wrappedBuffer((ByteBuffer)buffer));
            return channelBufferWrapper;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
    }

    public int getBodyBufferSize() {
        boolean closeFile = this.file == null || !this.file.isOpen();
        try {
            this.openFile();
            long fileSize = this.file.size();
            int fileSizeAsInt = (int)fileSize;
            if (fileSizeAsInt < 0) {
                logger.warnf("suspicious large message file size of %d bytes for %s, will use %d instead.", (Object)fileSize, (Object)this.file.getFileName(), (Object)Integer.MAX_VALUE);
                fileSizeAsInt = Integer.MAX_VALUE;
            }
            int n = fileSizeAsInt;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (closeFile) {
                try {
                    this.file.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isLargeMessage() {
        return true;
    }

    @Override
    public synchronized void deleteFile() throws Exception {
        this.validateFile();
        this.releaseResources();
        this.storageManager.deleteLargeMessageFile(this);
    }

    public synchronized int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = this.getHeadersAndPropertiesEncodeSize() + 4 + this.getEncodeSize() + 40 + 1;
        }
        return this.memoryEstimate;
    }

    @Override
    public synchronized void releaseResources() {
        if (this.file != null && this.file.isOpen()) {
            try {
                this.file.close();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.largeMessageErrorReleasingResources(e);
            }
        }
    }

    public void referenceOriginalMessage(Message original, String originalQueue) {
        super.referenceOriginalMessage(original, originalQueue);
        if (original instanceof LargeServerMessageImpl) {
            LargeServerMessageImpl otherLM = (LargeServerMessageImpl)original;
            this.paged = otherLM.paged;
            if (this.paged) {
                this.removeAnnotation(Message.HDR_ORIG_MESSAGE_ID);
            }
        }
    }

    public Message copy() {
        SequentialFile newfile = this.storageManager.createFileForLargeMessage(this.messageID, this.durable);
        LargeServerMessageImpl newMessage = new LargeServerMessageImpl(this, this.properties, newfile, this.messageID);
        return newMessage;
    }

    public Message copy(long newID) {
        try {
            int bytesRead;
            LargeServerMessage newMessage = this.storageManager.createLargeMessage(newID, (Message)this);
            boolean originallyOpen = this.file != null && this.file.isOpen();
            this.validateFile();
            byte[] bufferBytes = new byte[102400];
            ByteBuffer buffer = ByteBuffer.wrap(bufferBytes);
            long oldPosition = this.file.position();
            this.file.open();
            this.file.position(0L);
            do {
                byte[] bufferToWrite;
                buffer.clear();
                bytesRead = this.file.read(buffer);
                if (bytesRead <= 0) break;
                if (bytesRead == bufferBytes.length && !this.storageManager.isReplicated()) {
                    bufferToWrite = bufferBytes;
                } else {
                    bufferToWrite = new byte[bytesRead];
                    System.arraycopy(bufferBytes, 0, bufferToWrite, 0, bytesRead);
                }
                newMessage.addBytes(bufferToWrite);
            } while (bytesRead >= bufferBytes.length);
            this.file.position(oldPosition);
            if (!originallyOpen) {
                this.file.close();
                newMessage.getFile().close();
            }
            return newMessage;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.lareMessageErrorCopying(e, this);
            return null;
        }
    }

    @Override
    public SequentialFile getFile() throws ActiveMQException {
        this.validateFile();
        return this.file;
    }

    private long getBodySize() throws ActiveMQException {
        try {
            if (this.bodySize < 0L) {
                if (this.file != null) {
                    this.bodySize = this.file.size();
                } else {
                    SequentialFile tmpFile = this.createFile();
                    this.bodySize = tmpFile.size();
                    tmpFile.close();
                }
            }
            return this.bodySize;
        }
        catch (Exception e) {
            ActiveMQIOErrorException errorException = new ActiveMQIOErrorException();
            errorException.initCause((Throwable)e);
            throw errorException;
        }
    }

    public long getPersistentSize() throws ActiveMQException {
        long size = super.getPersistentSize();
        return size += this.getBodySize();
    }

    public String toString() {
        try {
            return "LargeServerMessage[messageID=" + this.messageID + ",durable=" + this.isDurable() + ",userID=" + this.getUserID() + ",priority=" + this.getPriority() + ", timestamp=" + LargeServerMessageImpl.toDate(this.getTimestamp()) + ",expiration=" + LargeServerMessageImpl.toDate(this.getExpiration()) + ", durable=" + this.durable + ", address=" + this.getAddress() + ", properties=" + (this.properties != null ? this.properties.toString() : "") + "]@" + System.identityHashCode(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "LargeServerMessage[messageID=" + this.messageID + "]";
        }
    }

    public synchronized void validateFile() throws ActiveMQException {
        try {
            if (this.file == null) {
                if (this.messageID <= 0L) {
                    throw new RuntimeException("MessageID not set on LargeMessage");
                }
                this.file = this.createFile();
                this.openFile();
                this.bodySize = this.file.size();
            }
        }
        catch (Exception e) {
            throw new ActiveMQInternalErrorException(e.getMessage(), e);
        }
    }

    protected SequentialFile createFile() {
        return this.storageManager.createFileForLargeMessage(this.getMessageID(), this.durable);
    }

    protected void openFile() throws Exception {
        if (this.file == null) {
            this.validateFile();
        } else if (!this.file.isOpen()) {
            this.file.open();
        }
    }

    protected void closeFile() throws Exception {
        if (this.file != null && this.file.isOpen()) {
            this.file.close();
        }
    }

    class DecodingContext
    implements LargeBodyEncoder {
        private SequentialFile cFile;

        DecodingContext() {
        }

        public void open() throws ActiveMQException {
            try {
                if (this.cFile != null && this.cFile.isOpen()) {
                    this.cFile.close();
                }
                this.cFile = LargeServerMessageImpl.this.file.cloneFile();
                this.cFile.open();
            }
            catch (Exception e) {
                throw new ActiveMQException(ActiveMQExceptionType.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
            }
        }

        public void close() throws ActiveMQException {
            try {
                if (this.cFile != null) {
                    this.cFile.close();
                }
            }
            catch (Exception e) {
                throw new ActiveMQInternalErrorException(e.getMessage(), e);
            }
        }

        public int encode(ByteBuffer bufferRead) throws ActiveMQException {
            try {
                return this.cFile.read(bufferRead);
            }
            catch (Exception e) {
                throw new ActiveMQInternalErrorException(e.getMessage(), e);
            }
        }

        public long getLargeBodySize() throws ActiveMQException {
            return LargeServerMessageImpl.this.getBodySize();
        }
    }
}

