/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ScaleDownAnnounceMessage;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVoteHandler;
import org.apache.activemq.artemis.core.server.cluster.qourum.Vote;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.jboss.logging.Logger;

public class ClusterController
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(ClusterController.class);
    private final QuorumManager quorumManager;
    private final ActiveMQServer server;
    private final Map<SimpleString, ServerLocatorInternal> locators = new HashMap<SimpleString, ServerLocatorInternal>();
    private SimpleString defaultClusterConnectionName;
    private ServerLocator defaultLocator;
    private ServerLocator replicationLocator;
    private final Executor executor;
    private CountDownLatch replicationClusterConnectedLatch;
    private boolean started;
    private SimpleString replicatedClusterName;

    public ClusterController(ActiveMQServer server, ScheduledExecutorService scheduledExecutor) {
        this.server = server;
        this.executor = server.getExecutorFactory().getExecutor();
        this.quorumManager = new QuorumManager(scheduledExecutor, this);
    }

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.defaultLocator = (ServerLocator)this.locators.get(this.defaultClusterConnectionName);
        if (this.replicatedClusterName != null && !this.replicatedClusterName.equals((Object)this.defaultClusterConnectionName)) {
            this.replicationLocator = (ServerLocator)this.locators.get(this.replicatedClusterName);
            if (this.replicationLocator == null) {
                ActiveMQServerLogger.LOGGER.noClusterConnectionForReplicationCluster();
                this.replicationLocator = this.defaultLocator;
            }
        } else {
            this.replicationLocator = this.defaultLocator;
        }
        this.replicationClusterConnectedLatch = new CountDownLatch(1);
        if (this.defaultLocator != null) {
            this.defaultLocator.addClusterTopologyListener((ClusterTopologyListener)this.quorumManager);
        }
        if (this.quorumManager != null) {
            this.quorumManager.start();
        }
        this.started = true;
        for (ServerLocatorInternal serverLocatorInternal : this.locators.values()) {
            if (!serverLocatorInternal.isConnectable()) continue;
            this.executor.execute(new ConnectRunnable(serverLocatorInternal));
        }
    }

    public void stop() throws Exception {
        for (ServerLocatorInternal serverLocatorInternal : this.locators.values()) {
            serverLocatorInternal.close();
        }
        this.quorumManager.stop();
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public QuorumManager getQuorumManager() {
        return this.quorumManager;
    }

    public void setDefaultClusterConnectionName(SimpleString defaultClusterConnection) {
        this.defaultClusterConnectionName = defaultClusterConnection;
    }

    public void addClusterConnection(SimpleString name, DiscoveryGroupConfiguration dg, ClusterConnectionConfiguration config) {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        this.configAndAdd(name, (ServerLocatorInternal)serverLocator, config);
    }

    public void addClusterConnection(SimpleString name, TransportConfiguration[] tcConfigs, ClusterConnectionConfiguration config) {
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs);
        this.configAndAdd(name, (ServerLocatorInternal)serverLocator, config);
    }

    private void configAndAdd(SimpleString name, ServerLocatorInternal serverLocator, ClusterConnectionConfiguration config) {
        serverLocator.setConnectionTTL(config.getConnectionTTL());
        serverLocator.setClientFailureCheckPeriod(config.getClientFailureCheckPeriod());
        serverLocator.setReconnectAttempts(config.getReconnectAttempts());
        serverLocator.setInitialConnectAttempts(config.getInitialConnectAttempts());
        serverLocator.setRetryInterval(config.getRetryInterval());
        serverLocator.setRetryIntervalMultiplier(config.getRetryIntervalMultiplier());
        serverLocator.setMaxRetryInterval(config.getMaxRetryInterval());
        serverLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)serverLocator));
        serverLocator.setThreadPools(this.server.getThreadPool(), this.server.getScheduledPool());
        try {
            serverLocator.initialize();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.locators.put(name, serverLocator);
    }

    public void addClusterTopologyListenerForReplication(ClusterTopologyListener listener) {
        if (this.replicationLocator != null) {
            this.replicationLocator.addClusterTopologyListener(listener);
        }
    }

    public void addIncomingInterceptorForReplication(Interceptor interceptor) {
        this.replicationLocator.addIncomingInterceptor(interceptor);
    }

    public ClusterControl connectToNode(TransportConfiguration transportConfiguration) throws Exception {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)this.defaultLocator.createSessionFactory(transportConfiguration, 0, false);
        return this.connectToNodeInCluster(sessionFactory);
    }

    public ClusterControl connectToNodeInReplicatedCluster(TransportConfiguration transportConfiguration) throws Exception {
        ClientSessionFactoryInternal sessionFactory = (ClientSessionFactoryInternal)this.replicationLocator.createSessionFactory(transportConfiguration, 0, false);
        return this.connectToNodeInCluster(sessionFactory);
    }

    public ClusterControl connectToNodeInCluster(ClientSessionFactoryInternal sf) {
        sf.getServerLocator().setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance(sf.getServerLocator()));
        return new ClusterControl(sf, this.server);
    }

    public long getRetryIntervalForReplicatedCluster() {
        return this.replicationLocator.getRetryInterval();
    }

    public void awaitConnectionToReplicationCluster() throws InterruptedException {
        this.replicationClusterConnectedLatch.await();
    }

    public void addClusterChannelHandler(Channel channel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, Activation activation) {
        channel.setHandler((ChannelHandler)new ClusterControllerChannelHandler(channel, acceptorUsed, remotingConnection, activation.getActivationChannelHandler(channel, acceptorUsed)));
    }

    public int getDefaultClusterSize() {
        return this.defaultLocator.getTopology().getMembers().size();
    }

    public Topology getDefaultClusterTopology() {
        return this.defaultLocator.getTopology();
    }

    public SimpleString getNodeID() {
        return this.server.getNodeID();
    }

    public String getIdentity() {
        return this.server.getIdentity();
    }

    public void setReplicatedClusterName(String replicatedClusterName) {
        this.replicatedClusterName = new SimpleString(replicatedClusterName);
    }

    public Map<SimpleString, ServerLocatorInternal> getLocators() {
        return this.locators;
    }

    public ServerLocator getReplicationLocator() {
        return this.replicationLocator;
    }

    public ServerLocator getServerLocator(SimpleString name) {
        return (ServerLocator)this.locators.get(name);
    }

    private final class ConnectRunnable
    implements Runnable {
        private final ServerLocatorInternal serverLocator;

        private ConnectRunnable(ServerLocatorInternal serverLocator) {
            this.serverLocator = serverLocator;
        }

        @Override
        public void run() {
            try {
                this.serverLocator.connect();
                if (this.serverLocator == ClusterController.this.replicationLocator) {
                    ClusterController.this.replicationClusterConnectedLatch.countDown();
                }
            }
            catch (ActiveMQException e) {
                if (!ClusterController.this.started) {
                    return;
                }
                ClusterController.this.server.getScheduledPool().schedule(this, this.serverLocator.getRetryInterval(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private final class ClusterControllerChannelHandler
    implements ChannelHandler {
        private final Channel clusterChannel;
        private final Acceptor acceptorUsed;
        private final CoreRemotingConnection remotingConnection;
        private final ChannelHandler channelHandler;
        boolean authorized = false;

        private ClusterControllerChannelHandler(Channel clusterChannel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, ChannelHandler channelHandler) {
            this.clusterChannel = clusterChannel;
            this.acceptorUsed = acceptorUsed;
            this.remotingConnection = remotingConnection;
            this.channelHandler = channelHandler;
        }

        public void handlePacket(Packet packet) {
            if (!ClusterController.this.isStarted()) {
                if (this.channelHandler != null) {
                    this.channelHandler.handlePacket(packet);
                }
                return;
            }
            if (!this.authorized) {
                if (packet.getType() == 125) {
                    ClusterConnection clusterConnection = this.acceptorUsed.getClusterConnection();
                    if (clusterConnection == null) {
                        clusterConnection = ClusterController.this.server.getClusterManager().getDefaultConnection(null);
                    }
                    ClusterConnectMessage msg = (ClusterConnectMessage)packet;
                    if (ClusterController.this.server.getConfiguration().isSecurityEnabled() && !clusterConnection.verify(msg.getClusterUser(), msg.getClusterPassword())) {
                        this.clusterChannel.send((Packet)new ClusterConnectReplyMessage(false));
                    } else {
                        this.authorized = true;
                        this.clusterChannel.send((Packet)new ClusterConnectReplyMessage(true));
                    }
                }
            } else if (packet.getType() == 111) {
                NodeAnnounceMessage msg = (NodeAnnounceMessage)packet;
                Pair pair = msg.isBackup() ? new Pair(null, (Object)msg.getConnector()) : new Pair((Object)msg.getConnector(), (Object)msg.getBackupConnector());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Server " + ClusterController.this.server + " receiving nodeUp from NodeID=" + msg.getNodeID() + ", pair=" + pair));
                }
                if (this.acceptorUsed != null) {
                    ClusterConnection clusterConn = this.acceptorUsed.getClusterConnection();
                    if (clusterConn != null) {
                        String scaleDownGroupName = msg.getScaleDownGroupName();
                        clusterConn.nodeAnnounced(msg.getCurrentEventID(), msg.getNodeID(), msg.getBackupGroupName(), scaleDownGroupName, (Pair<TransportConfiguration, TransportConfiguration>)pair, msg.isBackup());
                    } else {
                        logger.debug((Object)("Cluster connection is null on acceptor = " + this.acceptorUsed));
                    }
                } else {
                    logger.debug((Object)("there is no acceptor used configured at the CoreProtocolManager " + this));
                }
            } else if (packet.getType() == -2) {
                QuorumVoteMessage quorumVoteMessage = (QuorumVoteMessage)packet;
                QuorumVoteHandler voteHandler = ClusterController.this.quorumManager.getVoteHandler(quorumVoteMessage.getHandler());
                if (voteHandler == null) {
                    ActiveMQServerLogger.LOGGER.noVoteHandlerConfigured();
                    return;
                }
                quorumVoteMessage.decode(voteHandler);
                ActiveMQServerLogger.LOGGER.receivedQuorumVoteRequest(quorumVoteMessage.getVote().toString());
                Vote vote = ClusterController.this.quorumManager.vote(quorumVoteMessage.getHandler(), quorumVoteMessage.getVote());
                ActiveMQServerLogger.LOGGER.sendingQuorumVoteResponse(vote.toString());
                this.clusterChannel.send((Packet)new QuorumVoteReplyMessage(quorumVoteMessage.getHandler(), vote));
            } else if (packet.getType() == -6) {
                ScaleDownAnnounceMessage message = (ScaleDownAnnounceMessage)packet;
                if (ClusterController.this.server.getNodeID().equals((Object)message.getTargetNodeId())) {
                    ClusterController.this.server.addScaledDownNode(message.getScaledDownNodeId());
                }
            } else if (this.channelHandler != null) {
                this.channelHandler.handlePacket(packet);
            }
        }
    }
}

