/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.util.WSDLWrapperBasicImpl;
import org.apache.axis2.wsdl.util.WSDLWrapperImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WSDLWrapperReloadImpl
implements WSDLWrapperImpl {
    private static final Log log = LogFactory.getLog(WSDLWrapperReloadImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static final String myClassName = "WSDLWrapperReloadImpl";
    static final long serialVersionUID = -2788807375814097409L;
    private Definition wsdlDefinition = null;
    private URL wsdlURL = null;
    private String wsdlExplicitURI = null;
    private String wsdlDocumentBaseURI = null;
    private static boolean USE_SOFT_REFERENCES = true;
    private transient SoftReference softTypes = null;
    private transient SoftReference softDocElement = null;

    public WSDLWrapperReloadImpl(Definition def) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"WSDLWrapperReloadImpl(Definition def) called");
            log.trace((Object)JavaUtils.callStackToString());
        }
        this.prepare(def, null);
    }

    public WSDLWrapperReloadImpl(Definition def, URL wURL) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"WSDLWrapperReloadImpl(Definition def, URL wURL) called");
            log.trace((Object)JavaUtils.callStackToString());
        }
        this.prepare(def, wURL);
    }

    public static boolean isReloadable(Definition def, URL wURL) {
        boolean rc;
        String explicitURI;
        block8: {
            if (isDebugEnabled) {
                log.debug((Object)("Enter WSDLWrapperReloadImpl.isReloadable(): " + wURL));
            }
            explicitURI = null;
            if (def != null) {
                try {
                    String documentBaseURI = def.getDocumentBaseURI();
                    if (wURL == null && documentBaseURI != null) {
                        wURL = new URL(documentBaseURI);
                    }
                    if (wURL != null) {
                        explicitURI = WSDLWrapperReloadImpl.getExplicitURI(wURL);
                    }
                }
                catch (Exception e) {
                    if (!isDebugEnabled) break block8;
                    log.debug((Object)("WSDLWrapperReloadImpl.isReloaded(): [" + e.getClass().getName() + "]  error [" + e.getMessage() + "]"), (Throwable)e);
                    log.debug((Object)"Processing continues.");
                }
            }
        }
        if (isDebugEnabled) {
            log.debug((Object)(" explicitURI=" + explicitURI));
        }
        boolean bl = rc = explicitURI != null && explicitURI.length() > 0;
        if (isDebugEnabled) {
            log.debug((Object)("Exit WSDLWrapperReloadImpl.isReloadable(): " + rc));
        }
        return rc;
    }

    private void prepare(Definition def, URL wURL) {
        block9: {
            if (isDebugEnabled) {
                log.debug((Object)"WSDLWrapperReloadImpl.prepare()");
            }
            this.wsdlDefinition = def;
            this.wsdlURL = wURL;
            if (def != null) {
                try {
                    this.wsdlDocumentBaseURI = def.getDocumentBaseURI();
                    if (this.wsdlURL == null && this.wsdlDocumentBaseURI != null) {
                        try {
                            URL locURL;
                            this.wsdlURL = locURL = new URL(this.wsdlDocumentBaseURI);
                        }
                        catch (Exception uex) {
                            // empty catch block
                        }
                    }
                    if (this.wsdlURL != null) {
                        this.wsdlExplicitURI = WSDLWrapperReloadImpl.getExplicitURI(this.wsdlURL);
                    }
                    this.releaseResources();
                }
                catch (Exception e) {
                    if (!isDebugEnabled) break block9;
                    log.debug((Object)("WSDLWrapperReloadImpl.prepare():  Caught exception [" + e.getClass().getName() + "]  error [" + e.getMessage() + "]"), (Throwable)e);
                }
            }
        }
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.prepare():   wsdlDocumentBaseURI [" + this.wsdlDocumentBaseURI + "]     wsdlExplicitURI [" + this.wsdlExplicitURI + "]   wsdlURL [" + this.wsdlURL + "]"));
        }
    }

    public void releaseResources() {
        if (this.wsdlDefinition != null) {
            Types types = this.wsdlDefinition.getTypes();
            if (types != null) {
                this.wsdlDefinition.setTypes(null);
            }
            this.setCachedTypes(types);
            Element element = this.wsdlDefinition.getDocumentationElement();
            if (element != null) {
                this.wsdlDefinition.setDocumentationElement(null);
            }
            this.setCachedDocElement(element);
        }
    }

    private void setCachedTypes(Types types) {
        if (USE_SOFT_REFERENCES && (this.softTypes == null || this.softTypes.get() == null)) {
            this.softTypes = types != null ? new SoftReference<Types>(types) : new SoftReference<Boolean>(Boolean.FALSE);
        }
    }

    private Types getCachedTypes() {
        if (USE_SOFT_REFERENCES) {
            if (this.softTypes == null || this.softTypes.get() == null) {
                return null;
            }
            if (this.softTypes.get().equals(Boolean.FALSE)) {
                return null;
            }
            return (Types)this.softTypes.get();
        }
        return null;
    }

    private boolean hasCachedTypes() {
        if (USE_SOFT_REFERENCES) {
            return this.softTypes != null && this.softTypes.get() != null;
        }
        return false;
    }

    private void setCachedDocElement(Element e) {
        if (USE_SOFT_REFERENCES && (this.softDocElement == null || this.softDocElement.get() == null)) {
            this.softDocElement = e != null ? new SoftReference<Element>(e) : new SoftReference<Boolean>(Boolean.FALSE);
        }
    }

    private Element getCachedDocElement() {
        if (USE_SOFT_REFERENCES) {
            if (this.softDocElement == null || this.softDocElement.get() == null) {
                return null;
            }
            if (this.softDocElement.get().equals(Boolean.FALSE)) {
                return null;
            }
            return (Element)this.softDocElement.get();
        }
        return null;
    }

    private boolean hasCachedDocElement() {
        if (USE_SOFT_REFERENCES) {
            return this.softDocElement != null && this.softDocElement.get() != null;
        }
        return false;
    }

    public Definition getUnwrappedDefinition() {
        Definition def;
        if (this.wsdlDefinition == null) {
            try {
                def = this.loadDefinition();
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug((Object)("WSDLWrapperReloadImpl.getUnwrappedDefinition(): error trying to load Definition    [" + e.getClass().getName() + "]  error [" + e.getMessage() + "] "), (Throwable)e);
                }
                def = null;
            }
        } else if (this.wsdlDefinition instanceof WSDLWrapperBasicImpl) {
            def = ((WSDLWrapperBasicImpl)this.wsdlDefinition).getUnwrappedDefinition();
        } else {
            try {
                def = this.loadDefinition();
                if (def == null) {
                    def = this.wsdlDefinition;
                }
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug((Object)("WSDLWrapperReloadImpl.getUnwrappedDefinition(): error trying to load Definition    [" + e.getClass().getName() + "]  error [" + e.getMessage() + "] "), (Throwable)e);
                }
                def = this.wsdlDefinition;
            }
        }
        return def;
    }

    public void setDefinitionToWrap(Definition d) {
        this.wsdlDefinition = d;
    }

    public void setWSDLLocation(String uriLocation) {
        if (uriLocation != null) {
            try {
                this.wsdlURL = new URL(uriLocation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getWSDLLocation() {
        if (this.wsdlURL != null) {
            return this.wsdlURL.toString();
        }
        return null;
    }

    public void close() {
    }

    public void setDocumentBaseURI(String d) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.setDocumentBaseURI(" + d + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setDocumentBaseURI(d);
        }
    }

    public String getDocumentBaseURI() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getDocumentBaseURI()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getDocumentBaseURI();
        }
        return null;
    }

    public void setQName(QName n) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.setQName(" + n + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setQName(n);
        }
    }

    public QName getQName() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getQName()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getQName();
        }
        return null;
    }

    public void setTargetNamespace(String t) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.setTargetNamespace(" + t + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setTargetNamespace(t);
        }
    }

    public String getTargetNamespace() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getTargetNamespace()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getTargetNamespace();
        }
        return null;
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.addNamespace(" + prefix + ", " + namespaceURI + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addNamespace(prefix, namespaceURI);
        }
    }

    public String removeNamespace(String prefix) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.removeNamespace(" + prefix + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeNamespace(prefix);
        }
        return null;
    }

    public String getNamespace(String prefix) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getNamespace(" + prefix + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getNamespace(prefix);
        }
        return null;
    }

    public String getPrefix(String namespaceURI) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getPrefix(" + namespaceURI + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getPrefix(namespaceURI);
        }
        return null;
    }

    public Map getNamespaces() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getNamespaces()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getNamespaces();
        }
        return null;
    }

    public List getNativeAttributeNames() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getNativeAttributeNames()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getNativeAttributeNames();
        }
        return null;
    }

    public void setTypes(Types types) {
        if (this.wsdlDefinition != null) {
            if (isDebugEnabled) {
                log.debug((Object)"WSDLWrapperReloadImpl.setTypes() from wsdl Definition");
            }
            this.wsdlDefinition.setTypes(types);
            this.wsdlDefinition.setTypes(null);
        } else if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.setTypes(): nothing to set");
        }
    }

    public Types getTypes() {
        Definition def;
        block8: {
            if (isDebugEnabled) {
                log.trace((Object)("WSDLWrapperReloadImpl.getTypes() call stack =" + JavaUtils.callStackToString()));
            }
            if (this.hasCachedTypes()) {
                Types t = this.getCachedTypes();
                if (isDebugEnabled) {
                    log.debug((Object)("WSDLWrapperReloadImpl.getTypes() from soft reference [" + t + "]"));
                }
                return t;
            }
            def = null;
            try {
                def = this.loadDefinition();
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block8;
                log.debug((Object)("WSDLWrapperReloadImpl.getTypes(): error trying to load Definition    [" + e.getClass().getName() + "]  error [" + e.getMessage() + "] "), (Throwable)e);
            }
        }
        if (def != null) {
            Types t = def.getTypes();
            this.setCachedTypes(t);
            this.setCachedDocElement(def.getDocumentationElement());
            if (isDebugEnabled) {
                log.debug((Object)("WSDLWrapperReloadImpl.getTypes() from reloaded wsdl Definition returning [" + t + "]"));
            }
            return t;
        }
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getTypes() returning NULL");
        }
        return null;
    }

    public void addImport(Import importDef) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.addImport(" + importDef + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addImport(importDef);
        }
    }

    public Import removeImport(Import importDef) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.removeImport(" + importDef + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeImport(importDef);
        }
        return null;
    }

    public List getImports(String namespaceURI) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getImports(" + namespaceURI + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getImports(namespaceURI);
        }
        return null;
    }

    public Map getImports() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getImports()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getImports();
        }
        return null;
    }

    public void addMessage(Message message) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.addMessage(" + message + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addMessage(message);
        }
    }

    public Message getMessage(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getMessage(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getMessage(name);
        }
        return null;
    }

    public Message removeMessage(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.removeMessage(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeMessage(name);
        }
        return null;
    }

    public Map getMessages() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getMessages()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getMessages();
        }
        return null;
    }

    public void addBinding(Binding binding) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.addBinding(" + binding + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addBinding(binding);
        }
    }

    public Binding getBinding(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getBinding(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getBinding(name);
        }
        return null;
    }

    public Binding removeBinding(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.removeBinding(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeBinding(name);
        }
        return null;
    }

    public Map getBindings() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getBindings()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getBindings();
        }
        return null;
    }

    public Map getAllBindings() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getAllBindings()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getAllBindings();
        }
        return null;
    }

    public void addPortType(PortType portType) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.addPortType(" + portType + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addPortType(portType);
        }
    }

    public PortType getPortType(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getPortType(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getPortType(name);
        }
        return null;
    }

    public PortType removePortType(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.removePortType(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removePortType(name);
        }
        return null;
    }

    public Map getPortTypes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getPortTypes()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getPortTypes();
        }
        return null;
    }

    public Map getAllPortTypes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getAllPortTypes()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getAllPortTypes();
        }
        return null;
    }

    public void addService(Service service) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.addService(" + service + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addService(service);
        }
    }

    public Service getService(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getService(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getService(name);
        }
        return null;
    }

    public Service removeService(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.removeService(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeService(name);
        }
        return null;
    }

    public Map getServices() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getServices()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getServices();
        }
        return null;
    }

    public Map getAllServices() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getAllServices()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getAllServices();
        }
        return null;
    }

    public void setDocumentationElement(Element docEl) {
        if (this.wsdlDefinition != null) {
            if (isDebugEnabled) {
                log.debug((Object)"WSDLWrapperReloadImpl.setDocumentationElement(docEl) from wsdl Definition");
            }
            this.wsdlDefinition.setDocumentationElement(docEl);
            this.wsdlDefinition.setDocumentationElement(null);
        } else if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.setDocumentationElement(docEl): nothing to set");
        }
    }

    public Element getDocumentationElement() {
        Definition def;
        block11: {
            if (isDebugEnabled) {
                log.trace((Object)("WSDLWrapperReloadImpl.getDocumentationElement() call stack =" + JavaUtils.callStackToString()));
            }
            if (this.hasCachedDocElement()) {
                Element e = this.getCachedDocElement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"WSDLWrapperReloadImpl.getDocumentationElement() from soft reference ");
                }
                return e;
            }
            if (isDebugEnabled) {
                log.debug((Object)"WSDLWrapperReloadImpl.getDocumentationElement() from reloaded wsdl Definition");
            }
            def = null;
            try {
                def = this.loadDefinition();
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block11;
                log.debug((Object)("WSDLWrapperReloadImpl.getDocumentationElement(): error trying to load Definition    [" + e.getClass().getName() + "]  error [" + e.getMessage() + "] "), (Throwable)e);
            }
        }
        if (def != null) {
            Element docElement = def.getDocumentationElement();
            this.setCachedDocElement(docElement);
            this.setCachedTypes(def.getTypes());
            if (isDebugEnabled) {
                if (docElement != null) {
                    log.debug((Object)"WSDLWrapperReloadImpl.getDocumentationElement() from reloaded wsdl Definition returning  NON-NULL org.w3c.dom.Element");
                } else {
                    log.debug((Object)"WSDLWrapperReloadImpl.getDocumentationElement() from reloaded wsdl Definition returning  NULL org.w3c.dom.Element");
                }
            }
            return docElement;
        }
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getDocumentationElement() returning NULL");
        }
        return null;
    }

    public void addExtensibilityElement(ExtensibilityElement extElement) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.addExtensibilityElement(" + extElement + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addExtensibilityElement(extElement);
        }
    }

    public List getExtensibilityElements() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getExtensibilityElements()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getExtensibilityElements();
        }
        return null;
    }

    public Binding createBinding() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createBinding()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBinding();
        }
        return null;
    }

    public BindingFault createBindingFault() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createBindingFault()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBindingFault();
        }
        return null;
    }

    public BindingInput createBindingInput() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createBindingInput()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBindingInput();
        }
        return null;
    }

    public BindingOperation createBindingOperation() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createBindingOperation()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBindingOperation();
        }
        return null;
    }

    public BindingOutput createBindingOutput() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createBindingOutput()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBindingOutput();
        }
        return null;
    }

    public Fault createFault() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createFault()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createFault();
        }
        return null;
    }

    public Import createImport() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createImport()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createImport();
        }
        return null;
    }

    public Input createInput() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createInput()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createInput();
        }
        return null;
    }

    public Message createMessage() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createMessage()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createMessage();
        }
        return null;
    }

    public Operation createOperation() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createOperation()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createOperation();
        }
        return null;
    }

    public Output createOutput() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createOutput()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createOutput();
        }
        return null;
    }

    public Part createPart() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createPart()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createPart();
        }
        return null;
    }

    public Port createPort() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createPort()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createPort();
        }
        return null;
    }

    public PortType createPortType() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createPortType()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createPortType();
        }
        return null;
    }

    public Service createService() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createService()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createService();
        }
        return null;
    }

    public Types createTypes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.createTypes()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createTypes();
        }
        return null;
    }

    public void setExtensionRegistry(ExtensionRegistry extReg) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.setExtensionRegistry(" + extReg + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setExtensionRegistry(extReg);
        }
    }

    public ExtensionRegistry getExtensionRegistry() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getExtensionRegistry()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getExtensionRegistry();
        }
        return null;
    }

    public String toString() {
        if (this.wsdlDefinition != null) {
            return this.getClass().getName() + "\n" + this.wsdlDefinition.toString();
        }
        return this.getClass().getName();
    }

    public ExtensibilityElement removeExtensibilityElement(ExtensibilityElement extElement) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.removeExtensibilityElement(" + extElement + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeExtensibilityElement(extElement);
        }
        return null;
    }

    public Object getExtensionAttribute(QName name) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getExtensionAttribute(" + name + ")"));
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getExtensionAttribute(name);
        }
        return null;
    }

    public Map getExtensionAttributes() {
        if (isDebugEnabled) {
            log.debug((Object)"WSDLWrapperReloadImpl.getExtensionAttributes()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getExtensionAttributes();
        }
        return null;
    }

    public void setExtensionAttribute(QName name, Object value) {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.setExtensionAttribute(" + name + ",  " + value + ")"));
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setExtensionAttribute(name, value);
        }
    }

    private static String getExplicitURI(URL wsdlURL) throws WSDLException {
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + ") "));
        }
        String explicitURI = null;
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            boolean isFileProtocol;
            URL url = wsdlURL;
            String filePath = null;
            boolean bl = isFileProtocol = url != null && "file".equals(url.getProtocol());
            if (isFileProtocol) {
                boolean isRelativePath;
                filePath = url != null ? url.getPath() : null;
                URI uri = null;
                if (url != null) {
                    uri = new URI(url.toString());
                }
                boolean bl2 = isRelativePath = filePath != null && !new File(filePath).isAbsolute();
                if (isRelativePath) {
                    if (isDebugEnabled) {
                        log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + "): WSDL URL has a relative path"));
                    }
                    if ((url = WSDLWrapperReloadImpl.getAbsoluteURL(classLoader, filePath, wsdlURL)) == null) {
                        if (isDebugEnabled) {
                            log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + "): " + "WSDL URL for relative path not found in ClassLoader"));
                            log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + "): " + "Unable to read WSDL from relative path, check the relative path"));
                            log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + "): " + "Relative path example: file:/WEB-INF/wsdl/<wsdlfilename>"));
                            log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + "): " + "Using relative path as default wsdl URL to load wsdl Definition."));
                        }
                        url = wsdlURL;
                    } else if (isDebugEnabled) {
                        log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + "): " + "WSDL URL found for relative path: " + filePath + " scheme: " + uri.getScheme()));
                    }
                }
            }
            URLConnection urlCon = url.openConnection();
            InputStream is = null;
            try {
                is = WSDLWrapperReloadImpl.getInputStream(urlCon);
            }
            catch (IOException e) {
                if (isDebugEnabled) {
                    log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + "): " + "Could not open url connection. Trying to use " + "classloader to get another URL."));
                }
                if (filePath != null) {
                    url = WSDLWrapperReloadImpl.getAbsoluteURL(classLoader, filePath, wsdlURL);
                    if (url == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Could not locate URL for wsdl. Reporting error");
                        }
                        throw new WSDLException("WSDL4JWrapper : ", e.getMessage(), (Throwable)e);
                    }
                    urlCon = url.openConnection();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found URL for WSDL from jar");
                    }
                }
                if (isDebugEnabled) {
                    log.debug((Object)("WSDLWrapperReloadImpl.getExplicitURI(" + wsdlURL + "): " + "Could not get URL from classloader. Reporting " + "error due to no file path."));
                }
                throw new WSDLException("WSDLWrapperReloadImpl : ", e.getMessage(), (Throwable)e);
            }
            if (is != null) {
                is.close();
            }
            explicitURI = urlCon.getURL().toString();
        }
        catch (Exception ex) {
            throw new WSDLException("WSDLWrapperReloadImpl : ", ex.getMessage(), (Throwable)ex);
        }
        return explicitURI;
    }

    private static URL getAbsoluteURL(final ClassLoader classLoader, final String filePath, URL wURL) throws WSDLException {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classLoader.getResource(filePath);
            }
        });
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not get URL from classloader. Looking in a jar.");
            }
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlLoader = (URLClassLoader)classLoader;
                url = WSDLWrapperReloadImpl.getURLFromJAR(urlLoader, wURL);
            }
        }
        return url;
    }

    private Definition loadDefinition() throws WSDLException {
        Definition def = null;
        if (this.wsdlExplicitURI != null) {
            try {
                def = (Definition)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSDLException {
                        WSDLReader reader = WSDLWrapperReloadImpl.this.getWSDLReader();
                        return reader.readWSDL(WSDLWrapperReloadImpl.this.wsdlExplicitURI);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (isDebugEnabled) {
                    log.debug((Object)("WSDLWrapperReloadImpl.loadDefinition(): Exception thrown from AccessController: " + e));
                    log.trace((Object)("Call Stack = " + JavaUtils.callStackToString()));
                }
                WSDLException we = new WSDLException("WSDLWrapperReloadImpl : ", e.getMessage(), (Throwable)e);
                throw we;
            }
        }
        if (isDebugEnabled) {
            log.debug((Object)("WSDLWrapperReloadImpl.loadDefinition():  returning Definition [" + def + "]"));
            log.trace((Object)("Call Stack = " + JavaUtils.callStackToString()));
        }
        return def;
    }

    private static URL getURLFromJAR(URLClassLoader urlLoader, URL relativeURL) throws WSDLException {
        URL[] urlList = urlLoader.getURLs();
        if (urlList == null) {
            return null;
        }
        for (int i = 0; i < urlList.length; ++i) {
            File f;
            URL url = urlList[i];
            if (url == null) {
                return null;
            }
            if (!"file".equals(url.getProtocol()) || !(f = new File(url.getPath())).exists() || f.isDirectory()) continue;
            try {
                JarFile jf = new JarFile(f);
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    String relativePath;
                    JarEntry je = entries.nextElement();
                    String name = je.getName();
                    if (!name.endsWith(".wsdl") || !(relativePath = relativeURL.getPath()).endsWith(name)) continue;
                    String path = f.getAbsolutePath();
                    if (path != null && path.indexOf("/") == 0) {
                        path = path.substring(1, path.length());
                    }
                    URL absoluteUrl = new URL("jar:file:/" + path + "!/" + je.getName());
                    return absoluteUrl;
                }
                continue;
            }
            catch (Exception e) {
                WSDLException we = new WSDLException("WSDLWrapperReloadImpl : ", e.getMessage(), (Throwable)e);
                throw we;
            }
        }
        return null;
    }

    private WSDLReader getWSDLReader() throws WSDLException {
        WSDLReader reader;
        try {
            reader = (WSDLReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WSDLException {
                    return WSDLUtil.newWSDLReaderWithPopulatedExtensionRegistry();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (WSDLException)((Object)e.getException());
        }
        reader.setFeature("javax.wsdl.verbose", false);
        return reader;
    }

    private static InputStream getInputStream(URLConnection urlCon) throws Exception {
        final URLConnection finalURLCon = urlCon;
        InputStream is = null;
        try {
            is = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return finalURLCon.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return is;
    }
}

