/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.function.LongBinaryOperator;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BloomFilter;

public final class SetOperations {
    public static int andCardinality(BitMapExtractor first, BitMapExtractor second) {
        return SetOperations.cardinality(first, second, (x, y) -> x & y);
    }

    public static int cardinality(BitMapExtractor bitMapExtractor) {
        int[] cardinality = new int[1];
        bitMapExtractor.processBitMaps(l -> {
            cardinality[0] = cardinality[0] + Long.bitCount(l);
            return true;
        });
        return cardinality[0];
    }

    private static int cardinality(BitMapExtractor first, BitMapExtractor second, LongBinaryOperator op) {
        int[] cardinality = new int[1];
        first.processBitMapPairs(second, (x, y) -> {
            cardinality[0] = cardinality[0] + Long.bitCount(op.applyAsLong(x, y));
            return true;
        });
        return cardinality[0];
    }

    public static double cosineDistance(BitMapExtractor first, BitMapExtractor second) {
        return 1.0 - SetOperations.cosineSimilarity(first, second);
    }

    public static double cosineSimilarity(BitMapExtractor first, BitMapExtractor second) {
        int numerator = SetOperations.andCardinality(first, second);
        return numerator == 0 ? 0.0 : (double)numerator / Math.sqrt(SetOperations.cardinality(first) * SetOperations.cardinality(second));
    }

    public static double cosineSimilarity(BloomFilter first, BloomFilter second) {
        int numerator = SetOperations.andCardinality(first, second);
        return numerator == 0 ? 0.0 : (double)numerator / Math.sqrt(first.cardinality() * second.cardinality());
    }

    public static int hammingDistance(BitMapExtractor first, BitMapExtractor second) {
        return SetOperations.xorCardinality(first, second);
    }

    public static double jaccardDistance(BitMapExtractor first, BitMapExtractor second) {
        return 1.0 - SetOperations.jaccardSimilarity(first, second);
    }

    public static double jaccardSimilarity(BitMapExtractor first, BitMapExtractor second) {
        int[] cardinality = new int[2];
        first.processBitMapPairs(second, (x, y) -> {
            cardinality[0] = cardinality[0] + Long.bitCount(x & y);
            cardinality[1] = cardinality[1] + Long.bitCount(x | y);
            return true;
        });
        int intersection = cardinality[0];
        return intersection == 0 ? 0.0 : (double)intersection / (double)cardinality[1];
    }

    public static int orCardinality(BitMapExtractor first, BitMapExtractor second) {
        return SetOperations.cardinality(first, second, (x, y) -> x | y);
    }

    public static int xorCardinality(BitMapExtractor first, BitMapExtractor second) {
        return SetOperations.cardinality(first, second, (x, y) -> x ^ y);
    }

    private SetOperations() {
    }
}

