/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.xcas_comparison;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.ctakes.utils.xcas_comparison.Const;
import org.apache.ctakes.utils.xcas_comparison.XcasAnnotation;
import org.apache.ctakes.utils.xcas_comparison.XcasDiff;
import org.apache.ctakes.utils.xcas_comparison.XcasFile;
import org.apache.ctakes.utils.xcas_comparison.XcasProcessor;

public class ConvertAndCompare {
    public static void main(String[] args) {
        File f2;
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("edu.mayo.bmi.uima.common.type.DocumentID", "edu.mayo.bmi.uima.common.types.DocumentIDAnnotation");
        map.put("org.apache.ctakes.typesystem.type.textspan.LookupWindowAnnotation", "edu.mayo.bmi.uima.lookup.types.LookupWindowAnnotation");
        map.put("edu.mayo.bmi.uima.cdt.type.RomanNumeralAnnotation", "edu.mayo.bmi.uima.cdt.types.RomanNumeralAnnotation");
        map.put("edu.mayo.bmi.uima.cdt.type.FractionAnnotation", "edu.mayo.bmi.uima.cdt.types.FractionAnnotation");
        map.put("edu.mayo.bmi.uima.cdt.type.DateAnnotation", "edu.mayo.bmi.uima.cdt.types.DateAnnotation");
        map.put("edu.mayo.bmi.uima.cdt.type.ProblemListAnnotation", "edu.mayo.bmi.uima.cdt.types.ProblemListAnnotation");
        map.put("edu.mayo.bmi.uima.cdt.type.MeasurementAnnotation", "edu.mayo.bmi.uima.cdt.types.MeasurementAnnotation");
        map.put("edu.mayo.bmi.uima.cdt.type.PersonTitleAnnotation", "edu.mayo.bmi.uima.cdt.types.PersonTitleAnnotation");
        map.put("org.apache.ctakes.typesystem.type.textspan.Segment", "edu.mayo.bmi.uima.common.types.SegmentAnnotation");
        map.put("org.apache.ctakes.typesystem.type.textspan.Sentence", "edu.mayo.bmi.uima.common.types.SentenceAnnotation");
        map.put("org.apache.ctakes.typesystem.type.syntax.WordToken", "edu.mayo.bmi.uima.common.types.WordTokenAnnotation");
        map.put("org.apache.ctakes.typesystem.type.NumToken", "edu.mayo.bmi.uima.common.types.NumTokenAnnotation");
        map.put("org.apache.ctakes.typesystem.type.PunctuationToken", "edu.mayo.bmi.uima.common.types.PunctTokenAnnotation");
        map.put("org.apache.ctakes.typesystem.type.SymbolToken", "edu.mayo.bmi.uima.common.types.SymbolTokenAnnotation");
        map.put("org.apache.ctakes.typesystem.type.NewlineToken", "edu.mayo.bmi.uima.common.types.NewlineTokenAnnotation");
        map.put("org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation", "edu.mayo.bmi.uima.common.types.NamedEntityAnnotation");
        map.put("org.apache.ctakes.typesystem.type.UmlsConcept", "edu.mayo.bmi.uima.common.types.UmlsConcept");
        map.put("org.apache.ctakes.typesystem.type.OntologyConcept", "edu.mayo.bmi.uima.common.types.OntologyConcept");
        Const.init();
        XcasProcessor p = new XcasProcessor();
        File f1 = new File(args[0]);
        if (!f1.exists()) {
            System.err.println(args[0] + " not exist!");
            System.exit(1);
        }
        if (!(f2 = new File(args[1])).exists()) {
            System.err.println(args[1] + " not exist!");
            System.exit(1);
        }
        XcasFile xf1 = p.process(f1);
        XcasFile xf2 = p.process(f2);
        for (XcasAnnotation a : xf1.getAllAnnotations()) {
            if (!map.containsKey(a.getType())) continue;
            a.setType((String)map.get(a.getType()));
        }
        XcasDiff d = new XcasDiff(xf1, xf2);
        d.printDiff();
        try {
            d.printHTML(new FileWriter(args[2]));
            System.out.println();
            System.out.println("HTML summary written to " + args[2]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

