/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.xcas_comparison;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.ctakes.utils.xcas_comparison.Const;

public class XcasAnnotation
implements Cloneable,
Comparable<XcasAnnotation> {
    protected String type = "";
    protected Hashtable<String, String> attributes = new Hashtable();
    protected Hashtable<String, MyVector> references = new Hashtable();
    protected Hashtable<String, Vector<Integer>> refIntArrays = new Hashtable();

    public XcasAnnotation() {
    }

    public XcasAnnotation(String t) {
        this();
        this.type = t;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void insertAttribute(String k, String v) {
        this.attributes.put(k, v);
    }

    public void insertReference(String k, XcasAnnotation a) {
        if (this.references.containsKey(k)) {
            this.references.get(k).add(a);
        } else {
            MyVector v = new MyVector();
            v.add(a);
            this.references.put(k, v);
        }
    }

    public void insertIntReference(String k, int[] a) {
        Vector<Integer> v = new Vector<Integer>(a.length);
        for (int i : a) {
            v.add(i);
        }
        this.refIntArrays.put(k, v);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Vector<XcasAnnotation> getReference(String name) {
        return this.references.get(name);
    }

    public boolean equals(Object obj) {
        return this == obj || obj.getClass() == this.getClass() && ((XcasAnnotation)obj).type.equals(this.type) && ((XcasAnnotation)obj).attributes.equals(this.attributes) && ((XcasAnnotation)obj).references.equals(this.references) && ((XcasAnnotation)obj).refIntArrays.equals(this.refIntArrays);
    }

    public String getType() {
        return this.type;
    }

    public String shortType() {
        return this.type.substring(this.type.lastIndexOf(46) + 1);
    }

    public String allFieldsValues() {
        StringBuffer ret = new StringBuffer("Attributes {");
        Vector<String> v = new Vector<String>(this.attributes.keySet());
        Collections.sort(v);
        for (String s : v) {
            ret.append(s + "=" + this.attributes.get(s) + ", ");
        }
        if (v.size() > 0) {
            ret.replace(ret.length() - 2, ret.length(), "}  References {");
        }
        v.clear();
        v.addAll(this.references.keySet());
        v.addAll(this.refIntArrays.keySet());
        Collections.sort(v);
        for (String s : v) {
            ret.append(s + "=" + (this.references.containsKey(s) ? (Vector<Integer>)this.references.get(s) : this.refIntArrays.get(s)) + ", ");
        }
        if (v.size() > 0) {
            ret.delete(ret.length() - 2, ret.length());
        }
        ret.append("}");
        return ret.toString();
    }

    public String description() {
        return this.shortType() + "  " + this.allFieldsValues();
    }

    private final XcasAnnotation prepareCopy() {
        XcasAnnotation o = null;
        try {
            o = (XcasAnnotation)super.clone();
            o.attributes = new Hashtable();
            o.attributes.putAll(this.attributes);
            o.references = new Hashtable();
            o.refIntArrays = new Hashtable();
            for (String s : this.refIntArrays.keySet()) {
                o.refIntArrays.put(s, new Vector(this.refIntArrays.get(s)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return o;
    }

    public Object clone() {
        XcasAnnotation o = this.prepareCopy();
        for (String s : this.references.keySet()) {
            o.references.put(s, (MyVector)this.references.get(s).clone());
        }
        return o;
    }

    public final XcasAnnotation shallowCopy() {
        XcasAnnotation o = this.prepareCopy();
        for (String s : this.references.keySet()) {
            o.references.put(s, new MyVector());
        }
        return o;
    }

    @Override
    public int compareTo(XcasAnnotation o) {
        return this.description().compareTo(o.description());
    }

    private class MyVector
    extends Vector<XcasAnnotation>
    implements Cloneable {
        private static final long serialVersionUID = -8717810064045790243L;

        @Override
        public boolean contains(Object obj) {
            if (obj.getClass() != XcasAnnotation.class) {
                return false;
            }
            for (XcasAnnotation a : this) {
                if (!a.equals(obj)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c == this || c.size() == 0) {
                return true;
            }
            for (Object o : c) {
                if (o.getClass() == XcasAnnotation.class && this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass() || ((MyVector)obj).size() != this.size()) {
                return false;
            }
            return this.containsAll((MyVector)obj);
        }

        @Override
        public String toString() {
            StringBuffer ret = new StringBuffer("[");
            Collections.sort(this);
            for (XcasAnnotation a : this) {
                ret.append(a.type.equalsIgnoreCase(Const.UIMA_SOFA) ? Const.HIDDEN_TEXT : a.description()).append(",");
            }
            if (this.size() > 0) {
                ret.deleteCharAt(ret.length() - 1);
            }
            return ret.append("]").toString();
        }

        @Override
        public Object clone() {
            MyVector o = null;
            try {
                o = (MyVector)super.clone();
                o.clear();
                for (XcasAnnotation a : this) {
                    o.add((XcasAnnotation)a.clone());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return o;
        }
    }
}

