/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.dinky;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.dinky.DinkyParameters;
import org.apache.dolphinscheduler.plugin.task.dinky.DinkyTaskException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class DinkyTask
extends AbstractRemoteTask {
    private final TaskExecutionContext taskExecutionContext;
    private DinkyParameters dinkyParameters;

    protected DinkyTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        String taskParams = this.taskExecutionContext.getTaskParams();
        this.logger.info("dinky task params:{}", (Object)taskParams);
        this.dinkyParameters = (DinkyParameters)((Object)JSONUtils.parseObject((String)taskParams, DinkyParameters.class));
        if (this.dinkyParameters == null || !this.dinkyParameters.checkParameters()) {
            throw new DinkyTaskException("dinky task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String address = this.dinkyParameters.getAddress();
            String taskId = this.dinkyParameters.getTaskId();
            boolean isOnline = this.dinkyParameters.isOnline();
            JsonNode result = isOnline ? this.onlineTask(address, taskId) : this.submitTask(address, taskId);
            if (this.checkResult(result)) {
                JsonNode jobInstanceInfoResult;
                boolean status = result.get("datas").get("success").asBoolean();
                String jobInstanceId = result.get("datas").get("jobInstanceId").asText();
                boolean finishFlag = false;
                block12: while (!finishFlag && this.checkResult(jobInstanceInfoResult = this.getJobInstanceInfo(address, jobInstanceId))) {
                    String jobInstanceStatus;
                    switch (jobInstanceStatus = jobInstanceInfoResult.get("datas").get("status").asText()) {
                        case "FINISHED": {
                            int exitStatusCode = this.mapStatusToExitCode(status);
                            this.setAppIds(String.format("%s-%s", address, taskId));
                            this.setExitStatusCode(exitStatusCode);
                            this.logger.info("dinky task finished with results: {}", (Object)result.get("datas"));
                            finishFlag = true;
                            continue block12;
                        }
                        case "FAILED": 
                        case "CANCELED": 
                        case "UNKNOWN": {
                            this.errorHandle(jobInstanceInfoResult.get("datas").get("error").asText());
                            finishFlag = true;
                            continue block12;
                        }
                    }
                    Thread.sleep(3000L);
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.logger.error("Execute dinkyTask failed", (Throwable)ex);
            this.setExitStatusCode(-1);
            throw new TaskException("Execute dinkyTask failed", (Throwable)ex);
        }
    }

    public void submitApplication() throws TaskException {
    }

    public void trackApplicationStatus() throws TaskException {
    }

    private int mapStatusToExitCode(boolean status) {
        if (status) {
            return 0;
        }
        return -1;
    }

    private boolean checkResult(JsonNode result) {
        if (result instanceof MissingNode || result == null) {
            this.errorHandle("Please check that the dinky version is greater than or equal to 0.6.5");
            return false;
        }
        if (result.get("code").asInt() == 1) {
            this.errorHandle(result.get("msg"));
            return false;
        }
        return true;
    }

    private void errorHandle(Object msg) {
        this.setExitStatusCode(-1);
        this.logger.error("dinky task submit failed with error: {}", msg);
    }

    public AbstractParameters getParameters() {
        return this.dinkyParameters;
    }

    public void cancelApplication() throws TaskException {
        String address = this.dinkyParameters.getAddress();
        String taskId = this.dinkyParameters.getTaskId();
        this.logger.info("trying terminate dinky task, taskId: {}, address: {}, taskId: {}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), address, taskId});
        this.cancelTask(address, taskId);
        this.logger.warn("dinky task terminated, taskId: {}, address: {}, taskId: {}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), address, taskId});
    }

    private JsonNode submitTask(String address, String taskId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", taskId);
        return this.parse(this.doGet(address + "/openapi/submitTask", params));
    }

    private JsonNode onlineTask(String address, String taskId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", taskId);
        return this.parse(this.doGet(address + "/openapi/onLineTask", params));
    }

    private JsonNode cancelTask(String address, String taskId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        params.put("type", "cancel");
        return this.parse(this.sendJsonStr(address + "/openapi/savepointTask", JSONUtils.toJsonString(params)));
    }

    private JsonNode getJobInstanceInfo(String address, String taskId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", taskId);
        return this.parse(this.doGet(address + "/openapi/getJobInstance", params));
    }

    private JsonNode parse(String res) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode result = null;
        try {
            result = mapper.readTree(res);
        }
        catch (JsonProcessingException e) {
            this.logger.error("dinky task submit failed with error", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doGet(String url, Map<String, String> params) {
        String result = "";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (null != params && !params.isEmpty()) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    uriBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            URI uri = uriBuilder.build();
            httpGet = new HttpGet(uri);
            this.logger.info("access url: {}", (Object)uri);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.info("dinky task succeed with results: {}", (Object)result);
            } else {
                this.logger.error("dinky task terminated,response: {}", (Object)response);
            }
        }
        catch (IllegalArgumentException ie) {
            this.logger.error("dinky task terminated: {}", (Object)ie.getMessage());
        }
        catch (Exception e) {
            this.logger.error("dinky task terminated: ", (Throwable)e);
        }
        finally {
            if (null != httpGet) {
                httpGet.releaseConnection();
            }
        }
        return result;
    }

    private String sendJsonStr(String url, String params) {
        String result = "";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        try {
            HttpResponse response;
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            if (StringUtils.isNotBlank((CharSequence)params)) {
                httpPost.setEntity((HttpEntity)new StringEntity(params, StandardCharsets.UTF_8));
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.info("dinky task succeed with results: {}", (Object)result);
            } else {
                this.logger.error("dinky task terminated,response: {}", (Object)response);
            }
        }
        catch (IllegalArgumentException ie) {
            this.logger.error("dinky task terminated: {}", (Object)ie.getMessage());
        }
        catch (Exception he) {
            this.logger.error("dinky task terminated: ", (Throwable)he);
        }
        return result;
    }
}

