/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.plugin.task.api.ProcessUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.registry.WorkerRegistryClient;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcClient;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcServer;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.service.alert.AlertClientService;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(basePackages={"org.apache.dolphinscheduler"}, excludeFilters={@ComponentScan.Filter(type=FilterType.REGEX, pattern={"org.apache.dolphinscheduler.service.process.*", "org.apache.dolphinscheduler.service.queue.*"})})
public class WorkerServer
implements IStoppable {
    private static final Logger logger = LoggerFactory.getLogger(WorkerServer.class);
    @Autowired
    private SpringApplicationContext springApplicationContext;
    @Autowired
    private AlertClientService alertClientService;
    @Autowired
    private WorkerManagerThread workerManagerThread;
    @Autowired
    private WorkerRegistryClient workerRegistryClient;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private WorkerRpcServer workerRpcServer;
    @Autowired
    private WorkerRpcClient workerRpcClient;
    @Autowired
    private MessageRetryRunner messageRetryRunner;
    @Autowired
    private WorkerConfig workerConfig;

    public static void main(String[] args) {
        Thread.currentThread().setName("Worker-Server");
        SpringApplication.run(WorkerServer.class, (String[])new String[0]);
    }

    @PostConstruct
    public void run() {
        this.workerRpcServer.start();
        this.workerRpcClient.start();
        this.taskPluginManager.loadPlugin();
        this.workerRegistryClient.setRegistryStoppable(this);
        this.workerRegistryClient.start();
        this.workerManagerThread.start();
        this.messageRetryRunner.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!ServerLifeCycleManager.isStopped()) {
                this.close("WorkerServer shutdown hook");
            }
        }));
    }

    public void close(String cause) {
        if (!ServerLifeCycleManager.toStopped()) {
            logger.warn("WorkerServer is already stopped, current cause: {}", (Object)cause);
            return;
        }
        ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
        try (WorkerRpcServer closedWorkerRpcServer = this.workerRpcServer;
             WorkerRegistryClient closedRegistryClient = this.workerRegistryClient;
             AlertClientService closedAlertClientService = this.alertClientService;
             SpringApplicationContext closedSpringContext = this.springApplicationContext;){
            logger.info("Worker server is stopping, current cause : {}", (Object)cause);
            this.killAllRunningTasks();
        }
        catch (Exception e) {
            logger.error("Worker server stop failed, current cause: {}", (Object)cause, (Object)e);
            return;
        }
        logger.info("Worker server stopped, current cause: {}", (Object)cause);
    }

    public void stop(String cause) {
        this.close(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllRunningTasks() {
        Collection taskRequests = TaskExecutionContextCacheManager.getAllTaskRequestList();
        if (CollectionUtils.isEmpty((Collection)taskRequests)) {
            return;
        }
        logger.info("Worker begin to kill all cache task, task size: {}", (Object)taskRequests.size());
        int killNumber = 0;
        for (TaskExecutionContext taskRequest : taskRequests) {
            try {
                LoggerUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskRequest.getProcessInstanceId(), (Integer)taskRequest.getTaskInstanceId());
                if (!ProcessUtils.kill((TaskExecutionContext)taskRequest)) continue;
                ++killNumber;
            }
            finally {
                LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
            }
        }
        logger.info("Worker after kill all cache task, task size: {}, killed number: {}", (Object)taskRequests.size(), (Object)killNumber);
    }
}

