/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.config;

import java.time.Duration;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.registry.api.ConnectStrategyProperties;
import org.apache.dolphinscheduler.server.worker.config.TaskExecuteThreadsFullPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="worker")
public class WorkerConfig
implements Validator {
    private Logger logger = LoggerFactory.getLogger(WorkerConfig.class);
    private int listenPort = 1234;
    private int execThreads = 10;
    private Duration heartbeatInterval = Duration.ofSeconds(10L);
    private int hostWeight = 100;
    private boolean tenantAutoCreate = true;
    private boolean tenantDistributedUser = false;
    private int maxCpuLoadAvg = -1;
    private double reservedMemory = 0.3;
    private String alertListenHost = "localhost";
    private int alertListenPort = 50052;
    private ConnectStrategyProperties registryDisconnectStrategy = new ConnectStrategyProperties();
    private String workerAddress;
    private String workerRegistryPath;
    private TaskExecuteThreadsFullPolicy taskExecuteThreadsFullPolicy = TaskExecuteThreadsFullPolicy.REJECT;

    public boolean supports(Class<?> clazz) {
        return WorkerConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        WorkerConfig workerConfig = (WorkerConfig)target;
        if (workerConfig.getExecThreads() <= 0) {
            errors.rejectValue("exec-threads", null, "should be a positive value");
        }
        if (workerConfig.getHeartbeatInterval().getSeconds() <= 0L) {
            errors.rejectValue("heartbeat-interval", null, "shoule be a valid duration");
        }
        if (workerConfig.getMaxCpuLoadAvg() <= 0) {
            workerConfig.setMaxCpuLoadAvg(Runtime.getRuntime().availableProcessors() * 2);
        }
        workerConfig.setWorkerAddress(NetUtils.getAddr((int)workerConfig.getListenPort()));
        workerConfig.setWorkerRegistryPath("/nodes/worker/" + workerConfig.getWorkerAddress());
        this.printConfig();
    }

    private void printConfig() {
        this.logger.info("Worker config: listenPort -> {}", (Object)this.listenPort);
        this.logger.info("Worker config: execThreads -> {}", (Object)this.execThreads);
        this.logger.info("Worker config: heartbeatInterval -> {}", (Object)this.heartbeatInterval);
        this.logger.info("Worker config: hostWeight -> {}", (Object)this.hostWeight);
        this.logger.info("Worker config: tenantAutoCreate -> {}", (Object)this.tenantAutoCreate);
        this.logger.info("Worker config: tenantDistributedUser -> {}", (Object)this.tenantDistributedUser);
        this.logger.info("Worker config: maxCpuLoadAvg -> {}", (Object)this.maxCpuLoadAvg);
        this.logger.info("Worker config: reservedMemory -> {}", (Object)this.reservedMemory);
        this.logger.info("Worker config: alertListenHost -> {}", (Object)this.alertListenHost);
        this.logger.info("Worker config: alertListenPort -> {}", (Object)this.alertListenPort);
        this.logger.info("Worker config: registryDisconnectStrategy -> {}", (Object)this.registryDisconnectStrategy);
        this.logger.info("Worker config: workerAddress -> {}", (Object)this.registryDisconnectStrategy);
        this.logger.info("Worker config: workerRegistryPath: {}", (Object)this.workerRegistryPath);
        this.logger.info("Worker config: taskExecuteThreadsFullPolicy: {}", (Object)this.taskExecuteThreadsFullPolicy);
    }

    @Generated
    public WorkerConfig() {
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public int getListenPort() {
        return this.listenPort;
    }

    @Generated
    public int getExecThreads() {
        return this.execThreads;
    }

    @Generated
    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Generated
    public int getHostWeight() {
        return this.hostWeight;
    }

    @Generated
    public boolean isTenantAutoCreate() {
        return this.tenantAutoCreate;
    }

    @Generated
    public boolean isTenantDistributedUser() {
        return this.tenantDistributedUser;
    }

    @Generated
    public int getMaxCpuLoadAvg() {
        return this.maxCpuLoadAvg;
    }

    @Generated
    public double getReservedMemory() {
        return this.reservedMemory;
    }

    @Generated
    public String getAlertListenHost() {
        return this.alertListenHost;
    }

    @Generated
    public int getAlertListenPort() {
        return this.alertListenPort;
    }

    @Generated
    public ConnectStrategyProperties getRegistryDisconnectStrategy() {
        return this.registryDisconnectStrategy;
    }

    @Generated
    public String getWorkerAddress() {
        return this.workerAddress;
    }

    @Generated
    public String getWorkerRegistryPath() {
        return this.workerRegistryPath;
    }

    @Generated
    public TaskExecuteThreadsFullPolicy getTaskExecuteThreadsFullPolicy() {
        return this.taskExecuteThreadsFullPolicy;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Generated
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @Generated
    public void setExecThreads(int execThreads) {
        this.execThreads = execThreads;
    }

    @Generated
    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    @Generated
    public void setHostWeight(int hostWeight) {
        this.hostWeight = hostWeight;
    }

    @Generated
    public void setTenantAutoCreate(boolean tenantAutoCreate) {
        this.tenantAutoCreate = tenantAutoCreate;
    }

    @Generated
    public void setTenantDistributedUser(boolean tenantDistributedUser) {
        this.tenantDistributedUser = tenantDistributedUser;
    }

    @Generated
    public void setMaxCpuLoadAvg(int maxCpuLoadAvg) {
        this.maxCpuLoadAvg = maxCpuLoadAvg;
    }

    @Generated
    public void setReservedMemory(double reservedMemory) {
        this.reservedMemory = reservedMemory;
    }

    @Generated
    public void setAlertListenHost(String alertListenHost) {
        this.alertListenHost = alertListenHost;
    }

    @Generated
    public void setAlertListenPort(int alertListenPort) {
        this.alertListenPort = alertListenPort;
    }

    @Generated
    public void setRegistryDisconnectStrategy(ConnectStrategyProperties registryDisconnectStrategy) {
        this.registryDisconnectStrategy = registryDisconnectStrategy;
    }

    @Generated
    public void setWorkerAddress(String workerAddress) {
        this.workerAddress = workerAddress;
    }

    @Generated
    public void setWorkerRegistryPath(String workerRegistryPath) {
        this.workerRegistryPath = workerRegistryPath;
    }

    @Generated
    public void setTaskExecuteThreadsFullPolicy(TaskExecuteThreadsFullPolicy taskExecuteThreadsFullPolicy) {
        this.taskExecuteThreadsFullPolicy = taskExecuteThreadsFullPolicy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerConfig)) {
            return false;
        }
        WorkerConfig other = (WorkerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getListenPort() != other.getListenPort()) {
            return false;
        }
        if (this.getExecThreads() != other.getExecThreads()) {
            return false;
        }
        if (this.getHostWeight() != other.getHostWeight()) {
            return false;
        }
        if (this.isTenantAutoCreate() != other.isTenantAutoCreate()) {
            return false;
        }
        if (this.isTenantDistributedUser() != other.isTenantDistributedUser()) {
            return false;
        }
        if (this.getMaxCpuLoadAvg() != other.getMaxCpuLoadAvg()) {
            return false;
        }
        if (Double.compare(this.getReservedMemory(), other.getReservedMemory()) != 0) {
            return false;
        }
        if (this.getAlertListenPort() != other.getAlertListenPort()) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        Duration this$heartbeatInterval = this.getHeartbeatInterval();
        Duration other$heartbeatInterval = other.getHeartbeatInterval();
        if (this$heartbeatInterval == null ? other$heartbeatInterval != null : !((Object)this$heartbeatInterval).equals(other$heartbeatInterval)) {
            return false;
        }
        String this$alertListenHost = this.getAlertListenHost();
        String other$alertListenHost = other.getAlertListenHost();
        if (this$alertListenHost == null ? other$alertListenHost != null : !this$alertListenHost.equals(other$alertListenHost)) {
            return false;
        }
        ConnectStrategyProperties this$registryDisconnectStrategy = this.getRegistryDisconnectStrategy();
        ConnectStrategyProperties other$registryDisconnectStrategy = other.getRegistryDisconnectStrategy();
        if (this$registryDisconnectStrategy == null ? other$registryDisconnectStrategy != null : !this$registryDisconnectStrategy.equals(other$registryDisconnectStrategy)) {
            return false;
        }
        String this$workerAddress = this.getWorkerAddress();
        String other$workerAddress = other.getWorkerAddress();
        if (this$workerAddress == null ? other$workerAddress != null : !this$workerAddress.equals(other$workerAddress)) {
            return false;
        }
        String this$workerRegistryPath = this.getWorkerRegistryPath();
        String other$workerRegistryPath = other.getWorkerRegistryPath();
        if (this$workerRegistryPath == null ? other$workerRegistryPath != null : !this$workerRegistryPath.equals(other$workerRegistryPath)) {
            return false;
        }
        TaskExecuteThreadsFullPolicy this$taskExecuteThreadsFullPolicy = this.getTaskExecuteThreadsFullPolicy();
        TaskExecuteThreadsFullPolicy other$taskExecuteThreadsFullPolicy = other.getTaskExecuteThreadsFullPolicy();
        return !(this$taskExecuteThreadsFullPolicy == null ? other$taskExecuteThreadsFullPolicy != null : !((Object)((Object)this$taskExecuteThreadsFullPolicy)).equals((Object)other$taskExecuteThreadsFullPolicy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkerConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getListenPort();
        result = result * 59 + this.getExecThreads();
        result = result * 59 + this.getHostWeight();
        result = result * 59 + (this.isTenantAutoCreate() ? 79 : 97);
        result = result * 59 + (this.isTenantDistributedUser() ? 79 : 97);
        result = result * 59 + this.getMaxCpuLoadAvg();
        long $reservedMemory = Double.doubleToLongBits(this.getReservedMemory());
        result = result * 59 + (int)($reservedMemory >>> 32 ^ $reservedMemory);
        result = result * 59 + this.getAlertListenPort();
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        Duration $heartbeatInterval = this.getHeartbeatInterval();
        result = result * 59 + ($heartbeatInterval == null ? 43 : ((Object)$heartbeatInterval).hashCode());
        String $alertListenHost = this.getAlertListenHost();
        result = result * 59 + ($alertListenHost == null ? 43 : $alertListenHost.hashCode());
        ConnectStrategyProperties $registryDisconnectStrategy = this.getRegistryDisconnectStrategy();
        result = result * 59 + ($registryDisconnectStrategy == null ? 43 : $registryDisconnectStrategy.hashCode());
        String $workerAddress = this.getWorkerAddress();
        result = result * 59 + ($workerAddress == null ? 43 : $workerAddress.hashCode());
        String $workerRegistryPath = this.getWorkerRegistryPath();
        result = result * 59 + ($workerRegistryPath == null ? 43 : $workerRegistryPath.hashCode());
        TaskExecuteThreadsFullPolicy $taskExecuteThreadsFullPolicy = this.getTaskExecuteThreadsFullPolicy();
        result = result * 59 + ($taskExecuteThreadsFullPolicy == null ? 43 : ((Object)((Object)$taskExecuteThreadsFullPolicy)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkerConfig(logger=" + this.getLogger() + ", listenPort=" + this.getListenPort() + ", execThreads=" + this.getExecThreads() + ", heartbeatInterval=" + this.getHeartbeatInterval() + ", hostWeight=" + this.getHostWeight() + ", tenantAutoCreate=" + this.isTenantAutoCreate() + ", tenantDistributedUser=" + this.isTenantDistributedUser() + ", maxCpuLoadAvg=" + this.getMaxCpuLoadAvg() + ", reservedMemory=" + this.getReservedMemory() + ", alertListenHost=" + this.getAlertListenHost() + ", alertListenPort=" + this.getAlertListenPort() + ", registryDisconnectStrategy=" + this.getRegistryDisconnectStrategy() + ", workerAddress=" + this.getWorkerAddress() + ", workerRegistryPath=" + this.getWorkerRegistryPath() + ", taskExecuteThreadsFullPolicy=" + (Object)((Object)this.getTaskExecuteThreadsFullPolicy()) + ")";
    }
}

