/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.message;

import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteRunningCommand;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.message.MessageSender;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteRunningMessageSender
implements MessageSender<TaskExecuteRunningCommand> {
    @Autowired
    private WorkerRpcClient workerRpcClient;
    @Autowired
    private WorkerConfig workerConfig;

    @Override
    public void sendMessage(TaskExecuteRunningCommand message) throws RemotingException {
        this.workerRpcClient.send(Host.of((String)message.getMessageReceiverAddress()), message.convert2Command());
    }

    @Override
    public TaskExecuteRunningCommand buildMessage(@NonNull TaskExecutionContext taskExecutionContext, @NonNull String messageReceiverAddress) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        if (messageReceiverAddress == null) {
            throw new NullPointerException("messageReceiverAddress is marked non-null but is null");
        }
        TaskExecuteRunningCommand taskExecuteRunningMessage = new TaskExecuteRunningCommand(this.workerConfig.getWorkerAddress(), messageReceiverAddress, System.currentTimeMillis());
        taskExecuteRunningMessage.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        taskExecuteRunningMessage.setProcessInstanceId(taskExecutionContext.getProcessInstanceId());
        taskExecuteRunningMessage.setStatus(taskExecutionContext.getCurrentExecutionStatus());
        taskExecuteRunningMessage.setLogPath(taskExecutionContext.getLogPath());
        taskExecuteRunningMessage.setHost(taskExecutionContext.getHost());
        taskExecuteRunningMessage.setStartTime(taskExecutionContext.getStartTime());
        taskExecuteRunningMessage.setExecutePath(taskExecutionContext.getExecutePath());
        taskExecuteRunningMessage.setAppIds(taskExecutionContext.getAppIds());
        return taskExecuteRunningMessage;
    }

    @Override
    public CommandType getMessageType() {
        return CommandType.TASK_EXECUTE_RUNNING;
    }
}

