/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteAckCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteResultAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteResultAckProcessor.class);
    @Autowired
    private MessageRetryRunner messageRetryRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_RESULT_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteAckCommand taskExecuteAckMessage = (TaskExecuteAckCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskExecuteAckCommand.class);
        if (taskExecuteAckMessage == null) {
            this.logger.error("task execute response ack command is null");
            return;
        }
        try {
            LoggerUtils.setTaskInstanceIdMDC((Integer)taskExecuteAckMessage.getTaskInstanceId());
            this.logger.info("Receive task execute response ack command : {}", (Object)taskExecuteAckMessage);
            if (taskExecuteAckMessage.isSuccess()) {
                this.messageRetryRunner.removeRetryMessage(taskExecuteAckMessage.getTaskInstanceId(), CommandType.TASK_EXECUTE_RESULT);
                this.logger.debug("remove REMOTE_CHANNELS, task instance id:{}", (Object)taskExecuteAckMessage.getTaskInstanceId());
            } else {
                this.logger.error("Receive task execute result ack message, the message status is not success, message: {}", (Object)taskExecuteAckMessage);
            }
        }
        finally {
            LoggerUtils.removeTaskInstanceIdMDC();
        }
    }
}

