/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskRejectAckCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskRejectAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskRejectAckProcessor.class);
    @Autowired
    private MessageRetryRunner messageRetryRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_REJECT_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskRejectAckCommand taskRejectAckMessage = (TaskRejectAckCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskRejectAckCommand.class);
        if (taskRejectAckMessage == null) {
            this.logger.error("Receive task reject response, the response message is null");
            return;
        }
        try {
            LoggerUtils.setTaskInstanceIdMDC((Integer)taskRejectAckMessage.getTaskInstanceId());
            this.logger.info("Receive task reject response ack command: {}", (Object)taskRejectAckMessage);
            if (taskRejectAckMessage.isSuccess()) {
                this.messageRetryRunner.removeRetryMessage(taskRejectAckMessage.getTaskInstanceId(), CommandType.TASK_REJECT);
                this.logger.debug("removeRecallCache: task instance id:{}", (Object)taskRejectAckMessage.getTaskInstanceId());
            } else {
                this.logger.error("Receive task reject ack message, the message status is not success, message: {}", (Object)taskRejectAckMessage);
            }
        }
        finally {
            LoggerUtils.removeTaskInstanceIdMDC();
        }
    }
}

