/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import java.io.IOException;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.registry.WorkerConnectStrategy;
import org.apache.dolphinscheduler.server.worker.registry.WorkerConnectionStateListener;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.server.worker.task.WorkerHeartBeatTask;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkerRegistryClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerRegistryClient.class);
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private WorkerManagerThread workerManagerThread;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private WorkerConnectStrategy workerConnectStrategy;
    private WorkerHeartBeatTask workerHeartBeatTask;

    @PostConstruct
    public void initWorkRegistry() {
        this.workerHeartBeatTask = new WorkerHeartBeatTask(this.workerConfig, this.registryClient, () -> this.workerManagerThread.getWaitSubmitQueueSize());
    }

    public void start() {
        try {
            this.registry();
            this.registryClient.addConnectionStateListener((ConnectionListener)new WorkerConnectionStateListener(this.workerConfig, this.registryClient, this.workerConnectStrategy));
        }
        catch (Exception ex) {
            throw new RegistryException("Worker registry client start up error", (Throwable)ex);
        }
    }

    private void registry() {
        WorkerHeartBeat workerHeartBeat = this.workerHeartBeatTask.getHeartBeat();
        String workerZKPath = this.workerConfig.getWorkerRegistryPath();
        this.registryClient.remove(workerZKPath);
        this.registryClient.persistEphemeral(workerZKPath, JSONUtils.toJsonString((Object)workerHeartBeat));
        log.info("Worker node: {} registry to ZK {} successfully", (Object)this.workerConfig.getWorkerAddress(), (Object)workerZKPath);
        while (!this.registryClient.checkNodeExists(this.workerConfig.getWorkerAddress(), NodeType.WORKER)) {
            ThreadUtils.sleep((long)1000L);
        }
        ThreadUtils.sleep((long)1000L);
        this.workerHeartBeatTask.start();
        log.info("Worker node: {} registry finished", (Object)this.workerConfig.getWorkerAddress());
    }

    public void setRegistryStoppable(IStoppable stoppable) {
        this.registryClient.setStoppable(stoppable);
    }

    @Override
    public void close() throws IOException {
        if (this.workerHeartBeatTask != null) {
            this.workerHeartBeatTask.shutdown();
        }
        this.registryClient.close();
        log.info("Worker registry client closed");
    }
}

