/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.rpc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.remote.command.BaseCommand;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.message.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkerMessageSender {
    private final Logger logger = LoggerFactory.getLogger(WorkerMessageSender.class);
    @Autowired
    private MessageRetryRunner messageRetryRunner;
    @Autowired
    private List<MessageSender> messageSenders;
    private Map<CommandType, MessageSender> messageSenderMap = new HashMap<CommandType, MessageSender>();

    @PostConstruct
    public void init() {
        this.messageSenders.forEach(messageSender -> this.messageSenderMap.put(messageSender.getMessageType(), (MessageSender)messageSender));
    }

    public void sendMessageWithRetry(@NonNull TaskExecutionContext taskExecutionContext, @NonNull String messageReceiverAddress, @NonNull CommandType messageType) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        if (messageReceiverAddress == null) {
            throw new NullPointerException("messageReceiverAddress is marked non-null but is null");
        }
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        MessageSender messageSender = this.messageSenderMap.get(messageType);
        if (messageSender == null) {
            throw new IllegalArgumentException("The messageType is invalidated, messageType: " + messageType);
        }
        Object baseCommand = messageSender.buildMessage(taskExecutionContext, messageReceiverAddress);
        try {
            this.messageRetryRunner.addRetryMessage(taskExecutionContext.getTaskInstanceId(), messageType, (BaseCommand)baseCommand);
            messageSender.sendMessage(baseCommand);
        }
        catch (RemotingException e) {
            this.logger.error("Send message error, messageType: {}, message: {}", (Object)messageType, baseCommand);
        }
    }

    public void sendMessage(@NonNull TaskExecutionContext taskExecutionContext, @NonNull String messageReceiverAddress, @NonNull CommandType messageType) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        if (messageReceiverAddress == null) {
            throw new NullPointerException("messageReceiverAddress is marked non-null but is null");
        }
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        MessageSender messageSender = this.messageSenderMap.get(messageType);
        if (messageSender == null) {
            throw new IllegalArgumentException("The messageType is invalidated, messageType: " + messageType);
        }
        Object baseCommand = messageSender.buildMessage(taskExecutionContext, messageReceiverAddress);
        try {
            messageSender.sendMessage(baseCommand);
        }
        catch (RemotingException e) {
            this.logger.error("Send message error, messageType: {}, message: {}", (Object)messageType, baseCommand);
        }
    }
}

