/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.rpc;

import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyClientConfig;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteResultAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteRunningAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskRejectAckProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkerRpcClient
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(WorkerRpcClient.class);
    @Autowired
    private TaskExecuteRunningAckProcessor taskExecuteRunningAckProcessor;
    @Autowired
    private TaskExecuteResultAckProcessor taskExecuteResultAckProcessor;
    @Autowired
    private TaskRejectAckProcessor taskRejectAckProcessor;
    private NettyRemotingClient nettyRemotingClient;

    public void start() {
        this.logger.info("Worker rpc client starting");
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        this.nettyRemotingClient = new NettyRemotingClient(nettyClientConfig);
        this.nettyRemotingClient.registerProcessor(CommandType.TASK_EXECUTE_RUNNING_ACK, (NettyRequestProcessor)this.taskExecuteRunningAckProcessor);
        this.nettyRemotingClient.registerProcessor(CommandType.TASK_EXECUTE_RESULT_ACK, (NettyRequestProcessor)this.taskExecuteResultAckProcessor);
        this.nettyRemotingClient.registerProcessor(CommandType.TASK_REJECT_ACK, (NettyRequestProcessor)this.taskRejectAckProcessor);
        this.logger.info("Worker rpc client started");
    }

    public void send(Host host, Command command) throws RemotingException {
        this.nettyRemotingClient.send(host, command);
    }

    @Override
    public void close() {
        this.logger.info("Worker rpc client closing");
        this.nettyRemotingClient.close();
        this.logger.info("Worker rpc client closed");
    }
}

