/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import java.util.Date;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerMessageSender;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecuteRunnable;
import org.apache.dolphinscheduler.service.alert.AlertClientService;
import org.apache.dolphinscheduler.service.storage.StorageOperate;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;

public abstract class WorkerDelayTaskExecuteRunnable
extends WorkerTaskExecuteRunnable
implements Delayed {
    protected WorkerDelayTaskExecuteRunnable(@NonNull TaskExecutionContext taskExecutionContext, @NonNull WorkerConfig workerConfig, @NonNull String masterAddress, @NonNull WorkerMessageSender workerMessageSender, @NonNull AlertClientService alertClientService, @NonNull TaskPluginManager taskPluginManager, @Nullable StorageOperate storageOperate) {
        super(taskExecutionContext, workerConfig, masterAddress, workerMessageSender, alertClientService, taskPluginManager, storageOperate);
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        if (workerConfig == null) {
            throw new NullPointerException("workerConfig is marked non-null but is null");
        }
        if (masterAddress == null) {
            throw new NullPointerException("masterAddress is marked non-null but is null");
        }
        if (workerMessageSender == null) {
            throw new NullPointerException("workerMessageSender is marked non-null but is null");
        }
        if (alertClientService == null) {
            throw new NullPointerException("alertClientService is marked non-null but is null");
        }
        if (taskPluginManager == null) {
            throw new NullPointerException("taskPluginManager is marked non-null but is null");
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        TaskExecutionContext taskExecutionContext = this.getTaskExecutionContext();
        return unit.convert(DateUtils.getRemainTime((Date)taskExecutionContext.getFirstSubmitTime(), (long)((long)taskExecutionContext.getDelayTime() * 60L)), TimeUnit.SECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == null) {
            return 1;
        }
        return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
    }
}

