/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dolphinscheduler.server.worker.metrics.WorkerServerMetrics;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerExecService {
    private static final Logger logger = LoggerFactory.getLogger(WorkerExecService.class);
    private final ListeningExecutorService listeningExecutorService;
    private final ExecutorService execService;
    private final ConcurrentHashMap<Integer, WorkerTaskExecuteRunnable> taskExecuteThreadMap;

    public WorkerExecService(ExecutorService execService, ConcurrentHashMap<Integer, WorkerTaskExecuteRunnable> taskExecuteThreadMap) {
        this.execService = execService;
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)this.execService);
        this.taskExecuteThreadMap = taskExecuteThreadMap;
        WorkerServerMetrics.registerWorkerRunningTaskGauge(taskExecuteThreadMap::size);
    }

    public void submit(final WorkerTaskExecuteRunnable taskExecuteThread) {
        this.taskExecuteThreadMap.put(taskExecuteThread.getTaskExecutionContext().getTaskInstanceId(), taskExecuteThread);
        ListenableFuture future = this.listeningExecutorService.submit((Runnable)taskExecuteThread);
        FutureCallback futureCallback = new FutureCallback(){

            public void onSuccess(Object o) {
                WorkerExecService.this.taskExecuteThreadMap.remove(taskExecuteThread.getTaskExecutionContext().getTaskInstanceId());
            }

            public void onFailure(Throwable throwable) {
                logger.error("task execute failed, processInstanceId:{}, taskInstanceId:{}", new Object[]{taskExecuteThread.getTaskExecutionContext().getProcessInstanceId(), taskExecuteThread.getTaskExecutionContext().getTaskInstanceId(), throwable});
                WorkerExecService.this.taskExecuteThreadMap.remove(taskExecuteThread.getTaskExecutionContext().getTaskInstanceId());
            }
        };
        Futures.addCallback((ListenableFuture)future, (FutureCallback)futureCallback, (Executor)this.listeningExecutorService);
    }

    public int getThreadPoolQueueSize() {
        return ((ThreadPoolExecutor)this.execService).getQueue().size();
    }

    public Map<Integer, WorkerTaskExecuteRunnable> getTaskExecuteThreadMap() {
        return this.taskExecuteThreadMap;
    }
}

