/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.loadbalance;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcStatus;
import org.apache.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;

public class LeastActiveLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "leastactive";

    @Override
    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        int length = invokers.size();
        int leastActive = -1;
        int leastCount = 0;
        int[] leastIndexes = new int[length];
        int[] weights = new int[length];
        int totalWeight = 0;
        int firstWeight = 0;
        boolean sameWeight = true;
        for (int i = 0; i < length; ++i) {
            int afterWarmup;
            Invoker<T> invoker = invokers.get(i);
            int active = RpcStatus.getStatus((URL)invoker.getUrl(), (String)invocation.getMethodName()).getActive();
            weights[i] = afterWarmup = this.getWeight(invoker, invocation);
            if (leastActive == -1 || active < leastActive) {
                leastActive = active;
                leastCount = 1;
                leastIndexes[0] = i;
                totalWeight = afterWarmup;
                firstWeight = afterWarmup;
                sameWeight = true;
                continue;
            }
            if (active != leastActive) continue;
            leastIndexes[leastCount++] = i;
            totalWeight += afterWarmup;
            if (!sameWeight || afterWarmup == firstWeight) continue;
            sameWeight = false;
        }
        if (leastCount == 1) {
            return invokers.get(leastIndexes[0]);
        }
        if (!sameWeight && totalWeight > 0) {
            int offsetWeight = ThreadLocalRandom.current().nextInt(totalWeight);
            for (int i = 0; i < leastCount; ++i) {
                int leastIndex = leastIndexes[i];
                if ((offsetWeight -= weights[leastIndex]) >= 0) continue;
                return invokers.get(leastIndex);
            }
        }
        return invokers.get(leastIndexes[ThreadLocalRandom.current().nextInt(leastCount)]);
    }
}

