/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.SingleRouterChain;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotSwitcher;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterFactory;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class RouterChain<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RouterChain.class);
    private volatile SingleRouterChain<T> mainChain;
    private volatile SingleRouterChain<T> backupChain;
    private volatile SingleRouterChain<T> currentChain;
    private final AtomicReference<BitList<Invoker<T>>> notifyingInvokers = new AtomicReference();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static <T> RouterChain<T> buildChain(Class<T> interfaceClass, URL url) {
        SingleRouterChain<T> chain1 = RouterChain.buildSingleChain(interfaceClass, url);
        SingleRouterChain<T> chain2 = RouterChain.buildSingleChain(interfaceClass, url);
        return new RouterChain<T>(new SingleRouterChain[]{chain1, chain2});
    }

    public static <T> SingleRouterChain<T> buildSingleChain(Class<T> interfaceClass, URL url) {
        ModuleModel moduleModel = url.getOrDefaultModuleModel();
        List extensionFactories = moduleModel.getExtensionLoader(RouterFactory.class).getActivateExtension(url, "router");
        List<Router> routers = extensionFactories.stream().map(factory -> factory.getRouter(url)).sorted(Router::compareTo).collect(Collectors.toList());
        List stateRouters = moduleModel.getExtensionLoader(StateRouterFactory.class).getActivateExtension(url, "router").stream().map(factory -> factory.getRouter(interfaceClass, url)).collect(Collectors.toList());
        boolean shouldFailFast = Boolean.parseBoolean(ConfigurationUtils.getProperty((ScopeModel)moduleModel, (String)"dubbo.router.should-fail-fast", (String)"true"));
        RouterSnapshotSwitcher routerSnapshotSwitcher = (RouterSnapshotSwitcher)ScopeModelUtil.getFrameworkModel((ScopeModel)moduleModel).getBeanFactory().getBean(RouterSnapshotSwitcher.class);
        return new SingleRouterChain(routers, stateRouters, shouldFailFast, routerSnapshotSwitcher);
    }

    public RouterChain(SingleRouterChain<T>[] chains) {
        if (chains.length != 2) {
            throw new IllegalArgumentException("chains' size should be 2.");
        }
        this.mainChain = chains[0];
        this.backupChain = chains[1];
        this.currentChain = this.mainChain;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public SingleRouterChain<T> getSingleChain(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        BitList<Invoker<T>> notifying = this.notifyingInvokers.get();
        if (notifying != null && this.currentChain == this.backupChain && availableInvokers.getOriginList() == notifying.getOriginList()) {
            return this.mainChain;
        }
        return this.currentChain;
    }

    @Deprecated
    public List<Invoker<T>> route(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        return this.getSingleChain(url, availableInvokers, invocation).route(url, availableInvokers, invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInvokers(BitList<Invoker<T>> invokers, Runnable switchAction) {
        try {
            this.lock.writeLock().lock();
            this.currentChain = this.backupChain;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        try {
            this.mainChain.getLock().writeLock().lock();
            this.mainChain.setInvokers(invokers);
        }
        catch (Throwable t) {
            logger.error("99-0", "", "", "Error occurred when refreshing router chain.", t);
            throw t;
        }
        finally {
            this.mainChain.getLock().writeLock().unlock();
        }
        this.notifyingInvokers.set(invokers);
        switchAction.run();
        try {
            this.lock.writeLock().lock();
            this.currentChain = this.mainChain;
            this.notifyingInvokers.set(null);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        try {
            this.backupChain.getLock().writeLock().lock();
            this.backupChain.setInvokers(invokers);
        }
        catch (Throwable t) {
            logger.error("99-0", "", "", "Error occurred when refreshing router chain.", t);
            throw t;
        }
        finally {
            this.backupChain.getLock().writeLock().unlock();
        }
    }

    public synchronized void destroy() {
        this.backupChain.destroy();
        this.lock.writeLock().lock();
        this.currentChain = this.backupChain;
        this.lock.writeLock().unlock();
        this.mainChain.destroy();
    }

    public void addRouters(List<Router> routers) {
        this.mainChain.addRouters(routers);
        this.backupChain.addRouters(routers);
    }

    public SingleRouterChain<T> getCurrentChain() {
        return this.currentChain;
    }

    public List<Router> getRouters() {
        return this.currentChain.getRouters();
    }

    public StateRouter<T> getHeadStateRouter() {
        return this.currentChain.getHeadStateRouter();
    }

    @Deprecated
    public List<StateRouter<T>> getStateRouters() {
        return this.currentChain.getStateRouters();
    }
}

