/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.directory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.dubbo.common.Node;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.SingleRouterChain;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public abstract class AbstractDirectory<T>
implements Directory<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractDirectory.class);
    private final URL url;
    private volatile boolean destroyed = false;
    protected volatile URL consumerUrl;
    protected RouterChain<T> routerChain;
    protected final Map<String, String> queryMap;
    private volatile boolean invokersInitialized = false;
    private volatile BitList<Invoker<T>> invokers = BitList.emptyList();
    private volatile BitList<Invoker<T>> validInvokers = BitList.emptyList();
    protected volatile List<Invoker<T>> invokersToReconnect = new CopyOnWriteArrayList<Invoker<T>>();
    protected final Set<Invoker<T>> disabledInvokers = new ConcurrentHashSet();
    private final Semaphore checkConnectivityPermit = new Semaphore(1);
    private final ScheduledExecutorService connectivityExecutor;
    private volatile ScheduledFuture<?> connectivityCheckFuture;
    private final int reconnectTaskTryCount;
    private final int reconnectTaskPeriod;
    private ApplicationModel applicationModel;

    public AbstractDirectory(URL url) {
        this(url, null, false);
    }

    public AbstractDirectory(URL url, boolean isUrlFromRegistry) {
        this(url, null, isUrlFromRegistry);
    }

    public AbstractDirectory(URL url, RouterChain<T> routerChain, boolean isUrlFromRegistry) {
        Map queryMap;
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = url.removeAttribute("refer").removeAttribute("monitor");
        Object referParams = url.getAttribute("refer");
        if (referParams instanceof Map) {
            queryMap = (Map)referParams;
            this.consumerUrl = (URL)url.getAttribute("CONSUMER_URL");
        } else {
            queryMap = StringUtils.parseQueryString((String)url.getParameterAndDecoded("refer"));
        }
        this.applicationModel = url.getOrDefaultApplicationModel();
        this.queryMap = ((ClusterUtils)this.applicationModel.getBeanFactory().getBean(ClusterUtils.class)).mergeLocalParams(queryMap);
        if (this.consumerUrl == null) {
            String host = StringUtils.isNotEmpty((String)((String)queryMap.get("register.ip"))) ? (String)queryMap.get("register.ip") : this.url.getHost();
            String path = StringUtils.isNotEmpty((String)((String)queryMap.get("path"))) ? (String)queryMap.get("path") : (String)queryMap.get("interface");
            String consumedProtocol = StringUtils.isNotEmpty((String)((String)queryMap.get("protocol"))) ? (String)queryMap.get("protocol") : "consumer";
            URL consumerUrlFrom = this.url.setHost(host).setPort(0).setProtocol(consumedProtocol).setPath(path);
            if (isUrlFromRegistry) {
                consumerUrlFrom = consumerUrlFrom.clearParameters();
            }
            this.consumerUrl = consumerUrlFrom.addParameters(queryMap);
        }
        this.connectivityExecutor = ((FrameworkExecutorRepository)this.applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getConnectivityScheduledExecutor();
        Configuration configuration = ConfigurationUtils.getGlobalConfiguration((ScopeModel)url.getOrDefaultModuleModel());
        this.reconnectTaskTryCount = configuration.getInt("dubbo.reconnect.reconnectTaskTryCount", 10);
        this.reconnectTaskPeriod = configuration.getInt("dubbo.reconnect.reconnectTaskPeriod", 1000);
        this.setRouterChain(routerChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Invoker<T>> list(Invocation invocation) throws RpcException {
        if (this.destroyed) {
            throw new RpcException("Directory of type " + this.getClass().getSimpleName() + " already destroyed for service " + this.getConsumerUrl().getServiceKey() + " from registry " + this.getUrl());
        }
        SingleRouterChain<T> singleChain = null;
        try {
            Object availableInvokers;
            try {
                if (this.routerChain != null) {
                    this.routerChain.getLock().readLock().lock();
                }
                availableInvokers = this.invokersInitialized ? this.validInvokers.clone() : this.invokers.clone();
                if (this.routerChain != null) {
                    singleChain = this.routerChain.getSingleChain(this.getConsumerUrl(), (BitList<Invoker<T>>)availableInvokers, invocation);
                    singleChain.getLock().readLock().lock();
                }
            }
            finally {
                if (this.routerChain != null) {
                    this.routerChain.getLock().readLock().unlock();
                }
            }
            List<Invoker<T>> routedResult = this.doList(singleChain, (BitList<Invoker<T>>)availableInvokers, invocation);
            if (routedResult.isEmpty()) {
                logger.warn("2-2", "provider server or registry center crashed", "", "No provider available after connectivity filter for the service " + this.getConsumerUrl().getServiceKey() + " All validInvokers' size: " + this.validInvokers.size() + " All routed invokers' size: " + routedResult.size() + " All invokers' size: " + this.invokers.size() + " from registry " + this.getUrl().getAddress() + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ".");
            }
            List<Invoker<T>> list = Collections.unmodifiableList(routedResult);
            return list;
        }
        finally {
            if (singleChain != null) {
                singleChain.getLock().readLock().unlock();
            }
        }
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public RouterChain<T> getRouterChain() {
        return this.routerChain;
    }

    public void setRouterChain(RouterChain<T> routerChain) {
        this.routerChain = routerChain;
    }

    protected void addRouters(List<Router> routers) {
        routers = routers == null ? Collections.emptyList() : routers;
        this.routerChain.addRouters(routers);
    }

    @Override
    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    public void setConsumerUrl(URL consumerUrl) {
        this.consumerUrl = consumerUrl;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        this.destroyed = true;
        this.destroyInvokers();
        this.invokersToReconnect.clear();
        this.disabledInvokers.clear();
    }

    @Override
    public void discordAddresses() {
    }

    @Override
    public void addInvalidateInvoker(Invoker<T> invoker) {
        if (this.removeValidInvoker(invoker)) {
            this.invokersToReconnect.add(invoker);
            this.checkConnectivity();
            logger.info("The invoker " + invoker.getUrl() + " has been added to invalidate list due to connectivity problem. Will trying to reconnect to it in the background.");
        }
    }

    public void checkConnectivity() {
        if (this.checkConnectivityPermit.tryAcquire()) {
            this.connectivityCheckFuture = this.connectivityExecutor.schedule(() -> {
                try {
                    if (this.isDestroyed()) {
                        return;
                    }
                    RpcContext.getServiceContext().setConsumerUrl(this.getConsumerUrl());
                    ArrayList<Invoker> needDeleteList = new ArrayList<Invoker>();
                    ArrayList<Invoker<T>> invokersToTry = new ArrayList<Invoker<T>>();
                    if (this.invokersToReconnect.size() < this.reconnectTaskTryCount) {
                        invokersToTry.addAll(this.invokersToReconnect);
                    } else {
                        for (int i = 0; i < this.reconnectTaskTryCount; ++i) {
                            Invoker<T> invoker = this.invokersToReconnect.get(ThreadLocalRandom.current().nextInt(this.invokersToReconnect.size()));
                            if (invokersToTry.contains(invoker)) continue;
                            invokersToTry.add(invoker);
                        }
                    }
                    for (Invoker invoker : invokersToTry) {
                        if (this.invokers.contains(invoker)) {
                            if (!invoker.isAvailable()) continue;
                            needDeleteList.add(invoker);
                            continue;
                        }
                        needDeleteList.add(invoker);
                    }
                    for (Invoker invoker : needDeleteList) {
                        if (this.invokers.contains(invoker)) {
                            this.addValidInvoker(invoker);
                            logger.info("Recover service address: " + invoker.getUrl() + "  from invalid list.");
                        }
                        this.invokersToReconnect.remove(invoker);
                    }
                }
                finally {
                    this.checkConnectivityPermit.release();
                }
                if (!this.invokersToReconnect.isEmpty()) {
                    this.checkConnectivity();
                }
            }, (long)this.reconnectTaskPeriod, TimeUnit.MILLISECONDS);
        }
        MetricsEventBus.publish((MetricsEvent)RegistryEvent.refreshDirectoryEvent((ApplicationModel)this.applicationModel, this.getSummary()));
    }

    public void refreshInvoker() {
        if (this.invokersInitialized) {
            this.refreshInvokerInternal();
        }
        MetricsEventBus.publish((MetricsEvent)RegistryEvent.refreshDirectoryEvent((ApplicationModel)this.applicationModel, this.getSummary()));
    }

    private synchronized void refreshInvokerInternal() {
        Object copiedInvokers = this.invokers.clone();
        this.refreshInvokers((BitList<Invoker<T>>)copiedInvokers, (Collection<Invoker<T>>)this.invokersToReconnect);
        this.refreshInvokers((BitList<Invoker<T>>)copiedInvokers, (Collection<Invoker<T>>)this.disabledInvokers);
        this.validInvokers = copiedInvokers;
    }

    private void refreshInvokers(BitList<Invoker<T>> targetInvokers, Collection<Invoker<T>> invokersToRemove) {
        LinkedList<Invoker<T>> needToRemove = new LinkedList<Invoker<T>>();
        for (Invoker<T> tInvoker : invokersToRemove) {
            if (targetInvokers.contains(tInvoker)) {
                targetInvokers.remove(tInvoker);
                continue;
            }
            needToRemove.add(tInvoker);
        }
        invokersToRemove.removeAll(needToRemove);
    }

    @Override
    public void addDisabledInvoker(Invoker<T> invoker) {
        if (this.invokers.contains(invoker)) {
            this.disabledInvokers.add(invoker);
            this.removeValidInvoker(invoker);
            logger.info("Disable service address: " + invoker.getUrl() + ".");
        }
        MetricsEventBus.publish((MetricsEvent)RegistryEvent.refreshDirectoryEvent((ApplicationModel)this.applicationModel, this.getSummary()));
    }

    @Override
    public void recoverDisabledInvoker(Invoker<T> invoker) {
        if (this.disabledInvokers.remove(invoker)) {
            try {
                this.addValidInvoker(invoker);
                logger.info("Recover service address: " + invoker.getUrl() + "  from disabled list.");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        MetricsEventBus.publish((MetricsEvent)RegistryEvent.refreshDirectoryEvent((ApplicationModel)this.applicationModel, this.getSummary()));
    }

    protected final void refreshRouter(BitList<Invoker<T>> newlyInvokers, Runnable switchAction) {
        try {
            this.routerChain.setInvokers((BitList<Invoker<T>>)newlyInvokers.clone(), switchAction);
        }
        catch (Throwable t) {
            logger.error("99-0", "", "", "Error occurred when refreshing router chain. The addresses from notification: " + newlyInvokers.stream().map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(", ")), t);
            throw t;
        }
    }

    @Deprecated
    public Semaphore getCheckConnectivityPermit() {
        return this.checkConnectivityPermit;
    }

    @Deprecated
    public ScheduledFuture<?> getConnectivityCheckFuture() {
        return this.connectivityCheckFuture;
    }

    public BitList<Invoker<T>> getInvokers() {
        return this.invokers.clone();
    }

    public BitList<Invoker<T>> getValidInvokers() {
        return this.validInvokers.clone();
    }

    public List<Invoker<T>> getInvokersToReconnect() {
        return this.invokersToReconnect;
    }

    public Set<Invoker<T>> getDisabledInvokers() {
        return this.disabledInvokers;
    }

    protected void setInvokers(BitList<Invoker<T>> invokers) {
        this.invokers = invokers;
        this.refreshInvokerInternal();
        this.invokersInitialized = true;
        MetricsEventBus.publish((MetricsEvent)RegistryEvent.refreshDirectoryEvent((ApplicationModel)this.applicationModel, this.getSummary()));
    }

    protected void destroyInvokers() {
        this.invokers = BitList.emptyList();
        this.validInvokers = BitList.emptyList();
        this.invokersInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addValidInvoker(Invoker<T> invoker) {
        BitList<Invoker<T>> bitList = this.validInvokers;
        synchronized (bitList) {
            return this.validInvokers.add(invoker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeValidInvoker(Invoker<T> invoker) {
        BitList<Invoker<T>> bitList = this.validInvokers;
        synchronized (bitList) {
            return this.validInvokers.remove(invoker);
        }
    }

    protected abstract List<Invoker<T>> doList(SingleRouterChain<T> var1, BitList<Invoker<T>> var2, Invocation var3) throws RpcException;

    protected String joinValidInvokerAddresses() {
        Object validInvokers = this.getValidInvokers().clone();
        if (((BitList)validInvokers).isEmpty()) {
            return "empty";
        }
        return validInvokers.stream().limit(5L).map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(","));
    }

    private Map<MetricsKey, Map<String, Integer>> getSummary() {
        HashMap<MetricsKey, Map<String, Integer>> summaryMap = new HashMap<MetricsKey, Map<String, Integer>>();
        summaryMap.put(MetricsKey.DIRECTORY_METRIC_NUM_VALID, this.groupByServiceKey(this.getValidInvokers()));
        summaryMap.put(MetricsKey.DIRECTORY_METRIC_NUM_DISABLE, this.groupByServiceKey(this.getDisabledInvokers()));
        summaryMap.put(MetricsKey.DIRECTORY_METRIC_NUM_TO_RECONNECT, this.groupByServiceKey(this.getInvokersToReconnect()));
        summaryMap.put(MetricsKey.DIRECTORY_METRIC_NUM_ALL, this.groupByServiceKey(this.getInvokers()));
        return summaryMap;
    }

    private Map<String, Integer> groupByServiceKey(Collection<Invoker<T>> invokers) {
        Map<String, Integer> serviceNumMap = new HashMap<String, Integer>();
        for (Invoker<T> invoker2 : invokers) {
            if (!invoker2.getClass().getSimpleName().contains("Mockito")) continue;
            return serviceNumMap;
        }
        if (invokers.size() > 0) {
            serviceNumMap = invokers.stream().filter(invoker -> invoker.getInterface() != null).collect(Collectors.groupingBy(invoker -> invoker.getInterface().getName(), Collectors.reducing(0, e -> 1, Integer::sum)));
        }
        return serviceNumMap;
    }
}

