/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.tag.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.router.AbstractRouterRule;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.tag.TagStateRouter;
import org.apache.dubbo.rpc.cluster.router.tag.model.ParamMatch;
import org.apache.dubbo.rpc.cluster.router.tag.model.Tag;

public class TagRouterRule
extends AbstractRouterRule {
    private List<Tag> tags;
    private final Map<String, Set<String>> addressToTagnames = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> tagnameToAddresses = new HashMap<String, Set<String>>();

    public static TagRouterRule parseFromMap(Map<String, Object> map) {
        TagRouterRule tagRouterRule = new TagRouterRule();
        tagRouterRule.parseFromMap0(map);
        Object tags = map.get("tags");
        if (tags != null && List.class.isAssignableFrom(tags.getClass())) {
            tagRouterRule.setTags(((List)tags).stream().map(objMap -> Tag.parseFromMap(objMap, tagRouterRule.getVersion())).collect(Collectors.toList()));
        }
        return tagRouterRule;
    }

    public void init(TagStateRouter<?> router) {
        if (!this.isValid()) {
            return;
        }
        BitList<Invoker<?>> invokers = router.getInvokers();
        this.tags.stream().filter(tag -> CollectionUtils.isNotEmpty(tag.getAddresses())).forEach(tag -> {
            this.tagnameToAddresses.put(tag.getName(), new HashSet<String>(tag.getAddresses()));
            tag.getAddresses().forEach(addr -> {
                Set tagNames = this.addressToTagnames.computeIfAbsent((String)addr, k -> new HashSet());
                tagNames.add(tag.getName());
            });
        });
        if (this.getVersion() != null && this.getVersion().startsWith("v3.0") && CollectionUtils.isNotEmpty(invokers)) {
            this.tags.stream().filter(tag -> CollectionUtils.isEmpty(tag.getAddresses())).forEach(tag -> {
                HashSet addresses = new HashSet();
                List<ParamMatch> paramMatchers = tag.getMatch();
                invokers.forEach(invoker -> {
                    boolean isMatch = true;
                    for (ParamMatch matcher : paramMatchers) {
                        if (matcher.isMatch(invoker.getUrl().getOriginalParameter(matcher.getKey()))) continue;
                        isMatch = false;
                        break;
                    }
                    if (isMatch) {
                        addresses.add(invoker.getUrl().getAddress());
                    }
                });
                if (CollectionUtils.isNotEmpty(addresses)) {
                    this.tagnameToAddresses.put(tag.getName(), addresses);
                }
            });
        }
    }

    public Set<String> getAddresses() {
        return this.tagnameToAddresses.entrySet().stream().filter(entry -> CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public List<String> getTagNames() {
        return this.tags.stream().map(Tag::getName).collect(Collectors.toList());
    }

    public Map<String, Set<String>> getAddressToTagnames() {
        return this.addressToTagnames;
    }

    public Map<String, Set<String>> getTagnameToAddresses() {
        return this.tagnameToAddresses;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }
}

