/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.loadbalance;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AdaptiveMetrics;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.support.RpcUtils;

public class AdaptiveLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "adaptive";
    private String attachmentKey = "mem,load";
    private final AdaptiveMetrics adaptiveMetrics;

    public AdaptiveLoadBalance(ApplicationModel scopeModel) {
        this.adaptiveMetrics = (AdaptiveMetrics)scopeModel.getBeanFactory().getBean(AdaptiveMetrics.class);
    }

    @Override
    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        Invoker<T> invoker = this.selectByP2C(invokers, invocation);
        invocation.setAttachment("lb_adaptive", this.attachmentKey);
        long startTime = System.currentTimeMillis();
        invocation.getAttributes().put("adaptive_startTime", startTime);
        invocation.getAttributes().put("loadbalance", NAME);
        this.adaptiveMetrics.addConsumerReq(this.getServiceKey(invoker, invocation));
        this.adaptiveMetrics.setPickTime(this.getServiceKey(invoker, invocation), startTime);
        return invoker;
    }

    private <T> Invoker<T> selectByP2C(List<Invoker<T>> invokers, Invocation invocation) {
        int length = invokers.size();
        if (length == 1) {
            return invokers.get(0);
        }
        if (length == 2) {
            return this.chooseLowLoadInvoker(invokers.get(0), invokers.get(1), invocation);
        }
        int pos1 = ThreadLocalRandom.current().nextInt(length);
        int pos2 = ThreadLocalRandom.current().nextInt(length - 1);
        if (pos2 >= pos1) {
            ++pos2;
        }
        return this.chooseLowLoadInvoker(invokers.get(pos1), invokers.get(pos2), invocation);
    }

    private String getServiceKey(Invoker<?> invoker, Invocation invocation) {
        String key = (String)invocation.getAttributes().get(invoker);
        if (StringUtils.isNotEmpty((String)key)) {
            return key;
        }
        key = this.buildServiceKey(invoker, invocation);
        invocation.getAttributes().put(invoker, key);
        return key;
    }

    private String buildServiceKey(Invoker<?> invoker, Invocation invocation) {
        URL url = invoker.getUrl();
        StringBuilder sb = new StringBuilder(128);
        sb.append(url.getAddress()).append(":").append(invocation.getProtocolServiceKey());
        return sb.toString();
    }

    private int getTimeout(Invoker<?> invoker, Invocation invocation) {
        URL url = invoker.getUrl();
        String methodName = RpcUtils.getMethodName((Invocation)invocation);
        return (int)RpcUtils.getTimeout((URL)url, (String)methodName, (RpcContext)RpcContext.getClientAttachment(), (Invocation)invocation, (long)1000L);
    }

    private <T> Invoker<T> chooseLowLoadInvoker(Invoker<T> invoker1, Invoker<T> invoker2, Invocation invocation) {
        long load2;
        int weight1 = this.getWeight(invoker1, invocation);
        int weight2 = this.getWeight(invoker2, invocation);
        int timeout1 = this.getTimeout(invoker1, invocation);
        int timeout2 = this.getTimeout(invoker2, invocation);
        long load1 = Double.doubleToLongBits(this.adaptiveMetrics.getLoad(this.getServiceKey(invoker1, invocation), weight1, timeout1));
        if (load1 == (load2 = Double.doubleToLongBits(this.adaptiveMetrics.getLoad(this.getServiceKey(invoker2, invocation), weight2, timeout2)))) {
            int totalWeight = weight1 + weight2;
            if (totalWeight > 0) {
                int offset = ThreadLocalRandom.current().nextInt(totalWeight);
                if (offset < weight1) {
                    return invoker1;
                }
                return invoker2;
            }
            return ThreadLocalRandom.current().nextInt(2) == 0 ? invoker1 : invoker2;
        }
        return load1 > load2 ? invoker2 : invoker1;
    }
}

