/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.compact;

import java.lang.reflect.Constructor;
import org.apache.dubbo.rpc.service.GenericException;

public class Dubbo2GenericExceptionUtils {
    private static final Class<? extends GenericException> GENERIC_EXCEPTION_CLASS = Dubbo2GenericExceptionUtils.loadClass();
    private static final Constructor<? extends GenericException> GENERIC_EXCEPTION_CONSTRUCTOR = Dubbo2GenericExceptionUtils.loadConstructor(new Class[0]);
    private static final Constructor<? extends GenericException> GENERIC_EXCEPTION_CONSTRUCTOR_S = Dubbo2GenericExceptionUtils.loadConstructor(String.class);
    private static final Constructor<? extends GenericException> GENERIC_EXCEPTION_CONSTRUCTOR_S_S = Dubbo2GenericExceptionUtils.loadConstructor(String.class, String.class);
    private static final Constructor<? extends GenericException> GENERIC_EXCEPTION_CONSTRUCTOR_T = Dubbo2GenericExceptionUtils.loadConstructor(Throwable.class);
    private static final Constructor<? extends GenericException> GENERIC_EXCEPTION_CONSTRUCTOR_S_T_S_S = Dubbo2GenericExceptionUtils.loadConstructor(String.class, Throwable.class, String.class, String.class);

    private static Class<? extends GenericException> loadClass() {
        try {
            Class<?> clazz = Class.forName("com.alibaba.dubbo.rpc.service.GenericException");
            if (GenericException.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Constructor<? extends GenericException> loadConstructor(Class<?> ... parameterTypes) {
        if (GENERIC_EXCEPTION_CLASS == null) {
            return null;
        }
        try {
            return GENERIC_EXCEPTION_CLASS.getConstructor(parameterTypes);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isGenericExceptionClassLoaded() {
        return GENERIC_EXCEPTION_CLASS != null && GENERIC_EXCEPTION_CONSTRUCTOR != null && GENERIC_EXCEPTION_CONSTRUCTOR_S != null && GENERIC_EXCEPTION_CONSTRUCTOR_S_S != null && GENERIC_EXCEPTION_CONSTRUCTOR_T != null && GENERIC_EXCEPTION_CONSTRUCTOR_S_T_S_S != null;
    }

    public static Class<? extends GenericException> getGenericExceptionClass() {
        return GENERIC_EXCEPTION_CLASS;
    }

    public static GenericException newGenericException() {
        if (GENERIC_EXCEPTION_CONSTRUCTOR == null) {
            return null;
        }
        try {
            return GENERIC_EXCEPTION_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static GenericException newGenericException(String exceptionMessage) {
        if (GENERIC_EXCEPTION_CONSTRUCTOR_S == null) {
            return null;
        }
        try {
            return GENERIC_EXCEPTION_CONSTRUCTOR_S.newInstance(exceptionMessage);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static GenericException newGenericException(String exceptionClass, String exceptionMessage) {
        if (GENERIC_EXCEPTION_CONSTRUCTOR_S_S == null) {
            return null;
        }
        try {
            return GENERIC_EXCEPTION_CONSTRUCTOR_S_S.newInstance(exceptionClass, exceptionMessage);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static GenericException newGenericException(Throwable cause) {
        if (GENERIC_EXCEPTION_CONSTRUCTOR_T == null) {
            return null;
        }
        try {
            return GENERIC_EXCEPTION_CONSTRUCTOR_T.newInstance(cause);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static GenericException newGenericException(String message, Throwable cause, String exceptionClass, String exceptionMessage) {
        if (GENERIC_EXCEPTION_CONSTRUCTOR_S_T_S_S == null) {
            return null;
        }
        try {
            return GENERIC_EXCEPTION_CONSTRUCTOR_S_T_S_S.newInstance(message, cause, exceptionClass, exceptionMessage);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

