/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class PathMatcher {
    private static final String SEPARATOR = "/";
    private String path;
    private String version;
    private String group;
    private Integer port;
    private String[] pathSplits;
    private boolean hasPathVariable;
    private String contextPath;
    private String httpMethod;
    private boolean needCompareHttpMethod = true;
    private boolean needCompareServiceMethod = false;
    private Method method;

    public PathMatcher(String path) {
        this(path, null, null, null);
    }

    public PathMatcher(String path, String version, String group, Integer port) {
        this.path = path;
        this.dealPathVariable(path);
        this.version = version;
        this.group = group;
        this.port = port == null || port == -1 || port == 0 ? null : port;
    }

    public PathMatcher(String path, String version, String group, Integer port, String httpMethod) {
        this(path, version, group, port);
        this.setHttpMethod(httpMethod);
    }

    public PathMatcher(Method method) {
        this.method = method;
    }

    private void dealPathVariable(String path) {
        if (path == null) {
            return;
        }
        for (String pathSplit : this.pathSplits = path.split(SEPARATOR)) {
            if (!this.isPlaceHold(pathSplit)) continue;
            this.hasPathVariable = true;
            break;
        }
    }

    private void setPath(String path) {
        this.path = path;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath = this.contextPathFormat(contextPath);
        this.setPath(contextPath + this.path);
        this.dealPathVariable(this.path);
    }

    public static PathMatcher getInvokeCreatePathMatcher(String path, String version, String group, Integer port, String method) {
        return new PathMatcher(path, version, group, port, method).noNeedHttpMethodCompare();
    }

    public static PathMatcher getInvokeCreatePathMatcher(Method serviceMethod) {
        return new PathMatcher(serviceMethod).setNeedCompareServiceMethod(true);
    }

    public boolean hasPathVariable() {
        return this.hasPathVariable;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public PathMatcher setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    private PathMatcher noNeedHttpMethodCompare() {
        this.needCompareHttpMethod = false;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    private PathMatcher setNeedCompareServiceMethod(boolean needCompareServiceMethod) {
        this.needCompareServiceMethod = needCompareServiceMethod;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathMatcher that = (PathMatcher)o;
        return this.serviceMethodEqual(that, this) || this.pathMatch(that);
    }

    private boolean pathMatch(PathMatcher that) {
        return !that.needCompareServiceMethod && !this.needCompareServiceMethod && this.pathEqual(that) && Objects.equals(this.version, that.version) && this.httpMethodMatch(that) && Objects.equals(this.group, that.group) && Objects.equals(this.port, that.port);
    }

    private boolean httpMethodMatch(PathMatcher that) {
        return !that.needCompareHttpMethod || !this.needCompareHttpMethod ? true : Objects.equals(this.httpMethod, that.httpMethod);
    }

    private boolean serviceMethodEqual(PathMatcher thatPathMatcher, PathMatcher thisPathMatcher) {
        Method thatMethod = thatPathMatcher.method;
        Method thisMethod = thisPathMatcher.method;
        return thatMethod != null && thisMethod != null && (thatPathMatcher.needCompareServiceMethod || thisPathMatcher.needCompareServiceMethod) && thisMethod.getName().equals(thatMethod.getName()) && Arrays.equals(thisMethod.getParameterTypes(), thatMethod.getParameterTypes());
    }

    public int hashCode() {
        return Objects.hash(this.version, this.group, this.port);
    }

    private boolean pathEqual(PathMatcher pathMatcher) {
        if (this.path == null || pathMatcher.path == null) {
            return false;
        }
        if (!pathMatcher.hasPathVariable) {
            return this.path.equals(pathMatcher.path);
        }
        String[] thisPathSplits = this.pathSplits;
        String[] pathSplits = pathMatcher.pathSplits;
        if (thisPathSplits.length != pathSplits.length) {
            return false;
        }
        for (int i = 0; i < pathSplits.length; ++i) {
            boolean equals = thisPathSplits[i].equals(pathSplits[i]);
            if (equals || this.placeHoldCompare(pathSplits[i], thisPathSplits[i])) continue;
            return false;
        }
        return true;
    }

    private boolean placeHoldCompare(String pathSplit, String pathToCompare) {
        boolean lengthCondition;
        boolean startAndEndEqual;
        boolean bl = startAndEndEqual = this.isPlaceHold(pathSplit) || this.isPlaceHold(pathToCompare);
        if (!startAndEndEqual) {
            return false;
        }
        boolean bl2 = lengthCondition = pathSplit.length() >= 3 || pathToCompare.length() >= 3;
        return lengthCondition;
    }

    private boolean isPlaceHold(String pathSplit) {
        return pathSplit.startsWith("{") && pathSplit.endsWith("}");
    }

    private String contextPathFormat(String contextPath) {
        if (contextPath == null || contextPath.equals(SEPARATOR) || contextPath.length() == 0) {
            return "";
        }
        return this.pathFormat(contextPath);
    }

    private String pathFormat(String path) {
        if (path.startsWith(SEPARATOR)) {
            return path;
        }
        return SEPARATOR + path;
    }

    public String toString() {
        return "PathMatcher{path='" + this.path + '\'' + ", version='" + this.version + '\'' + ", group='" + this.group + '\'' + ", port=" + this.port + ", hasPathVariable=" + this.hasPathVariable + ", contextPath='" + this.contextPath + '\'' + ", httpMethod='" + this.httpMethod + '\'' + '}';
    }
}

